/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.ValidatorContext;

public class AllOf
extends Keyword {
    public static final String NAME = "allOf";

    public AllOf() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (!value.isJsonArray() || value.getAsJsonArray().size() == 0) {
            context.schemaError("not a non-empty array");
            return false;
        }
        int index = 0;
        StringBuilder sb = new StringBuilder();
        for (JsonElement e : value.getAsJsonArray()) {
            String name;
            if (!context.apply(e, name = Integer.toString(index), null, instance, null)) {
                if (context.isFailFast()) {
                    return false;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                } else {
                    sb.append("invalid subschemas: ");
                }
                sb.append(index);
            }
            ++index;
        }
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

