/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Numbers;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.ValidatorContext;
import java.math.BigDecimal;

public class Contains
extends Keyword {
    public static final String NAME = "contains";

    public Contains() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        BigDecimal n;
        JsonElement minContains;
        context.checkValidSchema(value);
        if (!instance.isJsonArray()) {
            return true;
        }
        int validCount = 0;
        int index = 0;
        for (JsonElement e : instance.getAsJsonArray()) {
            if (!context.apply(value, null, null, e, Integer.toString(index++))) continue;
            ++validCount;
        }
        boolean allowZero = false;
        if (context.specification().compareTo(Specification.DRAFT_2019_09) >= 0 && (minContains = parent.get("minContains")) != null && JSON.isNumber(minContains) && (n = Numbers.valueOf(minContains.getAsString())).signum() == 0) {
            allowZero = true;
        }
        if (allowZero || validCount > 0) {
            context.addLocalAnnotation(NAME, validCount);
            return true;
        }
        return false;
    }
}

