/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Option;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;

public class ContentEncoding
extends Keyword {
    public static final String NAME = "contentEncoding";

    public ContentEncoding() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_07) < 0) {
            return true;
        }
        if (!JSON.isString(value)) {
            context.schemaError("not a string");
            return false;
        }
        if (!JSON.isString(instance)) {
            return true;
        }
        context.addAnnotation(NAME, value.getAsString());
        return !context.isOption(Option.CONTENT) || !value.getAsString().equalsIgnoreCase("base64") || Strings.isBase64(instance.getAsString());
    }
}

