/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Option;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.ValidatorContext;
import com.qindesign.json.schema.util.Base64InputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentMediaType
extends Keyword {
    public static final String NAME = "contentMediaType";
    private static final String TOKEN = "[!#$%&'*+-.0-9A-Z^_`a-z{|}~]+";
    private static final Pattern CONTENT_TYPE = Pattern.compile("^(?<mediaType>[!#$%&'*+-.0-9A-Z^_`a-z{|}~]+/[!#$%&'*+-.0-9A-Z^_`a-z{|}~]+)(?:\\s*;\\s*[!#$%&'*+-.0-9A-Z^_`a-z{|}~]+=(?:[!#$%&'*+-.0-9A-Z^_`a-z{|}~]+|\"(?:[ -~&&[^\"]]|\\\\[\\x00-\\x7f])*\"))*\\s*$");

    public ContentMediaType() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_07) < 0) {
            return true;
        }
        if (!JSON.isString(value)) {
            context.schemaError("not a string");
            return false;
        }
        if (!JSON.isString(instance)) {
            return true;
        }
        context.addAnnotation(NAME, value.getAsString());
        if (context.isOption(Option.CONTENT)) {
            Matcher m = CONTENT_TYPE.matcher(value.getAsString());
            if (m.matches()) {
                String contentType = m.group("mediaType");
                if (contentType.equalsIgnoreCase("application/json")) {
                    boolean base64 = false;
                    JsonElement encoding = parent.get("contentEncoding");
                    if (encoding != null && JSON.isString(encoding) && encoding.getAsString().equalsIgnoreCase("base64")) {
                        base64 = true;
                    }
                    Reader content = base64 ? new InputStreamReader((InputStream)new Base64InputStream(instance.getAsString()), StandardCharsets.UTF_8) : new StringReader(instance.getAsString());
                    try (StringReader r = content;){
                        JSON.parse(r);
                    }
                    catch (JsonParseException ex) {
                        if (ex.getCause() instanceof IOException) {
                            context.addError(false, "bad base64 encoding");
                        } else {
                            context.addError(false, "does not validate against application/json");
                        }
                        return false;
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
            } else {
                context.addError(false, "invalid media type: " + value.getAsString());
                return false;
            }
        }
        return true;
    }
}

