/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Id;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Option;
import com.qindesign.json.schema.Options;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.URIs;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.ValidatorContext;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CoreSchema
extends Keyword {
    public static final String NAME = "$schema";

    public CoreSchema() {
        super(NAME);
    }

    @Override
    public boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        Map<URI, Id> ids;
        URI id;
        if (!JSON.isString(value)) {
            context.schemaError("not a string");
            return false;
        }
        try {
            id = URI.parse(value.getAsString());
        }
        catch (URISyntaxException ex) {
            context.schemaError("not a URI");
            return false;
        }
        if (!id.isAbsolute()) {
            context.schemaError("missing scheme");
            return false;
        }
        URI normalized = id.normalize();
        if (!normalized.equals(id)) {
            context.schemaError("not normalized");
            return false;
        }
        if (!context.isRootSchema() && !parent.has("$id")) {
            context.schemaError("appearance in non-resource subschema");
            return false;
        }
        id = URIs.stripFragment(id);
        Set<URI> validated = context.validatedSchemas();
        if (validated.contains(id)) {
            return true;
        }
        Specification spec = Specification.of(id);
        if (spec == null) {
            context.schemaError("unknown schema ID");
            return false;
        }
        JsonElement schema = Validator.loadResource(id);
        if (schema == null) {
            context.schemaError("unknown schema resource");
            return false;
        }
        if (!Validator.isSchema(schema)) {
            context.schemaError("resource not a schema: " + id);
        }
        validated = new HashSet<URI>(validated);
        validated.add(context.baseURI());
        try {
            ids = Validator.scanIDs(id, schema, spec);
        }
        catch (MalformedSchemaException ex) {
            context.schemaError("malformed schema: " + id + ": " + ex.getMessage());
            return false;
        }
        Options opts2 = new Options();
        opts2.set(Option.FORMAT, false);
        opts2.set(Option.CONTENT, false);
        opts2.set(Option.DEFAULT_SPECIFICATION, (Object)spec);
        ValidatorContext context2 = new ValidatorContext(id, schema, true, ids, context.knownURLs(), validated, opts2);
        if (!context2.apply((JsonElement)parent, new HashMap(), null)) {
            context.schemaError("does not validate");
            return false;
        }
        if (context.validatedSchemas().isEmpty()) {
            context2.vocabularies().forEach(context::setVocabulary);
        }
        context.setSpecification(spec);
        return true;
    }
}

