/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.ValidatorContext;
import java.util.Map;

public class Definitions
extends Keyword {
    public static final String NAME = "definitions";

    public Definitions() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_2019_09) >= 0) {
            return true;
        }
        if (!value.isJsonObject()) {
            context.schemaError("not an object");
            return false;
        }
        for (Map.Entry e : value.getAsJsonObject().entrySet()) {
            if (Validator.isSchema((JsonElement)e.getValue())) continue;
            context.schemaError("not a schema", (String)e.getKey());
            return false;
        }
        return true;
    }
}

