/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;
import java.util.Map;

public class DependentSchemas
extends Keyword {
    public static final String NAME = "dependentSchemas";

    public DependentSchemas() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_2019_09) < 0) {
            return true;
        }
        if (!value.isJsonObject()) {
            context.schemaError("not an object");
            return false;
        }
        if (!instance.isJsonObject()) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        JsonObject object = instance.getAsJsonObject();
        for (Map.Entry e : value.getAsJsonObject().entrySet()) {
            if (!object.has((String)e.getKey()) || context.apply((JsonElement)e.getValue(), (String)e.getKey(), null, instance, null)) continue;
            if (context.isFailFast()) {
                return false;
            }
            if (sb.length() > 0) {
                sb.append(", \"");
            } else {
                sb.append("invalid dependent properties: \"");
            }
            sb.append(Strings.jsonString((String)e.getKey())).append('\"');
        }
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

