/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Option;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.ValidatorContext;
import com.qindesign.json.schema.Vocabulary;
import com.qindesign.json.schema.net.Hostname;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URIParser;
import com.qindesign.json.schema.net.URISyntaxException;
import com.qindesign.json.schema.util.Ecma262Pattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Format
extends Keyword {
    public static final String NAME = "format";
    private static final String FULL_DATE_PATTERN = "(?<year>[0-9]{4})-(?<month>0[1-9]|1[0-2])-(?<mday>0[1-9]|[12][0-9]|3[01])";
    private static final String FULL_TIME_PATTERN = "(?:[01][0-9]|2[0-3]):[0-5][0-9]:(?:[0-5][0-9]|60)(?:\\.[0-9]+)?(?:[Zz]|[+-](?:[01][0-9]|2[0-3]):[0-5][0-9])";
    private static final String DATE_TIME_PATTERN = "(?<year>[0-9]{4})-(?<month>0[1-9]|1[0-2])-(?<mday>0[1-9]|[12][0-9]|3[01])[Tt](?:[01][0-9]|2[0-3]):[0-5][0-9]:(?:[0-5][0-9]|60)(?:\\.[0-9]+)?(?:[Zz]|[+-](?:[01][0-9]|2[0-3]):[0-5][0-9])";
    private static final Pattern DATE_TIME = Pattern.compile("^(?<year>[0-9]{4})-(?<month>0[1-9]|1[0-2])-(?<mday>0[1-9]|[12][0-9]|3[01])[Tt](?:[01][0-9]|2[0-3]):[0-5][0-9]:(?:[0-5][0-9]|60)(?:\\.[0-9]+)?(?:[Zz]|[+-](?:[01][0-9]|2[0-3]):[0-5][0-9])$");
    private static final Pattern FULL_DATE = Pattern.compile("^(?<year>[0-9]{4})-(?<month>0[1-9]|1[0-2])-(?<mday>0[1-9]|[12][0-9]|3[01])$");
    private static final Pattern FULL_TIME = Pattern.compile("^(?:[01][0-9]|2[0-3]):[0-5][0-9]:(?:[0-5][0-9]|60)(?:\\.[0-9]+)?(?:[Zz]|[+-](?:[01][0-9]|2[0-3]):[0-5][0-9])$");
    private static final int[] MDAY_MAX = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final String DUR_SECOND = "\\d+S";
    private static final String DUR_MINUTE = "\\d+M(?:\\d+S)?";
    private static final String DUR_HOUR = "\\d+H(?:\\d+M(?:\\d+S)?)?";
    private static final String DUR_TIME = "T(?:\\d+H(?:\\d+M(?:\\d+S)?)?|\\d+M(?:\\d+S)?|\\d+S)";
    private static final String DUR_DAY = "\\d+D";
    private static final String DUR_WEEK = "\\d+W";
    private static final String DUR_MONTH = "\\d+M(?:\\d+D)?";
    private static final String DUR_YEAR = "\\d+Y(?:\\d+M(?:\\d+D)?)?";
    private static final String DUR_DATE = "(?:\\d+D|\\d+M(?:\\d+D)?|\\d+Y(?:\\d+M(?:\\d+D)?)?)(?:T(?:\\d+H(?:\\d+M(?:\\d+S)?)?|\\d+M(?:\\d+S)?|\\d+S))?";
    private static final Pattern DURATION = Pattern.compile("^P(?:(?:\\d+D|\\d+M(?:\\d+D)?|\\d+Y(?:\\d+M(?:\\d+D)?)?)(?:T(?:\\d+H(?:\\d+M(?:\\d+S)?)?|\\d+M(?:\\d+S)?|\\d+S))?|T(?:\\d+H(?:\\d+M(?:\\d+S)?)?|\\d+M(?:\\d+S)?|\\d+S)|\\d+W)$");
    private static final Pattern EMAIL = Pattern.compile("^(?!\\.)(?:[^.]|\\.(?!\\.))*[^\\\\.]@[^@]+$");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern UUID = Pattern.compile("^\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}$");
    private static final String TEMPLATE_VAR = "(?!\\.)(?:\\.?(\\w|%\\p{XDigit}{2}))+";
    private static final String TEMPLATE_MOD = ":[1-9]\\d{0,3}";
    private static final String TEMPLATE_VARSPEC = "(?!\\.)(?:\\.?(\\w|%\\p{XDigit}{2}))+(?::[1-9]\\d{0,3})?";
    private static final String TEMPLATE_VARLIST = "(?!,)(?:,?(?!\\.)(?:\\.?(\\w|%\\p{XDigit}{2}))+(?::[1-9]\\d{0,3})?)+";
    private static final Pattern TEMPLATE_EXPR = Pattern.compile("^[+#./;?&=,!@|]?(?!,)(?:,?(?!\\.)(?:\\.?(\\w|%\\p{XDigit}{2}))+(?::[1-9]\\d{0,3})?)+$");
    private static final Pattern JSON_POINTER_PATTERN = Pattern.compile("(?:/(?:[^/~]|~[01])*)*");
    static final Pattern JSON_POINTER = Pattern.compile("^" + JSON_POINTER_PATTERN + "$");
    private static final Pattern RELATIVE_JSON_POINTER = Pattern.compile("^(?:0|[1-9]\\d*)(?:#|" + JSON_POINTER_PATTERN + ")$");

    public Format() {
        super(NAME);
    }

    private static boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 100 != 0) {
            return true;
        }
        return year % 400 == 0;
    }

    private static void appendPctHex(StringBuilder sb, int v) {
        sb.append('%');
        sb.append(HEX_DIGITS[v >> 4]);
        sb.append(HEX_DIGITS[v & 0xF]);
    }

    private static String iriToURI(String iri) {
        StringBuilder sb = new StringBuilder();
        iri.codePoints().forEach(c -> {
            if (c < 128) {
                sb.append((char)c);
            } else if (c < 2048) {
                if (c >= 160) {
                    Format.appendPctHex(sb, 0xC0 | c >> 6);
                    Format.appendPctHex(sb, 0x80 | c & 0x3F);
                } else {
                    sb.appendCodePoint(c);
                }
            } else if (c < 65536) {
                if (c <= 55295 || 57344 <= c && c < 64976 || 65008 <= c && c < 65520) {
                    Format.appendPctHex(sb, 0xE0 | c >> 12);
                    Format.appendPctHex(sb, 0x80 | c >> 6 & 0x3F);
                    Format.appendPctHex(sb, 0x80 | c & 0x3F);
                } else {
                    sb.appendCodePoint(c);
                }
            } else if (c < 0x110000) {
                if ((c & 0xFFFE) == 65534 || 917504 <= c && c < 921600) {
                    sb.appendCodePoint(c);
                } else {
                    Format.appendPctHex(sb, 0xF0 | c >> 18);
                    Format.appendPctHex(sb, 0x80 | c >> 12 & 0x3F);
                    Format.appendPctHex(sb, 0x80 | c >> 6 & 0x3F);
                    Format.appendPctHex(sb, 0x80 | c & 0x3F);
                }
            }
        });
        return sb.toString();
    }

    private static boolean checkURITemplate(String s) {
        int exprIndex = -1;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '{': {
                    if (exprIndex >= 0) {
                        return false;
                    }
                    exprIndex = i + 1;
                    continue block4;
                }
                case '}': {
                    if (exprIndex < 0) {
                        return false;
                    }
                    if (!TEMPLATE_EXPR.matcher(s.substring(exprIndex, i)).matches()) {
                        return false;
                    }
                    exprIndex = -1;
                    continue block4;
                }
            }
        }
        return exprIndex < 0;
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (!JSON.isString(value)) {
            context.schemaError("not a string");
            return false;
        }
        Boolean vocab = false;
        if (context.specification().compareTo(Specification.DRAFT_2019_09) >= 0 && (vocab = context.vocabularies().get(Vocabulary.FORMAT.id())) == null) {
            vocab = false;
        }
        context.addAnnotation(NAME, value.getAsString());
        if (Boolean.FALSE.equals(vocab) && !context.isOption(Option.FORMAT)) {
            return true;
        }
        if (!JSON.isString(instance)) {
            return true;
        }
        String string = instance.getAsString();
        switch (value.getAsString()) {
            case "date-time": 
            case "date": 
            case "full-date": {
                Matcher m = value.getAsString().equals("date-time") ? DATE_TIME.matcher(string) : FULL_DATE.matcher(string);
                if (!m.matches()) {
                    return false;
                }
                try {
                    int year;
                    int month = Integer.parseInt(m.group("month"));
                    int mday = Integer.parseInt(m.group("mday"));
                    if (mday > MDAY_MAX[month]) {
                        return false;
                    }
                    if (month == 2 && !Format.isLeapYear(year = Integer.parseInt(m.group("year"))) && mday > 28) {
                        return false;
                    }
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException month) {}
                break;
            }
            case "time": 
            case "full-time": {
                if (FULL_TIME.matcher(string).matches()) break;
                return false;
            }
            case "duration": {
                if (DURATION.matcher(string).matches()) break;
                return false;
            }
            case "email": 
            case "idn-email": {
                if (EMAIL.matcher(string).matches()) break;
                return false;
            }
            case "hostname": {
                if (Hostname.parseHostname(string)) break;
                return false;
            }
            case "idn-hostname": {
                if (Hostname.parseIDNHostname(string)) break;
                return false;
            }
            case "ipv4": {
                try {
                    URIParser.parseIPv4(string, 0, string.length(), "");
                    break;
                }
                catch (URISyntaxException ex) {
                    return false;
                }
            }
            case "ipv6": {
                try {
                    URIParser.parseIPv6(string, 0, string.length(), "");
                    break;
                }
                catch (URISyntaxException ex) {
                    return false;
                }
            }
            case "uri": 
            case "uri-reference": {
                try {
                    URI uri = URI.parse(string);
                    if (value.getAsString().equals("uri")) {
                        return uri.isAbsolute();
                    }
                    break;
                }
                catch (URISyntaxException ex) {
                    return false;
                }
            }
            case "iri": 
            case "iri-reference": {
                try {
                    URI uri = URI.parse(Format.iriToURI(string));
                    if (value.getAsString().equals("iri")) {
                        return uri.isAbsolute();
                    }
                    break;
                }
                catch (URISyntaxException ex) {
                    return false;
                }
            }
            case "uuid": {
                if (UUID.matcher(string).matches()) break;
                return false;
            }
            case "uri-template": {
                if (Format.checkURITemplate(string)) break;
                return false;
            }
            case "json-pointer": {
                if (JSON_POINTER.matcher(string).matches()) break;
                return false;
            }
            case "relative-json-pointer": {
                if (RELATIVE_JSON_POINTER.matcher(string).matches()) break;
                return false;
            }
            case "regex": {
                try {
                    Pattern.compile(Ecma262Pattern.translate(string));
                    break;
                }
                catch (PatternSyntaxException ex) {
                    return false;
                }
            }
        }
        return true;
    }
}

