/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.ValidatorContext;

public class If
extends Keyword {
    public static final String NAME = "if";
    private final Applier thenK = new Applier("then");
    private final Applier elseK = new Applier("else");

    public If() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_07) < 0) {
            return true;
        }
        if (context.apply(value, null, null, instance, null)) {
            JsonElement e = parent.get("then");
            if (e != null) {
                return context.applyKeyword(this.thenK, e, instance);
            }
        } else {
            JsonElement e = parent.get("else");
            if (e != null) {
                return context.applyKeyword(this.elseK, e, instance);
            }
        }
        return true;
    }

    private static final class Applier
    extends Keyword {
        protected Applier(String name) {
            super(name);
        }

        @Override
        protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
            return context.apply(value, null, null, instance, null);
        }
    }
}

