/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternProperties
extends Keyword {
    public static final String NAME = "patternProperties";

    public PatternProperties() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (!value.isJsonObject()) {
            context.schemaError("not an object");
            return false;
        }
        if (!instance.isJsonObject()) {
            return true;
        }
        JsonObject schemaObject = value.getAsJsonObject();
        JsonObject object = instance.getAsJsonObject();
        ArrayList<Map.Entry<String, Pattern>> patterns = new ArrayList<Map.Entry<String, Pattern>>(schemaObject.size());
        for (Map.Entry e : schemaObject.entrySet()) {
            try {
                patterns.add(Map.entry((String)e.getKey(), context.pattern((String)e.getKey())));
            }
            catch (PatternSyntaxException ex) {
                context.schemaError("not a valid pattern", (String)e.getKey());
                return false;
            }
            context.checkValidSchema((JsonElement)e.getValue(), (String)e.getKey());
        }
        StringBuilder sb = new StringBuilder();
        HashSet<String> validated = new HashSet<String>();
        for (Map.Entry e : object.entrySet()) {
            for (Map.Entry entry : patterns) {
                if (!((Pattern)entry.getValue()).matcher((CharSequence)e.getKey()).find()) continue;
                if (!context.apply(schemaObject.get((String)entry.getKey()), (String)entry.getKey(), null, (JsonElement)e.getValue(), (String)e.getKey())) {
                    if (context.isFailFast()) {
                        return false;
                    }
                    if (sb.length() > 0) {
                        sb.append(", \"");
                    } else {
                        sb.append("invalid properties: \"");
                    }
                    sb.append(Strings.jsonString((String)e.getKey())).append("\" matches \"").append(Strings.jsonString((String)entry.getKey())).append('\"');
                }
                validated.add((String)e.getKey());
            }
        }
        context.addAnnotation(NAME, validated);
        context.addLocalAnnotation(NAME, validated);
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

