/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.ValidatorContext;

public class ReadOnly
extends Keyword {
    public static final String NAME = "readOnly";

    public ReadOnly() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_07) < 0) {
            return true;
        }
        if (!JSON.isBoolean(value)) {
            context.schemaError("not a Boolean");
            return false;
        }
        context.addAnnotation(NAME, value.getAsBoolean());
        return true;
    }
}

