/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Numbers;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;
import java.math.BigDecimal;
import java.util.Collections;

public class Type
extends Keyword {
    public static final String NAME = "type";

    public Type() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        Object values;
        if (value.isJsonArray()) {
            values = value.getAsJsonArray();
        } else if (JSON.isString(value)) {
            values = Collections.singleton(value.getAsJsonPrimitive());
        } else {
            context.schemaError("not an array or string");
            return false;
        }
        int index = 0;
        for (JsonElement t : values) {
            if (!JSON.isString(t)) {
                context.schemaError("not a string", Integer.toString(index));
                return false;
            }
            switch (t.getAsString()) {
                case "null": {
                    if (!instance.isJsonNull()) break;
                    return true;
                }
                case "boolean": {
                    if (!JSON.isBoolean(instance)) break;
                    return true;
                }
                case "object": {
                    if (!instance.isJsonObject()) break;
                    return true;
                }
                case "array": {
                    if (!instance.isJsonArray()) break;
                    return true;
                }
                case "number": {
                    if (!JSON.isNumber(instance)) break;
                    return true;
                }
                case "integer": {
                    if (!JSON.isNumber(instance)) break;
                    BigDecimal n = Numbers.valueOf(instance.getAsString());
                    return Numbers.isInteger(n);
                }
                case "string": {
                    if (!JSON.isString(instance)) break;
                    return true;
                }
            }
            ++index;
        }
        if (JSON.isString(value)) {
            boolean vowel;
            String s = Strings.jsonString(value.getAsString());
            boolean bl = vowel = s.length() > 0 && "aeiouAEIOU".indexOf(s.charAt(0)) >= 0;
            if (vowel) {
                context.addError(false, "value not an \"" + s + "\"");
            } else {
                context.addError(false, "value not a \"" + s + "\"");
            }
        } else {
            StringBuilder sb = new StringBuilder();
            value.getAsJsonArray().forEach(e -> sb.append(", \"").append(Strings.jsonString(e.getAsString())).append('\"'));
            if (sb.length() == 0) {
                sb.append("[]");
            } else {
                sb.append(']').replace(0, 2, "[");
            }
            context.addError(false, "value not one of " + sb);
        }
        return false;
    }
}

