/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.net;

import com.ibm.icu.lang.UCharacter;
import java.net.IDN;
import java.util.BitSet;

public final class Hostname {
    private static final BitSet HOSTNAME_LABEL = new BitSet(128);
    private static final BitSet DIGIT = new BitSet(128);
    private static final int MASK_R_AL_AN = 70;
    private static final int MASK_L_R_AL = 7;
    private static final int MASK_L = 1;
    private static final int MASK_R_AL_EN_AN = 78;
    private static final int MASK_L_EN = 9;
    private static final int MASK_R_AL_AN_EN_ES_CS_ET_ON_BN_NSM = 9214;
    private static final int MASK_EN_AN = 72;
    private static final int MASK_L_EN_ES_CS_ET_ON_BN_NSM = 9145;

    private Hostname() {
    }

    public static boolean parseHostname(String s) {
        return Hostname.parseHostname(s, false);
    }

    public static boolean parseIDNHostname(String s) {
        return Hostname.parseHostname(s, true);
    }

    private static boolean parseHostname(String s, boolean idn) {
        int start = 0;
        int end = s.length();
        if (s.endsWith(".")) {
            --end;
        }
        if (end - start == 0 || end - start > 253) {
            return false;
        }
        while (start < end) {
            int partEnd = s.indexOf(46, start);
            if (partEnd < 0 || end <= partEnd) {
                partEnd = end;
            }
            if (!idn ? !Hostname.parseLabel(s, start, partEnd) : !Hostname.parseIDNLabel(s, start, partEnd)) {
                return false;
            }
            if (partEnd == end && Hostname.check(s, start, end, DIGIT)) {
                return false;
            }
            start = partEnd + 1;
        }
        return true;
    }

    private static boolean check(String s, int start, int end, BitSet chars) {
        while (start < end) {
            char c = s.charAt(start);
            if (c < '\u0080') {
                if (!chars.get(c)) {
                    return false;
                }
            } else {
                return false;
            }
            ++start;
        }
        return true;
    }

    public static boolean parseLabel(String s, int start, int end) {
        if (end - start < 1 || 63 < end - start) {
            return false;
        }
        if (s.charAt(start) == '-' || s.charAt(end - 1) == '-') {
            return false;
        }
        return Hostname.check(s, start, end, HOSTNAME_LABEL);
    }

    public static boolean parseIDNLabel(String s, int start, int end) {
        int charCount;
        if (s.startsWith("--", start + 2)) {
            if (s.startsWith("xn--", start)) {
                return !IDN.toUnicode(s = s.substring(start, end)).equals(s);
            }
            return false;
        }
        boolean uLabel = false;
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) < '\u0080') continue;
            uLabel = true;
            break;
        }
        if (!uLabel) {
            return Hostname.parseLabel(s, start, end);
        }
        if (s.charAt(start) == '-' || s.charAt(end - 1) == '-') {
            return false;
        }
        int c = s.codePointAt(start);
        switch (Character.getType(c)) {
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        try {
            if (IDN.toASCII(s.substring(start, end)).length() > 63) {
                return false;
            }
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        boolean validKMD = false;
        boolean validAID = false;
        boolean validEAID = false;
        block32: for (int i = start; i < end; i += charCount) {
            c = s.codePointAt(i);
            charCount = Character.charCount(c);
            if (i + charCount > end) {
                return false;
            }
            switch (c) {
                case 223: 
                case 962: 
                case 1789: 
                case 1790: 
                case 3851: 
                case 12295: {
                    continue block32;
                }
                case 1600: 
                case 2042: 
                case 12334: 
                case 12335: 
                case 12337: 
                case 12338: 
                case 12339: 
                case 12340: 
                case 12341: 
                case 12347: {
                    return false;
                }
                case 183: {
                    if (start < i && i < end - 1 && s.charAt(i - 1) == 'l' && s.charAt(i + 1) == 'l') continue block32;
                    return false;
                }
                case 885: {
                    int cp;
                    if (i + 1 < end && i + Character.charCount(cp = s.codePointAt(i + 1)) <= end && Character.UnicodeScript.of(cp) == Character.UnicodeScript.GREEK) continue block32;
                    return false;
                }
                case 1523: 
                case 1524: {
                    if (i >= start + Character.charCount(s.codePointAt(start)) && Character.UnicodeScript.of(s.codePointBefore(i)) == Character.UnicodeScript.HEBREW) continue block32;
                    return false;
                }
                case 12539: {
                    if (validKMD) continue block32;
                    int index = start;
                    while (index < end && !validKMD) {
                        int cp;
                        if ((index += Character.charCount(cp = s.codePointAt(index))) > end) {
                            return false;
                        }
                        Character.UnicodeScript script = Character.UnicodeScript.of(cp);
                        switch (script) {
                            case HIRAGANA: 
                            case KATAKANA: 
                            case HAN: {
                                validKMD = true;
                            }
                        }
                    }
                    if (validKMD) continue block32;
                    return false;
                }
                case 1632: 
                case 1633: 
                case 1634: 
                case 1635: 
                case 1636: 
                case 1637: 
                case 1638: 
                case 1639: 
                case 1640: 
                case 1641: {
                    char ch;
                    int j;
                    if (validAID) continue block32;
                    validAID = true;
                    for (j = start; j < end; ++j) {
                        ch = s.charAt(j);
                        if ('\u06f0' > ch || ch > '\u06f9') continue;
                        validAID = false;
                        break;
                    }
                    if (validAID) continue block32;
                    return false;
                }
                case 1776: 
                case 1777: 
                case 1778: 
                case 1779: 
                case 1780: 
                case 1781: 
                case 1782: 
                case 1783: 
                case 1784: 
                case 1785: {
                    char ch;
                    int j;
                    if (validEAID) continue block32;
                    validEAID = true;
                    for (j = start; j < end; ++j) {
                        ch = s.charAt(j);
                        if ('\u0660' > ch || ch > '\u0669') continue;
                        validEAID = false;
                        break;
                    }
                    if (validEAID) continue block32;
                    return false;
                }
                case 8204: 
                case 8205: {
                    if (i < start + Character.charCount(s.codePointAt(start))) {
                        return false;
                    }
                    int cp = s.codePointBefore(i);
                    if (UCharacter.getCombiningClass((int)cp) == 9) continue block32;
                    if (c == 8205) {
                        return false;
                    }
                    int index = i - Character.charCount(cp);
                    boolean found = false;
                    block36: while (index >= start && !found) {
                        switch (UCharacter.getIntPropertyValue((int)cp, (int)4103)) {
                            case 5: {
                                cp = s.codePointBefore(index);
                                index -= Character.charCount(cp);
                                continue block36;
                            }
                            case 2: 
                            case 3: {
                                found = true;
                                continue block36;
                            }
                        }
                        return false;
                    }
                    if (!found) {
                        return false;
                    }
                    index = i + charCount;
                    found = false;
                    block37: while (index < end && !found) {
                        if ((index += Character.charCount(cp = s.codePointAt(index))) > end) {
                            return false;
                        }
                        switch (UCharacter.getIntPropertyValue((int)cp, (int)4103)) {
                            case 5: {
                                continue block37;
                            }
                            case 2: 
                            case 4: {
                                found = true;
                                continue block37;
                            }
                        }
                        return false;
                    }
                    if (found) continue block32;
                    return false;
                }
                default: {
                    if (c < 128 && HOSTNAME_LABEL.get(c)) continue block32;
                    switch (Character.getType(c)) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: {
                            continue block32;
                        }
                        case 0: {
                            return false;
                        }
                    }
                    return false;
                }
            }
        }
        return Hostname.checkBidi(s, start, end);
    }

    private static boolean checkBidi(String s, int start, int end) {
        int c;
        int charCount;
        int mask = 0;
        boolean hasUndefined = false;
        for (int i = start; i < end; i += charCount) {
            int c2 = s.codePointAt(i);
            charCount = Character.charCount(c2);
            if (i + charCount > end) {
                if ((mask & 0x46) == 0) break;
                return false;
            }
            byte dir = Character.getDirectionality(c2);
            if (dir >= 0) {
                mask |= 1 << dir;
                continue;
            }
            hasUndefined = true;
        }
        if ((mask & 0x46) == 0) {
            return true;
        }
        byte dir = Character.getDirectionality(s.codePointAt(start));
        int firstMask = 0;
        if (dir >= 0) {
            firstMask |= 1 << dir;
        }
        if ((firstMask & 7) == 0) {
            return false;
        }
        int lastMask = 0;
        for (int index = end; index > start; index -= Character.charCount(c)) {
            c = s.codePointBefore(index);
            dir = Character.getDirectionality(c);
            if (dir == 8) continue;
            if (dir < 0) break;
            lastMask |= 1 << dir;
            break;
        }
        if ((firstMask & 1) == 0) {
            if ((lastMask & 0x4E) == 0) {
                return false;
            }
            if (hasUndefined || (mask & 0xFFFFDC01) != 0) {
                return false;
            }
            if ((mask & 0x48) == 72) {
                return false;
            }
        } else {
            if ((lastMask & 9) == 0) {
                return false;
            }
            if (hasUndefined || (mask & 0xFFFFDC46) != 0) {
                return false;
            }
        }
        return true;
    }

    static {
        HOSTNAME_LABEL.set(65, 91);
        HOSTNAME_LABEL.set(97, 123);
        HOSTNAME_LABEL.set(48, 58);
        HOSTNAME_LABEL.set(45);
        DIGIT.set(48, 58);
    }
}

