/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.net;

import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;
import java.util.BitSet;

public final class URIParser {
    private static final BitSet ALPHA = new BitSet(128);
    private static final BitSet DIGIT = new BitSet(128);
    private static final BitSet HEXDIG = new BitSet(128);
    private static final BitSet UNRESERVED = new BitSet(128);
    private static final BitSet SUB_DELIMS = new BitSet(128);
    private static final BitSet SCHEME = new BitSet(128);
    static final BitSet USERINFO = new BitSet(128);
    private static final BitSet IPVFUTURE = new BitSet(128);
    static final BitSet REG_NAME = new BitSet(128);
    static final BitSet PATH = new BitSet(128);
    static final BitSet QUERY_OR_FRAGMENT = new BitSet(128);
    private final String s;
    String scheme = null;
    String authority = null;
    String path = "";
    String query = null;
    String fragment = null;
    String userInfo = null;
    String host = null;
    int port = -1;

    URIParser(String s) {
        this.s = s;
    }

    private static int scan(String s, int start, int end, String stopChars) {
        while (start < end) {
            char c = s.charAt(start);
            if (stopChars.indexOf(c) >= 0) {
                return start;
            }
            ++start;
        }
        return end;
    }

    private static void check(String s, int start, int end, BitSet chars, String failMsg) throws URISyntaxException {
        while (start < end) {
            char c = s.charAt(start);
            if (c < '\u0080') {
                if (!chars.get(c)) {
                    throw new URISyntaxException(s, failMsg, start);
                }
                if (c == '%') {
                    if (start + 3 > end) {
                        throw new URISyntaxException(s, failMsg + ": unfinished percent-encoding", start);
                    }
                    URIParser.check(s, start + 1, start + 3, HEXDIG, failMsg + ": bad percent-encoding");
                    start += 2;
                }
            } else {
                throw new URISyntaxException(s, failMsg, start);
            }
            ++start;
        }
    }

    URI parse() throws URISyntaxException {
        int startIndex;
        int len = this.s.length();
        int index = URIParser.scan(this.s, 0, len, ":/?#");
        if (index < len) {
            if (this.s.charAt(index) != ':') {
                index = 0;
            } else {
                if (index == 0) {
                    throw new URISyntaxException(this.s, "Empty scheme", 0);
                }
                URIParser.check(this.s, 0, 1, ALPHA, "Bad scheme");
                URIParser.check(this.s, 1, index, SCHEME, "Bad scheme");
                this.scheme = this.s.substring(0, index);
                ++index;
            }
        } else {
            index = 0;
        }
        if (this.s.startsWith("//", index)) {
            startIndex = index + 2;
            index = URIParser.scan(this.s, startIndex, len, "/?#");
            this.parseAuthority(startIndex, index, "Bad authority");
        }
        startIndex = index;
        index = URIParser.scan(this.s, startIndex, len, "?#");
        URIParser.check(this.s, startIndex, index, PATH, "Bad path");
        this.path = this.s.substring(startIndex, index);
        if (index < len) {
            if (this.s.charAt(index) == '?') {
                startIndex = index + 1;
                if ((index = this.s.indexOf(35, startIndex)) < 0) {
                    index = len;
                }
                URIParser.check(this.s, startIndex, index, QUERY_OR_FRAGMENT, "Bad query");
                this.query = this.s.substring(startIndex, index);
            }
            if (index < len) {
                startIndex = index + 1;
                URIParser.check(this.s, startIndex, len, QUERY_OR_FRAGMENT, "Bad fragment");
                this.fragment = this.s.substring(startIndex);
            }
        }
        return new URI(this.scheme, this.authority, this.userInfo, this.host, this.port, this.path, this.query, this.fragment);
    }

    private void parseAuthority(int start, int end, String failMsg) throws URISyntaxException {
        int index = this.s.indexOf(64, start);
        if (0 <= index && index < end) {
            URIParser.check(this.s, start, index, USERINFO, failMsg + ": bad userinfo");
            this.userInfo = this.s.substring(start, index);
            ++index;
        } else {
            index = start;
        }
        if (index < end) {
            String failMsgHost = failMsg + ": bad host";
            if (this.s.charAt(index) == '[') {
                int bracketIndex;
                if ((bracketIndex = this.s.indexOf(93, ++index)) < 0 || end <= bracketIndex) {
                    throw new URISyntaxException(this.s, failMsgHost + ": missing end bracket", index);
                }
                if (bracketIndex - index < 2) {
                    throw new URISyntaxException(this.s, failMsgHost + ": bad IP-literal", index);
                }
                this.host = this.s.substring(index - 1, bracketIndex + 1);
                if (this.s.charAt(index) == 'v' || this.s.charAt(index) == 'V') {
                    int dotIndex;
                    String failMsgIP = failMsgHost + ": bad IPvFuture";
                    if ((dotIndex = this.s.indexOf(46, ++index)) < 0 || end <= dotIndex) {
                        throw new URISyntaxException(this.s, failMsgIP + ": missing version", index);
                    }
                    if (dotIndex - index < 1) {
                        throw new URISyntaxException(this.s, failMsgIP + ": empty version", index);
                    }
                    URIParser.check(this.s, index, dotIndex, HEXDIG, failMsgIP + ": bad version");
                    index = dotIndex + 1;
                    if (bracketIndex - index < 1) {
                        throw new URISyntaxException(this.s, failMsgIP + ": empty value", index);
                    }
                    URIParser.check(this.s, index, bracketIndex, IPVFUTURE, failMsgIP + ": bad value");
                } else {
                    URIParser.parseIPv6(this.s, index, bracketIndex, failMsgHost + ": bad IPv6address");
                }
                index = bracketIndex + 1;
            } else {
                int portIndex = this.s.indexOf(58, index);
                if (portIndex < 0 || end <= portIndex) {
                    portIndex = end;
                }
                URIParser.check(this.s, index, portIndex, REG_NAME, failMsgHost);
                this.host = this.s.substring(index, portIndex);
                index = portIndex;
            }
        } else {
            this.host = "";
        }
        if (index < end) {
            if (this.s.charAt(index) != ':') {
                throw new URISyntaxException(this.s, failMsg + ": expecting port", index);
            }
            if (++index < end) {
                URIParser.check(this.s, index, end, DIGIT, failMsg + ": bad port");
                this.port = Integer.parseInt(this.s, index, end, 10);
            }
        }
        this.authority = this.s.substring(start, end);
    }

    public static void parseIPv6(String s, int start, int end, String failMsg) throws URISyntaxException {
        boolean hasIPv4;
        int partEnd;
        int partIndex;
        int compressedIndex = -1;
        boolean lastPartEmpty = false;
        int wordCount = 0;
        int index = start;
        for (partIndex = 0; index < end && partIndex < 9 && (partEnd = s.indexOf(58, index)) >= 0 && end > partEnd; ++partIndex) {
            if (partEnd - index == 0) {
                if (partIndex >= 1) {
                    if (compressedIndex >= 0) {
                        throw new URISyntaxException(s, failMsg + ": too many compressed sections", index);
                    }
                    compressedIndex = partIndex;
                }
                lastPartEmpty = true;
            } else {
                if (partIndex == 1 && lastPartEmpty) {
                    throw new URISyntaxException(s, failMsg + ": expecting empty start", index);
                }
                if (partEnd - index > 4) {
                    throw new URISyntaxException(s, failMsg + ": word[" + wordCount + "] too large", index);
                }
                URIParser.check(s, index, partEnd, HEXDIG, failMsg + ": malformed word[" + wordCount + "]");
                ++wordCount;
                lastPartEmpty = false;
            }
            index = partEnd + 1;
        }
        if (partIndex < 2 || 9 <= partIndex) {
            throw new URISyntaxException(s, failMsg + ": wrong size", start);
        }
        if (end - index == 0) {
            if (!lastPartEmpty) {
                throw new URISyntaxException(s, failMsg + ": expecting empty end", index);
            }
            return;
        }
        ++wordCount;
        boolean bl = hasIPv4 = s.indexOf(46, index) >= 0;
        if (hasIPv4) {
            ++wordCount;
        }
        if (compressedIndex >= 0) {
            if (wordCount >= 8) {
                throw new URISyntaxException(s, failMsg + ": got " + wordCount + " words, want < 8 words with compressed section", start);
            }
        } else if (wordCount != 8) {
            throw new URISyntaxException(s, failMsg + ": got " + wordCount + " words, want 8 words", start);
        }
        if (hasIPv4) {
            URIParser.parseIPv4(s, index, end, failMsg + ": bad IPv4address part");
            return;
        }
        if (end - index > 4) {
            throw new URISyntaxException(s, failMsg + ": last word too large", index);
        }
        URIParser.check(s, index, end, HEXDIG, failMsg + ": malformed last word");
    }

    public static void parseIPv4(String s, int start, int end, String failMsg) throws URISyntaxException {
        for (int i = 0; i < 4; ++i) {
            int next = URIParser.scan(s, start, end, ".");
            if (next <= start) {
                throw new URISyntaxException(s, failMsg + ": empty octet[" + i + "]", start);
            }
            URIParser.check(s, start, next, DIGIT, failMsg + ": malformed octet[" + i + "]");
            int octet = Integer.parseInt(s, start, next, 10);
            if (octet > 255 || octet < 10 && next - start != 1 || 10 <= octet && octet < 100 && next - start != 2 || octet >= 100 && next - start != 3) {
                throw new URISyntaxException(s, failMsg + ": malformed octet[" + i + "]", start);
            }
            start = next + 1;
        }
        if (start != end + 1) {
            throw new URISyntaxException(s, failMsg + ": too many octets", start);
        }
    }

    static {
        ALPHA.set(65, 91);
        ALPHA.set(97, 123);
        DIGIT.set(48, 58);
        HEXDIG.set(48, 58);
        HEXDIG.set(65, 71);
        HEXDIG.set(97, 103);
        UNRESERVED.or(ALPHA);
        UNRESERVED.or(DIGIT);
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(95);
        UNRESERVED.set(126);
        SUB_DELIMS.set(33);
        SUB_DELIMS.set(36);
        SUB_DELIMS.set(38);
        SUB_DELIMS.set(39);
        SUB_DELIMS.set(40);
        SUB_DELIMS.set(41);
        SUB_DELIMS.set(42);
        SUB_DELIMS.set(43);
        SUB_DELIMS.set(44);
        SUB_DELIMS.set(59);
        SUB_DELIMS.set(61);
        SCHEME.or(ALPHA);
        SCHEME.or(DIGIT);
        SCHEME.set(48, 58);
        SCHEME.set(43);
        SCHEME.set(45);
        SCHEME.set(46);
        USERINFO.or(UNRESERVED);
        USERINFO.or(SUB_DELIMS);
        USERINFO.set(58);
        USERINFO.set(37);
        IPVFUTURE.or(UNRESERVED);
        IPVFUTURE.or(SUB_DELIMS);
        IPVFUTURE.set(58);
        REG_NAME.or(UNRESERVED);
        REG_NAME.or(SUB_DELIMS);
        REG_NAME.set(37);
        PATH.or(UNRESERVED);
        PATH.or(SUB_DELIMS);
        PATH.set(58);
        PATH.set(64);
        PATH.set(47);
        PATH.set(37);
        QUERY_OR_FRAGMENT.or(UNRESERVED);
        QUERY_OR_FRAGMENT.or(SUB_DELIMS);
        QUERY_OR_FRAGMENT.set(58);
        QUERY_OR_FRAGMENT.set(64);
        QUERY_OR_FRAGMENT.set(47);
        QUERY_OR_FRAGMENT.set(63);
        QUERY_OR_FRAGMENT.set(37);
    }
}

