/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.net;

import java.util.Objects;

public class URISyntaxException
extends Exception {
    private final String input;
    private final int index;

    public URISyntaxException(String input, String reason, int index) {
        super(reason);
        Objects.requireNonNull(input, "input");
        Objects.requireNonNull(reason, "reason");
        if (index < -1) {
            throw new IllegalArgumentException("index < -1");
        }
        this.input = input;
        this.index = index;
    }

    public String getInput() {
        return this.input;
    }

    public String getReason() {
        return super.getMessage();
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReason());
        if (this.index >= 0) {
            sb.append(" at index ").append(this.index);
        }
        sb.append(": ").append(this.input);
        return sb.toString();
    }
}

