/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.util;

import com.qindesign.json.schema.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class Base64InputStream
extends InputStream {
    private final String s;
    private int index;
    private final char[] buf = new char[4];
    private State state;
    private int b1;
    private int b2;
    private int b3;

    public Base64InputStream(String s) {
        Objects.requireNonNull(s, "s");
        this.s = s;
        this.index = 0;
        this.state = State.START;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        switch (this.state) {
            case START: {
                if (this.index >= this.s.length()) {
                    this.state = State.EOF;
                    return -1;
                }
                if (this.index + 4 > this.s.length()) {
                    throw new IOException("Extra bytes");
                }
                this.s.getChars(this.index, this.index + 4, this.buf, 0);
                this.index += 4;
                if ((this.buf[0] | this.buf[1] | this.buf[2] | this.buf[3]) > 255) {
                    throw new IOException("Bad Base64 characters");
                }
                int b0 = Strings.BASE64_BITS[this.buf[0]];
                this.b1 = Strings.BASE64_BITS[this.buf[1]];
                this.b2 = Strings.BASE64_BITS[this.buf[2]];
                this.b3 = Strings.BASE64_BITS[this.buf[3]];
                if ((b0 | this.b1 | this.b2 | this.b3) < 0) {
                    if (b0 < 0 || this.b1 < 0) {
                        if (b0 != -2 || this.b1 != -2 || this.b2 != -2 || this.b3 != -2) {
                            throw new IOException("Bad Base64 padding");
                        }
                        this.state = State.EOF;
                        if (this.index >= this.s.length()) return -1;
                        throw new IOException("Extra bytes");
                    }
                    if (this.b2 < 0) {
                        if (this.b2 != -2) throw new IOException("Bad Base64 padding");
                        if (this.b3 != -2) {
                            throw new IOException("Bad Base64 padding");
                        }
                        this.state = State.EOF;
                        return b0 << 2 | this.b1 >> 4;
                    } else {
                        if (this.b3 != -2) {
                            throw new IOException("Bad Base64 padding");
                        }
                        this.state = State.SECOND;
                    }
                    return b0 << 2 | this.b1 >> 4;
                } else {
                    this.state = State.SECOND;
                }
                return b0 << 2 | this.b1 >> 4;
            }
            case SECOND: {
                this.state = this.b3 == -2 ? State.EOF : State.THIRD;
                return this.b1 << 4 & 0xF0 | this.b2 >> 2;
            }
            case THIRD: {
                this.state = State.START;
                return this.b2 << 6 & 0xC0 | this.b3;
            }
        }
        if (this.index >= this.s.length()) return -1;
        throw new IOException("Extra bytes");
    }

    private static enum State {
        START,
        SECOND,
        THIRD,
        EOF;

    }
}

