/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class LRUCache<K, V> {
    private final Map<K, Entry> map = new HashMap<K, Entry>();
    private Entry head;
    private Entry tail;
    private int maxSize;
    private final Function<K, V> producer;

    public LRUCache(int maxSize, Function<K, V> producer) {
        Objects.requireNonNull(producer, "producer");
        this.setMaxSize(maxSize);
        this.producer = producer;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0: " + maxSize);
        }
        this.maxSize = maxSize;
        while (this.map.size() > maxSize) {
            this.map.remove(this.tail.key);
            this.remove(this.tail);
        }
    }

    public V get(K key) {
        Entry e = this.map.get(key);
        if (e == null) {
            return null;
        }
        this.remove(e);
        this.insertAtHead(e);
        return e.value;
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public V put(K key, V value) {
        Entry e = this.map.get(key);
        V prevValue = null;
        if (e != null) {
            prevValue = e.value;
            e.value = value;
            this.remove(e);
            this.insertAtHead(e);
        } else {
            e = new Entry(key, value);
            while (this.map.size() >= this.maxSize) {
                this.map.remove(this.tail.key);
                this.remove(this.tail);
            }
            this.insertAtHead(e);
            this.map.put(key, e);
        }
        return prevValue;
    }

    public V access(K key) {
        Object value;
        Entry e = this.map.get(key);
        if (e != null) {
            value = e.value;
            this.remove(e);
            this.insertAtHead(e);
        } else {
            value = this.producer.apply(key);
            e = new Entry(key, value);
            while (this.map.size() >= this.maxSize) {
                this.map.remove(this.tail.key);
                this.remove(this.tail);
            }
            this.insertAtHead(e);
            this.map.put(key, e);
        }
        return value;
    }

    private void remove(Entry e) {
        if (e.prev != null) {
            e.prev.next = e.next;
        } else {
            this.head = e.next;
        }
        if (e.next != null) {
            e.next.prev = e.prev;
        } else {
            this.tail = e.prev;
        }
    }

    private void insertAtHead(Entry e) {
        e.next = this.head;
        e.prev = null;
        if (this.head != null) {
            this.head.prev = e;
        }
        this.head = e;
        if (this.tail == null) {
            this.tail = e;
        }
    }

    private final class Entry {
        final K key;
        V value;
        Entry prev;
        Entry next;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

