/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.util;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Logging {
    public static void init(Logger logger, Level level) {
        Logger parentLogger = logger.getParent();
        parentLogger.setUseParentHandlers(false);
        parentLogger.setLevel(level);
        Handler[] handlers = parentLogger.getHandlers();
        if (handlers.length == 0) {
            ConsoleHandler h = new ConsoleHandler();
            h.setLevel(level);
            parentLogger.addHandler(h);
        } else {
            for (Handler h : handlers) {
                h.setLevel(level);
            }
        }
    }

    private Logging() {
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%3$s: %1$tc [%4$s] %5$s%6$s%n");
    }
}

