/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.BooleanConstant;
import com.querydsl.core.NumberConstant;
import com.querydsl.core.SimpleConstant;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import javax.annotation.Nullable;

public final class StringConstant
extends StringExpression
implements Constant<String> {
    private static final long serialVersionUID = 5182804405789674556L;
    private final String constant;
    @Nullable
    private volatile transient NumberExpression<Integer> length;
    @Nullable
    private volatile transient StringExpression lower;
    @Nullable
    private volatile transient StringExpression trim;
    @Nullable
    private volatile transient StringExpression upper;

    public static StringExpression create(String str) {
        return new StringConstant(str);
    }

    StringConstant(String constant) {
        super((Expression)ConstantImpl.create((Object)constant));
        this.constant = constant;
    }

    public <R, C> R accept(Visitor<R, C> v, C context) {
        return (R)v.visit((Constant)this, context);
    }

    public StringExpression append(Expression<String> s) {
        if (s instanceof Constant) {
            return this.append((String)((Constant)s).getConstant());
        }
        return super.append(s);
    }

    public StringExpression append(String s) {
        return new StringConstant(this.constant + s);
    }

    public SimpleExpression<Character> charAt(int i) {
        return SimpleConstant.create(Character.valueOf(this.constant.charAt(i)));
    }

    public StringExpression concat(String s) {
        return this.append(s);
    }

    public BooleanExpression eq(String s) {
        return BooleanConstant.create(this.constant.equals(s));
    }

    public BooleanExpression equalsIgnoreCase(String str) {
        return BooleanConstant.create(this.constant.equalsIgnoreCase(str));
    }

    public String getConstant() {
        return this.constant;
    }

    public BooleanExpression isEmpty() {
        return BooleanConstant.create(this.constant.isEmpty());
    }

    public BooleanExpression isNotEmpty() {
        return BooleanConstant.create(!this.constant.isEmpty());
    }

    public NumberExpression<Integer> length() {
        if (this.length == null) {
            this.length = NumberConstant.create(this.constant.length());
        }
        return this.length;
    }

    public StringExpression lower() {
        if (this.lower == null) {
            this.lower = new StringConstant(this.constant.toLowerCase());
        }
        return this.lower;
    }

    public BooleanExpression matches(String pattern) {
        return BooleanConstant.create(this.constant.matches(pattern));
    }

    public BooleanExpression ne(String s) {
        return BooleanConstant.create(!this.constant.equals(s));
    }

    public StringExpression prepend(Expression<String> s) {
        if (s instanceof Constant) {
            return this.prepend((String)((Constant)s).getConstant());
        }
        return super.prepend(s);
    }

    public StringExpression prepend(String s) {
        return new StringConstant(s + this.constant);
    }

    public StringExpression substring(int beginIndex) {
        return new StringConstant(this.constant.substring(beginIndex));
    }

    public StringExpression substring(int beginIndex, int endIndex) {
        return new StringConstant(this.constant.substring(beginIndex, endIndex));
    }

    public StringExpression toLowerCase() {
        return this.lower();
    }

    public StringExpression toUpperCase() {
        return this.upper();
    }

    public StringExpression trim() {
        if (this.trim == null) {
            this.trim = new StringConstant(this.constant.trim());
        }
        return this.trim;
    }

    public StringExpression upper() {
        if (this.upper == null) {
            this.upper = new StringConstant(this.constant.toUpperCase());
        }
        return this.upper;
    }
}

