/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.testutil.ThreadSafety;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.reflections.util.ClasspathHelper;

public class CycleClassInitDependencyTest {
    private static ClassLoader loader;

    @BeforeClass
    public static void overrideClassLoader() {
        loader = Thread.currentThread().getContextClassLoader();
        Collection urls = ClasspathHelper.forClassLoader();
        URLClassLoader cl = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), null);
        Thread.currentThread().setContextClassLoader(cl);
    }

    @AfterClass
    public static void resetClassLoader() {
        Thread.currentThread().setContextClassLoader(loader);
    }

    @Test(timeout=2000L)
    public void test() {
        ThreadSafety.check(new LoadClassRunnable("com.querydsl.core.types.dsl.NumberExpression"), new LoadClassRunnable("com.querydsl.core.types.dsl.Expressions"));
    }

    private static class LoadClassRunnable
    implements Runnable {
        private final String classToLoad;

        public LoadClassRunnable(String classToLoad) {
            this.classToLoad = classToLoad;
        }

        @Override
        public void run() {
            try {
                Class.forName(this.classToLoad, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

