/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.QueryResults;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class QueryResultsTest {
    private List<Integer> list = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    private QueryResults<Integer> results = new QueryResults(this.list, Long.valueOf(10L), Long.valueOf(0L), 20L);

    @Test
    public void getResults() {
        Assert.assertEquals(this.list, (Object)this.results.getResults());
    }

    @Test
    public void getTotal() {
        Assert.assertEquals((long)20L, (long)this.results.getTotal());
    }

    @Test
    public void isEmpty() {
        Assert.assertFalse((boolean)this.results.isEmpty());
    }

    @Test
    public void getLimit() {
        Assert.assertEquals((long)10L, (long)this.results.getLimit());
    }

    @Test
    public void getOffset() {
        Assert.assertEquals((long)0L, (long)this.results.getOffset());
    }

    @Test
    public void emptyResults() {
        QueryResults empty = QueryResults.emptyResults();
        Assert.assertTrue((boolean)empty.isEmpty());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)empty.getLimit());
        Assert.assertEquals((long)0L, (long)empty.getOffset());
        Assert.assertEquals((long)0L, (long)empty.getTotal());
        Assert.assertEquals(Collections.emptyList(), (Object)empty.getResults());
    }
}

