/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.ArrayConstructorExpression;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.ProjectionExample;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.QBeanPropertyTest;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringPath;
import org.junit.Assert;
import org.junit.Test;

public class ProjectionsTest {
    @Test
    public void array() {
        ArrayConstructorExpression expr = Projections.array(String[].class, (Expression[])new Expression[]{ExpressionUtils.path(String.class, (String)"p1"), ExpressionUtils.path(String.class, (String)"p2")});
        Assert.assertEquals(String[].class, ((String[])expr.newInstance(new Object[]{"1", "2"})).getClass());
    }

    @Test
    public void beanClassOfTExpressionOfQArray() {
        PathBuilder entity = new PathBuilder(QBeanPropertyTest.Entity.class, "entity");
        QBean beanProjection = Projections.bean(QBeanPropertyTest.Entity.class, (Expression[])new Expression[]{entity.getNumber("cId", Integer.class), entity.getNumber("eId", Integer.class)});
        Assert.assertEquals(QBeanPropertyTest.Entity.class, ((QBeanPropertyTest.Entity)beanProjection.newInstance(new Object[]{1, 2})).getClass());
    }

    @Test
    public void constructor() {
        Constant longVal = ConstantImpl.create((long)1L);
        Constant stringVal = ConstantImpl.create((Object)"");
        Assert.assertEquals(ProjectionExample.class, ((ProjectionExample)Projections.constructor(ProjectionExample.class, (Expression[])new Expression[]{longVal, stringVal}).newInstance(new Object[]{0L, ""})).getClass());
    }

    @Test
    public void constructor_varArgs() {
        Constant stringVal = ConstantImpl.create((Object)"");
        VarArgs instance = (VarArgs)Projections.constructor(VarArgs.class, (Expression[])new Expression[]{stringVal, stringVal}).newInstance(new Object[]{"X", "Y"});
        Assert.assertArrayEquals((Object[])new String[]{"X", "Y"}, (Object[])instance.args);
    }

    @Test
    public void constructor_varArgs2() {
        Constant stringVal = ConstantImpl.create((Object)"");
        VarArgs2 instance = (VarArgs2)Projections.constructor(VarArgs2.class, (Expression[])new Expression[]{stringVal, stringVal, stringVal}).newInstance(new Object[]{"X", "Y", "Z"});
        Assert.assertEquals((Object)"X", (Object)instance.arg);
        Assert.assertArrayEquals((Object[])new String[]{"Y", "Z"}, (Object[])instance.args);
    }

    @Test
    public void constructor_varArgs3() {
        Constant longVal = ConstantImpl.create((long)1L);
        Constant charVal = ConstantImpl.create((char)'\u0000');
        ProjectionExample instance = (ProjectionExample)Projections.constructor(ProjectionExample.class, (Expression[])new Expression[]{longVal, charVal, charVal, charVal, charVal, charVal, charVal, charVal, charVal, charVal, charVal}).newInstance(new Object[]{null, Character.valueOf('m'), Character.valueOf('y'), Character.valueOf('s'), Character.valueOf('e'), Character.valueOf('m'), Character.valueOf('a'), null, Character.valueOf('l'), Character.valueOf('t'), Character.valueOf('d')});
        Assert.assertEquals((long)0L, (long)instance.id);
        String expectedText = String.valueOf(new char[]{'m', 'y', 's', 'e', 'm', 'a', '\u0000', 'l', 't', 'd'});
        Assert.assertEquals((Object)expectedText, (Object)instance.text);
    }

    @Test
    public void fieldsClassOfTExpressionOfQArray() {
        PathBuilder entity = new PathBuilder(QBeanPropertyTest.Entity.class, "entity");
        QBean beanProjection = Projections.fields(QBeanPropertyTest.Entity.class, (Expression[])new Expression[]{entity.getNumber("cId", Integer.class), entity.getNumber("eId", Integer.class)});
        Assert.assertEquals(QBeanPropertyTest.Entity.class, ((QBeanPropertyTest.Entity)beanProjection.newInstance(new Object[]{1, 2})).getClass());
    }

    @Test
    public void nested() {
        StringPath str1 = Expressions.stringPath((String)"str1");
        StringPath str2 = Expressions.stringPath((String)"str2");
        StringPath str3 = Expressions.stringPath((String)"str3");
        ConstructorExpression entity = Projections.constructor(Entity1.class, (Expression[])new Expression[]{str1, str2});
        ConstructorExpression wrapper = Projections.constructor(Entity2.class, (Expression[])new Expression[]{str3, entity});
        FactoryExpression wrapped = FactoryExpressionUtils.wrap((FactoryExpression)wrapper);
        Entity2 w = (Entity2)wrapped.newInstance(new Object[]{"a", "b", "c"});
        Assert.assertEquals((Object)"a", (Object)w.arg1);
        Assert.assertEquals((Object)"b", (Object)w.entity.arg1);
        Assert.assertEquals((Object)"c", (Object)w.entity.arg2);
        w = (Entity2)wrapped.newInstance(new Object[]{"a", null, null});
        Assert.assertEquals((Object)"a", (Object)w.arg1);
        Assert.assertNotNull((Object)w.entity);
        w = (Entity2)wrapped.newInstance(new Object[]{null, null, null});
        Assert.assertNotNull((Object)w.entity);
    }

    @Test
    public void nestedSkipNulls() {
        StringPath str1 = Expressions.stringPath((String)"str1");
        StringPath str2 = Expressions.stringPath((String)"str2");
        StringPath str3 = Expressions.stringPath((String)"str3");
        FactoryExpression entity = Projections.constructor(Entity1.class, (Expression[])new Expression[]{str1, str2}).skipNulls();
        ConstructorExpression wrapper = Projections.constructor(Entity2.class, (Expression[])new Expression[]{str3, entity});
        FactoryExpression wrapped = FactoryExpressionUtils.wrap((FactoryExpression)wrapper);
        Entity2 w = (Entity2)wrapped.newInstance(new Object[]{"a", "b", "c"});
        Assert.assertEquals((Object)"a", (Object)w.arg1);
        Assert.assertEquals((Object)"b", (Object)w.entity.arg1);
        Assert.assertEquals((Object)"c", (Object)w.entity.arg2);
        w = (Entity2)wrapped.newInstance(new Object[]{"a", null, null});
        Assert.assertEquals((Object)"a", (Object)w.arg1);
        Assert.assertNull((Object)w.entity);
        w = (Entity2)wrapped.newInstance(new Object[]{null, null, null});
        Assert.assertNull((Object)w.entity);
    }

    @Test
    public void nestedSkipNulls2() {
        StringPath str1 = Expressions.stringPath((String)"str1");
        StringPath str2 = Expressions.stringPath((String)"str2");
        StringPath str3 = Expressions.stringPath((String)"str3");
        FactoryExpression entity = Projections.constructor(Entity1.class, (Expression[])new Expression[]{str1, str2}).skipNulls();
        FactoryExpression wrapper = Projections.constructor(Entity2.class, (Expression[])new Expression[]{str3, entity}).skipNulls();
        FactoryExpression wrapped = FactoryExpressionUtils.wrap((FactoryExpression)wrapper);
        Entity2 w = (Entity2)wrapped.newInstance(new Object[]{"a", "b", "c"});
        Assert.assertEquals((Object)"a", (Object)w.arg1);
        Assert.assertEquals((Object)"b", (Object)w.entity.arg1);
        Assert.assertEquals((Object)"c", (Object)w.entity.arg2);
        w = (Entity2)wrapped.newInstance(new Object[]{"a", null, null});
        Assert.assertEquals((Object)"a", (Object)w.arg1);
        Assert.assertNull((Object)w.entity);
        w = (Entity2)wrapped.newInstance(new Object[]{null, null, null});
        Assert.assertNull((Object)w);
    }

    public static class Entity2 {
        String arg1;
        Entity1 entity;

        public Entity2(String arg1, Entity1 entity) {
            this.arg1 = arg1;
            this.entity = entity;
        }
    }

    public static class Entity1 {
        String arg1;
        String arg2;

        public Entity1(String arg1, String arg2) {
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
    }

    public static class VarArgs2 {
        String arg;
        String[] args;

        public VarArgs2(String s, String ... strs) {
            this.arg = s;
            this.args = strs;
        }
    }

    public static class VarArgs {
        String[] args;

        public VarArgs(String ... strs) {
            this.args = strs;
        }
    }
}

