/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.Coalesce;
import com.querydsl.core.types.dsl.DslExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SignatureTest {
    private List<Class<?>> classes = new ArrayList();

    @Before
    public void setUp() throws ClassNotFoundException {
        for (String folder : Arrays.asList("com/querydsl/core/types/dsl")) {
            for (String file : new File("src/main/java", folder).list()) {
                if (!file.endsWith(".java") || file.equals("package-info.java")) continue;
                String className = (folder + "." + file.substring(0, file.length() - 5)).replace('/', '.');
                this.classes.add(Class.forName(className));
            }
        }
    }

    @Test
    public void returnType_extends_simpleExpression() {
        Assert.assertFalse((boolean)this.classes.isEmpty());
        HashSet<String> skippedMethods = new HashSet<String>(Arrays.asList("getArg", "getRoot", "not"));
        ArrayList<String> errors = new ArrayList<String>();
        for (Class<?> cl : this.classes) {
            if (cl.equals(Expressions.class)) continue;
            for (Method m : cl.getDeclaredMethods()) {
                if (skippedMethods.contains(m.getName()) || !Modifier.isPublic(m.getModifiers()) || !Expression.class.isAssignableFrom(m.getReturnType()) || Coalesce.class.isAssignableFrom(m.getReturnType()) || DslExpression.class.isAssignableFrom(m.getReturnType()) || SimpleExpression.class.isAssignableFrom(m.getReturnType())) continue;
                errors.add(cl.getSimpleName() + "." + m.getName() + " has illegal return type");
            }
        }
        for (String error : errors) {
            System.err.println(error);
        }
        if (!errors.isEmpty()) {
            Assert.fail((String)("Got " + errors.size() + " errors"));
        }
    }
}

