/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ArrayPath;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.Gender;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderValidator;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.User;
import com.querydsl.core.util.BeanMap;
import java.sql.Time;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class PathBuilderTest {
    @Test
    public void getEnum() {
        PathBuilder entityPath = new PathBuilder(User.class, "entity");
        EnumPath enumPath = entityPath.getEnum("gender", Gender.class);
        Assert.assertNotNull((Object)enumPath.ordinal());
        Assert.assertEquals((Object)enumPath, (Object)entityPath.get(enumPath));
    }

    @Test
    public void getByExample() {
        User user = new User();
        user.setFirstName("firstName");
        user.setLastName("lastName");
        String byExample = this.getByExample(user).toString();
        Assert.assertTrue((boolean)byExample.contains("entity.lastName = lastName"));
        Assert.assertTrue((boolean)byExample.contains("entity.firstName = firstName"));
    }

    @Test
    public void getArray() {
        PathBuilder entityPath = new PathBuilder(User.class, "entity");
        ArrayPath array = entityPath.getArray("array", String[].class);
        Assert.assertEquals(String[].class, (Object)array.getType());
        Assert.assertEquals(String.class, (Object)array.getElementType());
    }

    @Test
    public void getList() {
        PathBuilder entityPath = new PathBuilder(User.class, "entity");
        ((StringPath)entityPath.getList("list", String.class, StringPath.class).get(0)).lower();
        entityPath.getList("list", String.class).get(0);
    }

    @Test
    public void getMap() {
        PathBuilder entityPath = new PathBuilder(User.class, "entity");
        ((StringPath)entityPath.getMap("map", String.class, String.class, StringPath.class).get((Object)"")).lower();
        entityPath.getMap("map", String.class, String.class).get((Object)"");
    }

    private <T> BooleanBuilder getByExample(T entity) {
        PathBuilder entityPath = new PathBuilder(entity.getClass(), "entity");
        BooleanBuilder conditions = new BooleanBuilder();
        BeanMap beanMap = new BeanMap(entity);
        for (Map.Entry entry : beanMap.entrySet()) {
            if (((String)entry.getKey()).equals("class") || entry.getValue() == null) continue;
            conditions.and((Predicate)entityPath.get((String)entry.getKey()).eq(entry.getValue()));
        }
        return conditions;
    }

    @Test
    public void get() {
        PathBuilder entity = new PathBuilder(User.class, "entity");
        NumberPath intPath = new NumberPath(Integer.class, "int");
        StringPath strPath = new StringPath("str");
        BooleanPath booleanPath = new BooleanPath("boolean");
        Assert.assertEquals((Object)"entity.int", (Object)entity.get(intPath).toString());
        Assert.assertEquals((Object)"entity.str", (Object)entity.get(strPath).toString());
        Assert.assertEquals((Object)"entity.boolean", (Object)entity.get(booleanPath).toString());
        Assert.assertEquals((Object)"entity.int", (Object)entity.get(entity.get(intPath)).toString());
    }

    @Test
    public void various() {
        PathBuilder entity = new PathBuilder(User.class, "entity");
        entity.getBoolean("boolean");
        entity.getCollection("col", User.class);
        entity.getComparable("comparable", Comparable.class);
        entity.getDate("date", Date.class);
        entity.getDateTime("dateTime", Date.class);
        entity.getList("list", User.class);
        entity.getMap("map", String.class, User.class);
        entity.getNumber("number", Integer.class);
        entity.getSet("set", User.class);
        entity.getSimple("simple", Object.class);
        entity.getString("string");
        entity.getTime("time", Time.class);
    }

    @Test
    public void calling_get_with_the_same_name_and_different_types_returns_correct_type() {
        PathBuilder entity = new PathBuilder(User.class, "entity");
        String pathName = "some_path";
        Assert.assertEquals(Object.class, (Object)entity.get(pathName).getType());
        Assert.assertEquals(Integer.class, (Object)entity.get(pathName, Integer.class).getType());
        Assert.assertEquals(User.class, (Object)entity.get(pathName, User.class).getType());
    }

    @Test
    public void calling_get_with_the_same_name_and_different_types_returns_specific_type_when_validating() {
        PathBuilder entity = new PathBuilder(User.class, "entity", PathBuilderValidator.FIELDS);
        String pathName = "username";
        Assert.assertEquals(String.class, (Object)entity.get(pathName).getType());
        Assert.assertEquals(String.class, (Object)entity.get(pathName, Comparable.class).getType());
        Assert.assertEquals(String.class, (Object)entity.get(pathName, Object.class).getType());
    }
}

