/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.querydsl.core.util.BeanMap;
import com.querydsl.core.util.Entity;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class BeanMapTest {
    private BeanMap beanMap;

    @Before
    public void setUp() {
        this.beanMap = new BeanMap((Object)new Entity());
    }

    @Test
    public void size() {
        Assert.assertEquals((long)4L, (long)this.beanMap.size());
    }

    @Test
    public void clear() {
        this.beanMap.clear();
        Assert.assertEquals((long)4L, (long)this.beanMap.size());
    }

    @Test
    public void primitives() {
        this.beanMap.put("id", (Object)5);
        Assert.assertEquals((long)5L, (long)((Entity)this.beanMap.getBean()).getId());
    }

    @Test
    public void beanMap() {
        Assert.assertEquals((long)0L, (long)new BeanMap().size());
    }

    @Test
    public void beanMapObject() {
        Assert.assertEquals((long)4L, (long)new BeanMap((Object)new Entity()).size());
    }

    @Test
    public void toString_() {
        Assert.assertEquals((Object)"BeanMap<null>", (Object)new BeanMap().toString());
    }

    @Test
    public void clone_() throws CloneNotSupportedException {
        Assert.assertEquals((Object)this.beanMap, (Object)this.beanMap.clone());
    }

    @Test
    public void putAllWriteable() {
    }

    @Test
    public void containsKeyString() {
        Assert.assertTrue((boolean)this.beanMap.containsKey("id"));
    }

    @Test
    public void containsValueObject() {
    }

    @Test
    public void getString() {
        this.beanMap.put("firstName", (Object)"John");
        Assert.assertEquals((Object)"John", (Object)this.beanMap.get("firstName"));
    }

    @Test
    public void keySet() {
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"id", "class", "firstName", "lastName"}), (Object)this.beanMap.keySet());
    }

    @Test
    public void entrySet() {
        this.beanMap.put("firstName", (Object)"John");
        Assert.assertFalse((boolean)this.beanMap.entrySet().isEmpty());
    }

    @Test
    @Ignore
    public void values() {
        this.beanMap.put("firstName", (Object)"John");
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Serializable[]{Integer.valueOf(0), null, Entity.class, "John"}), (Object)this.beanMap.values());
    }

    @Test
    public void getType() {
    }

    @Test
    public void getBean() {
        Assert.assertEquals(Entity.class, this.beanMap.getBean().getClass());
    }

    @Test
    public void setBean() {
        Entity entity = new Entity();
        this.beanMap.setBean((Object)entity);
        Assert.assertTrue((entity == this.beanMap.getBean() ? 1 : 0) != 0);
    }
}

