/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group.guava;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.FetchableQuery;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.AbstractGroupByTransformer;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupExpression;
import com.querydsl.core.group.GroupImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.Projections;
import com.querydsl.core.util.ArrayUtils;

public class GroupByTable<R, C, V, RES extends Table<R, C, V>>
extends AbstractGroupByTransformer<R, RES> {
    GroupByTable(Expression<R> rowKey, Expression<C> columnKey, Expression<?> ... expressions) {
        super(rowKey, (Expression[])ArrayUtils.combine(Expression.class, columnKey, (Object[])expressions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RES transform(FetchableQuery<?, ?> query) {
        HashBasedTable groups = HashBasedTable.create();
        FactoryExpression expr = FactoryExpressionUtils.wrap((FactoryExpression)Projections.tuple((Expression[])this.expressions));
        boolean hasGroups = false;
        for (Expression e : expr.getArgs()) {
            hasGroups |= e instanceof GroupExpression;
        }
        if (hasGroups) {
            expr = GroupByTable.withoutGroupExpressions((FactoryExpression)expr);
        }
        try (CloseableIterator iter = query.select((Expression)expr).iterate();){
            while (iter.hasNext()) {
                Object rowId;
                Object[] row = ((Tuple)iter.next()).toArray();
                Object groupId = row[0];
                GroupImpl group = (GroupImpl)groups.get(groupId, rowId = row[1]);
                if (group == null) {
                    group = new GroupImpl(this.groupExpressions, this.maps);
                    groups.put(groupId, rowId, (Object)group);
                }
                group.add(row);
            }
        }
        return this.transform((Table<R, ?, Group>)groups);
    }

    protected RES transform(Table<R, ?, Group> groups) {
        return (RES)groups;
    }
}

