/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jdo.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jdo.sql.JDOSQLQuery;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.ProjectableSQLQuery;
import com.querydsl.sql.SQLSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSQLQuery<T, Q extends AbstractSQLQuery<T, Q>>
extends ProjectableSQLQuery<T, Q> {
    private static final Logger logger = Logger.getLogger(JDOSQLQuery.class.getName());
    private final Closeable closeable = new Closeable(){

        @Override
        public void close() throws IOException {
            AbstractSQLQuery.this.close();
        }
    };
    protected final boolean detach;
    private List<Object> orderedConstants = new ArrayList<Object>();
    @Nullable
    protected final PersistenceManager persistenceManager;
    protected List<Query> queries = new ArrayList<Query>(2);
    @Nullable
    protected FactoryExpression<?> projection;
    protected final QueryMixin<Q> queryMixin;

    public AbstractSQLQuery(QueryMetadata metadata, Configuration conf, PersistenceManager persistenceManager, boolean detach) {
        super(new QueryMixin(metadata, false), conf);
        this.queryMixin = ((ProjectableSQLQuery)this).queryMixin;
        this.queryMixin.setSelf((Object)this);
        this.persistenceManager = persistenceManager;
        this.detach = detach;
    }

    public void close() {
        for (Query query : this.queries) {
            query.closeAll();
        }
    }

    public long fetchCount() {
        Query query = this.createQuery(true);
        query.setUnique(true);
        Long rv = (Long)this.execute(query, true);
        if (rv != null) {
            return rv;
        }
        throw new QueryException("Query returned null");
    }

    private Query createQuery(boolean forCount) {
        SQLSerializer serializer = new SQLSerializer(this.configuration);
        if (this.union != null) {
            serializer.serializeUnion(this.union, this.queryMixin.getMetadata(), this.unionAll);
        } else {
            serializer.serialize(this.queryMixin.getMetadata(), forCount);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(serializer.toString());
        }
        Query query = this.persistenceManager.newQuery("javax.jdo.query.SQL", (Object)serializer.toString());
        this.orderedConstants = serializer.getConstants();
        this.queries.add(query);
        if (!forCount) {
            Expression projection = this.queryMixin.getMetadata().getProjection();
            if (projection instanceof FactoryExpression) {
                this.projection = (FactoryExpression)projection;
            }
        } else {
            query.setResultClass(Long.class);
        }
        return query;
    }

    private <T> T detach(T results) {
        if (results instanceof Collection) {
            return (T)this.persistenceManager.detachCopyAll(new Object[]{results});
        }
        return (T)this.persistenceManager.detachCopy(results);
    }

    private Object project(FactoryExpression<?> expr, Object row) {
        if (row == null) {
            return null;
        }
        if (row.getClass().isArray()) {
            return expr.newInstance((Object[])row);
        }
        return expr.newInstance(new Object[]{row});
    }

    private Object execute(Query query, boolean forCount) {
        Object rv = !this.orderedConstants.isEmpty() ? query.executeWithArray(this.orderedConstants.toArray()) : query.execute();
        if (this.isDetach()) {
            rv = this.detach(rv);
        }
        if (this.projection != null && !forCount) {
            if (rv instanceof List) {
                List original = (List)rv;
                rv = new ArrayList();
                for (Object o : original) {
                    ((List)rv).add(this.project(this.projection, o));
                }
            } else {
                rv = this.project(this.projection, rv);
            }
        }
        return rv;
    }

    public boolean isDetach() {
        return this.detach;
    }

    public CloseableIterator<T> iterate() {
        return new IteratorAdapter(this.fetch().iterator(), this.closeable);
    }

    public List<T> fetch() {
        Object rv = this.execute(this.createQuery(false), false);
        return rv instanceof List ? (List<Object>)rv : Collections.singletonList(rv);
    }

    public QueryResults<T> fetchResults() {
        Query countQuery = this.createQuery(true);
        countQuery.setUnique(true);
        long total = (Long)this.execute(countQuery, true);
        if (total > 0L) {
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            Query query = this.createQuery(false);
            return new QueryResults((List)this.execute(query, false), modifiers, total);
        }
        return QueryResults.emptyResults();
    }

    public String toString() {
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            SQLSerializer serializer = new SQLSerializer(this.configuration);
            serializer.serialize(this.queryMixin.getMetadata(), false);
            return serializer.toString().trim();
        }
        return super.toString();
    }

    @Nullable
    public T fetchOne() throws NonUniqueResultException {
        Query query;
        Object rv;
        if (this.getMetadata().getModifiers().getLimit() == null) {
            this.limit(2L);
        }
        if ((rv = this.execute(query = this.createQuery(false), false)) instanceof List) {
            List list = (List)rv;
            if (!list.isEmpty()) {
                if (list.size() > 1) {
                    throw new NonUniqueResultException();
                }
                return (T)list.get(0);
            }
            return null;
        }
        return (T)rv;
    }
}

