/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jpa.FactoryExpressionTransformer;
import com.querydsl.jpa.QueryHandler;
import com.querydsl.jpa.ScrollableResultsIterator;
import com.querydsl.jpa.TransformingIterator;
import java.util.Iterator;
import javax.persistence.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;

class HibernateHandler
implements QueryHandler {
    HibernateHandler() {
    }

    @Override
    public void addEntity(Query query, String alias, Class<?> type) {
        if (query instanceof NativeQuery) {
            NativeQuery hibernateQuery = (NativeQuery)query;
            hibernateQuery.addEntity(alias, type);
        }
    }

    @Override
    public void addScalar(Query query, String alias, Class<?> type) {
        if (query instanceof NativeQuery) {
            NativeQuery hibernateQuery = (NativeQuery)query;
            hibernateQuery.addScalar(alias);
        }
    }

    @Override
    public boolean createNativeQueryTyped() {
        return false;
    }

    @Override
    public <T> CloseableIterator<T> iterate(Query query, FactoryExpression<?> projection) {
        if (query instanceof NativeQuery) {
            NativeQuery hQuery = (NativeQuery)query;
            ScrollableResults results = hQuery.scroll(ScrollMode.FORWARD_ONLY);
            Object iterator = new ScrollableResultsIterator(results);
            if (projection != null) {
                iterator = new TransformingIterator(iterator, projection);
            }
            return iterator;
        }
        Iterator iterator = query.getResultList().iterator();
        if (projection != null) {
            return new TransformingIterator(iterator, projection);
        }
        return new IteratorAdapter(iterator);
    }

    @Override
    public boolean transform(Query query, FactoryExpression<?> projection) {
        if (query instanceof NativeQuery) {
            FactoryExpressionTransformer transformer = new FactoryExpressionTransformer(projection);
            ((NativeQuery)query).setResultTransformer((ResultTransformer)transformer);
            return true;
        }
        return false;
    }

    @Override
    public boolean wrapEntityProjections() {
        return true;
    }
}

