/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata;

import com.redhat.rcm.maven.plugin.buildmetadata.util.ReportUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.LocaleUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractReportMojo
extends AbstractMavenReport {
    protected MavenProject project;
    protected Renderer siteRenderer;
    protected ArtifactRepository localRepository;
    protected ArtifactResolver resolver;
    protected ArtifactFactory factory;
    protected File outputDirectory;
    protected String logLevel;
    protected String locale;
    protected boolean skip;

    protected final MavenProject getProject() {
        return this.project;
    }

    protected final Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected final String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (!this.canGenerateReport()) {
            if (log.isInfoEnabled()) {
                log.info((CharSequence)("Report '" + this.getName(Locale.getDefault()) + "' skipped due to offline mode."));
            }
            return;
        }
        this.getLog();
        this.provideSink();
    }

    public boolean canGenerateReport() {
        return super.canGenerateReport() && !this.skip;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Log log = this.getLog();
        if (!this.canGenerateReport()) {
            if (log.isInfoEnabled()) {
                log.info((CharSequence)("Report '" + this.getName(Locale.getDefault()) + "' skipped due to offline mode."));
            }
            return;
        }
    }

    protected final void provideSink() throws MojoExecutionException {
        Locale reportLocale = this.determineLocale();
        try {
            DecorationModel model = new DecorationModel();
            model.setBody(new Body());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("outputEncoding", "UTF-8");
            SiteRenderingContext siteContext = this.siteRenderer.createContextForSkin(ReportUtils.getSkinArtifactFile(this.project, this.localRepository, this.resolver, this.factory), attributes, model, this.getName(reportLocale), reportLocale);
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate((Sink)sink, reportLocale);
            this.provideDir();
            FileWriter writer = new FileWriter(new File(this.outputDirectory, this.getOutputName() + ".html"));
            this.siteRenderer.generateDocument((Writer)writer, sink, siteContext);
            this.siteRenderer.copyResources(siteContext, new File(this.project.getBasedir(), "src/site/resources"), this.outputDirectory);
        }
        catch (RendererException e) {
            throw new MojoExecutionException(this.createErrorMessage(reportLocale), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(this.createErrorMessage(reportLocale), (Exception)e);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException(this.createErrorMessage(reportLocale), (Exception)((Object)e));
        }
    }

    private void provideDir() throws IOException {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException("Cannot generate directories '" + this.outputDirectory.getPath() + "'");
        }
    }

    private String createErrorMessage(Locale reportLocale) {
        return "An error has occurred in " + this.getName(reportLocale) + " report generation.";
    }

    private Locale determineLocale() {
        return StringUtils.isNotBlank((String)this.locale) ? LocaleUtils.toLocale((String)this.locale) : Locale.getDefault();
    }

    protected final ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("com.redhat.rcm.maven.buildmetadata.BuildReport", locale);
    }
}

