/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata;

import com.redhat.rcm.maven.plugin.buildmetadata.AbstractBuildMojo;
import com.redhat.rcm.maven.plugin.buildmetadata.io.BuildPropertiesFileHelper;
import com.redhat.rcm.maven.plugin.buildmetadata.util.FilePathNormalizer;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public final class BuildPointMojo
extends AbstractBuildMojo {
    public static final String TMP_BUILD_END = "build.tmp.timestamp";
    private String name;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.propertiesOutputFile.exists()) {
            Properties buildMetaDataProperties = new Properties();
            String baseDir = this.project.getBasedir().getAbsolutePath();
            FilePathNormalizer filePathNormalizer = new FilePathNormalizer(baseDir);
            BuildPropertiesFileHelper helper = new BuildPropertiesFileHelper(this.getLog(), this.propertiesOutputFile, filePathNormalizer);
            helper.readBuildPropertiesFile(buildMetaDataProperties);
            this.provideBuildPointInfo(buildMetaDataProperties, helper);
            this.provideBuildMetaData(buildMetaDataProperties, null, this.providers, true);
            helper.writePropertiesFile(buildMetaDataProperties);
            this.updateMavenEnvironment(buildMetaDataProperties, helper);
        } else {
            this.getLog().info((CharSequence)("Skipping build point '" + this.name + "' since no " + this.propertiesOutputFile.getName() + " with build meta data found."));
        }
    }

    private void provideBuildPointInfo(Properties buildMetaDataProperties, BuildPropertiesFileHelper helper) {
        Date start = this.session.getStartTime();
        Date end = new Date();
        long duration = end.getTime() - start.getTime();
        String durationPropertyName = this.createDurationPropertyName();
        String durationString = String.valueOf(duration);
        buildMetaDataProperties.setProperty(durationPropertyName, durationString);
        this.setTimeDifference(helper, buildMetaDataProperties, end, durationString, durationPropertyName);
    }

    private void setTimeDifference(BuildPropertiesFileHelper helper, Properties buildMetaDataProperties, Date currentEnd, String durationString, String durationPropertyName) {
        Properties projectProperties = helper.getProjectProperties(this.project);
        String previousDurationEnd = projectProperties.getProperty(TMP_BUILD_END);
        String diffPropertyName = durationPropertyName + ".diff";
        if (StringUtils.isNotBlank((String)previousDurationEnd)) {
            long previousTimestamp = Long.parseLong(previousDurationEnd);
            long difference = currentEnd.getTime() - previousTimestamp;
            buildMetaDataProperties.setProperty(diffPropertyName, String.valueOf(difference));
        } else {
            buildMetaDataProperties.setProperty(diffPropertyName, durationString);
        }
        projectProperties.setProperty(TMP_BUILD_END, String.valueOf(currentEnd.getTime()));
    }

    private String createDurationPropertyName() {
        if (StringUtils.isNotBlank((String)this.name)) {
            return "build.duration." + this.name;
        }
        return "build.duration";
    }
}

