/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.rcm.maven.plugin.buildmetadata.scm.maven;

import com.redhat.rcm.maven.plugin.buildmetadata.scm.ScmException;
import java.io.Serializable;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

public final class ScmConnectionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String connectionUrl;
    private String userName;
    private String password;
    private String privateKey;
    private String passPhrase;
    private String tagBase;
    private ScmVersion remoteVersion;

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setScmConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getTagBase() {
        return this.tagBase;
    }

    public void setTagBase(String tagBase) {
        this.tagBase = tagBase;
    }

    public ScmVersion getRemoteVersion() {
        return this.remoteVersion;
    }

    public void setRemoteVersion(ScmVersion remoteVersion) {
        this.remoteVersion = remoteVersion;
    }

    public ScmRepository createRepository(ScmManager scmManager) throws ScmException {
        try {
            ScmRepository repository = scmManager.makeScmRepository(this.connectionUrl);
            ScmProviderRepository providerRepository = repository.getProviderRepository();
            this.configure(providerRepository);
            if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost providerRepositoryWithHost = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                this.configure(providerRepositoryWithHost);
            }
            if (!StringUtils.isEmpty((String)this.tagBase) && repository.getProvider().equals("svn")) {
                SvnScmProviderRepository svnRepository = (SvnScmProviderRepository)repository.getProviderRepository();
                this.configure(svnRepository);
            }
            return repository;
        }
        catch (Exception e) {
            throw new ScmException("The SCM provider cannot be created.", e);
        }
    }

    protected void configure(ScmProviderRepository repository) {
        if (!StringUtils.isEmpty((String)this.userName)) {
            repository.setUser(this.userName);
        }
        if (!StringUtils.isEmpty((String)this.password)) {
            repository.setPassword(this.password);
        }
    }

    protected void configure(ScmProviderRepositoryWithHost repository) {
        if (!StringUtils.isEmpty((String)this.privateKey)) {
            repository.setPrivateKey(this.privateKey);
        }
        if (!StringUtils.isEmpty((String)this.passPhrase)) {
            repository.setPassphrase(this.passPhrase);
        }
    }

    protected void configure(SvnScmProviderRepository repository) {
        repository.setTagBase(this.tagBase);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SCM connection info: url=").append(this.connectionUrl);
        ScmConnectionInfo.appendIfExists(buffer, "user", this.userName);
        ScmConnectionInfo.appendSensibleDataIfExists(buffer, "password", this.password);
        ScmConnectionInfo.appendSensibleDataIfExists(buffer, "privateKey", this.privateKey);
        ScmConnectionInfo.appendSensibleDataIfExists(buffer, "passPhrase", this.passPhrase);
        ScmConnectionInfo.appendIfExists(buffer, "tagBase", this.tagBase);
        return buffer.toString();
    }

    private static void appendIfExists(StringBuilder buffer, String label, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            buffer.append(", ").append(label).append('=').append(value);
        }
    }

    private static void appendSensibleDataIfExists(StringBuilder buffer, String label, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            buffer.append(", ").append(label).append('=').append(ScmConnectionInfo.mask(value));
        }
    }

    private static String mask(String input) {
        return StringUtils.repeat((String)"*", (int)input.length());
    }
}

