/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.relevantcodes.extentreports.IReporter;
import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.Report;
import com.relevantcodes.extentreports.model.Author;
import com.relevantcodes.extentreports.model.Category;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.model.TestAttribute;
import com.relevantcodes.extentreports.utils.MongoUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class ExtentX
extends LogSettings
implements IReporter {
    private Report report;
    private String testName;
    private ObjectId reportId;
    private MongoClient mongoClient;
    private MongoDatabase db;
    private MongoCollection<Document> projectCollection;
    private MongoCollection<Document> reportCollection;
    private MongoCollection<Document> testCollection;
    private MongoCollection<Document> nodeCollection;
    private MongoCollection<Document> logCollection;
    private MongoCollection<Document> categoryCollection;
    private MongoCollection<Document> authorCollection;
    private MongoCollection<Document> categoriesTests;
    private MongoCollection<Document> authorsTests;

    @Override
    public void start(Report report) {
        this.report = report;
        this.db = this.mongoClient.getDatabase("extent");
        this.projectCollection = this.db.getCollection("project");
        this.reportCollection = this.db.getCollection("report");
        this.testCollection = this.db.getCollection("test");
        this.nodeCollection = this.db.getCollection("node");
        this.logCollection = this.db.getCollection("log");
        this.categoryCollection = this.db.getCollection("category");
        this.authorCollection = this.db.getCollection("author");
        this.categoriesTests = this.db.getCollection("category_tests__test_categories");
        this.authorsTests = this.db.getCollection("author_tests__test_authors");
    }

    @Override
    public void stop() {
        this.mongoClient.close();
    }

    @Override
    public void flush() {
        if (this.reportId == null) {
            this.insertReport();
        }
        this.reportCollection.updateOne((Bson)new Document("_id", (Object)this.reportId), (Bson)new Document("$set", (Object)new Document("endTime", (Object)new Date(this.report.getSuiteTimeInfo().getSuiteEndTimestamp())).append("status", (Object)this.report.getStatus().toString())));
    }

    private ObjectId getProjectId() {
        ObjectId projectId;
        String projectName = this.report.getProjectName();
        Document doc = new Document("name", (Object)projectName);
        FindIterable iterable = this.projectCollection.find((Bson)doc);
        Document project = (Document)iterable.first();
        if (project != null) {
            projectId = project.getObjectId((Object)"_id");
        } else {
            this.projectCollection.insertOne((Object)doc);
            projectId = MongoUtil.getId(doc);
        }
        return projectId;
    }

    private void insertReport() {
        FindIterable iterable;
        Document report;
        ObjectId projectId = this.getProjectId();
        String id = this.report.getMongoDBObjectID();
        if (id != null & !id.isEmpty() && (report = (Document)(iterable = this.reportCollection.find((Bson)new Document("_id", (Object)new ObjectId(id)))).first()) != null) {
            this.reportId = report.getObjectId((Object)"_id");
            return;
        }
        Document doc = new Document("project", (Object)projectId).append("fileName", (Object)new File(this.report.getFilePath()).getName()).append("startTime", (Object)this.report.getStartedTime());
        this.reportCollection.insertOne((Object)doc);
        this.reportId = MongoUtil.getId(doc);
        this.report.setMongoDBObjectID(this.reportId.toString());
    }

    @Override
    public void addTest(Test test) {
        if (this.reportId == null) {
            this.insertReport();
        }
        this.testName = test.getName();
        Document doc = new Document("report", (Object)this.reportId).append("name", (Object)this.testName).append("status", (Object)test.getStatus().toString()).append("description", (Object)test.getDescription()).append("startTime", (Object)test.getStartedTime()).append("endTime", (Object)test.getEndedTime()).append("childNodesCount", (Object)this.getNodeLength(test, 0)).append("categorized", (Object)(test.getCategoryList().size() > 0 ? 1 : 0));
        this.testCollection.insertOne((Object)doc);
        ObjectId testId = MongoUtil.getId(doc);
        this.addLogs(test, testId);
        this.addNodes(test, testId, 0);
        this.addCategories(test, testId);
        this.addAuthors(test, testId);
    }

    private int getNodeLength(Test test, int length) {
        for (Test node : test.getNodeList()) {
            ++length;
            if (!node.hasChildNodes) continue;
            length = this.getNodeLength(node, length);
        }
        return length;
    }

    private void addLogs(Test test, ObjectId testId) {
        Test.LogIterator iter = test.logIterator();
        int ix = 0;
        while (iter.hasNext()) {
            Log log = (Log)iter.next();
            Document doc = new Document("test", (Object)testId).append("report", (Object)this.reportId).append("testName", (Object)test.getName()).append("logSequence", (Object)ix++).append("status", (Object)log.getLogStatus().toString()).append("timestamp", (Object)log.getTimestamp()).append("stepName", (Object)log.getStepName()).append("details", (Object)log.getDetails());
            this.logCollection.insertOne((Object)doc);
        }
    }

    private void addNodes(Test test, ObjectId testId, int level) {
        if (!test.hasChildNodes) {
            return;
        }
        for (Test node : test.getNodeList()) {
            this.addNode(node, testId, ++level);
            --level;
            if (!node.hasChildNodes) continue;
            this.addNodes(node, testId, ++level);
            --level;
        }
    }

    private void addNode(Test node, ObjectId testId, int level) {
        Document doc = new Document("test", (Object)testId).append("parentTestName", (Object)this.testName).append("report", (Object)this.reportId).append("name", (Object)node.getName()).append("level", (Object)level).append("status", (Object)node.getStatus().toString()).append("description", (Object)node.getDescription()).append("startTime", (Object)node.getStartedTime()).append("endTime", (Object)node.getEndedTime()).append("childNodesCount", (Object)node.getNodeList().size());
        this.nodeCollection.insertOne((Object)doc);
        ObjectId nodeId = MongoUtil.getId(doc);
        this.addLogs(node, nodeId);
    }

    private void addCategories(Test test, ObjectId testId) {
        Test.TestAttributeIterator<Category> categories = test.categoryIterator();
        while (categories.hasNext()) {
            TestAttribute category = (TestAttribute)categories.next();
            Document doc = new Document("tests", (Object)testId).append("report", (Object)this.reportId).append("name", (Object)category.getName()).append("status", (Object)test.getStatus().toString()).append("testName", (Object)test.getName());
            this.categoryCollection.insertOne((Object)doc);
            ObjectId categoryId = MongoUtil.getId(doc);
            doc = new Document("test_categories", (Object)testId).append("category_tests", (Object)categoryId).append("category", (Object)category.getName()).append("test", (Object)test.getName());
            this.categoriesTests.insertOne((Object)doc);
        }
    }

    private void addAuthors(Test test, ObjectId testId) {
        Test.TestAttributeIterator<Author> authors = test.authorIterator();
        while (authors.hasNext()) {
            TestAttribute author = (TestAttribute)authors.next();
            Document doc = new Document("tests", (Object)testId).append("report", (Object)this.reportId).append("name", (Object)author.getName()).append("status", (Object)test.getStatus().toString()).append("testName", (Object)test.getName());
            this.authorCollection.insertOne((Object)doc);
            ObjectId authorId = MongoUtil.getId(doc);
            doc = new Document("test_authors", (Object)testId).append("author_tests", (Object)authorId).append("author", (Object)author.getName()).append("test", (Object)test.getName());
            this.authorsTests.insertOne((Object)doc);
        }
    }

    @Override
    public void setTestRunnerLogs() {
    }

    public ExtentX() {
        this.mongoClient = new MongoClient("localhost", 27017);
    }

    public ExtentX(String host) {
        this.mongoClient = new MongoClient(host, 27017);
    }

    public ExtentX(String host, MongoClientOptions options) {
        this.mongoClient = new MongoClient(host, options);
    }

    public ExtentX(String host, int port) {
        this.mongoClient = new MongoClient(host, port);
    }

    public ExtentX(MongoClientURI uri) {
        this.mongoClient = new MongoClient(uri);
    }

    public ExtentX(ServerAddress addr) {
        this.mongoClient = new MongoClient(addr);
    }

    public ExtentX(List<ServerAddress> seeds) {
        this.mongoClient = new MongoClient(seeds);
    }

    public ExtentX(List<ServerAddress> seeds, List<MongoCredential> credentialsList) {
        this.mongoClient = new MongoClient(seeds, credentialsList);
    }

    public ExtentX(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this.mongoClient = new MongoClient(seeds, credentialsList, options);
    }

    public ExtentX(List<ServerAddress> seeds, MongoClientOptions options) {
        this.mongoClient = new MongoClient(seeds, options);
    }

    public ExtentX(ServerAddress addr, List<MongoCredential> credentialsList) {
        this.mongoClient = new MongoClient(addr, credentialsList);
    }

    public ExtentX(ServerAddress addr, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this.mongoClient = new MongoClient(addr, credentialsList, options);
    }

    public ExtentX(ServerAddress addr, MongoClientOptions options) {
        this.mongoClient = new MongoClient(addr, options);
    }

    static {
        Logger mongoLogger = Logger.getLogger("org.mongodb.driver");
        mongoLogger.setLevel(Level.SEVERE);
    }
}

