/*
 * Decompiled with CFR 0.152.
 */
package com.samaxes.maven.minify.plugin;

import com.samaxes.maven.minify.common.SourceFilesEnumeration;
import com.samaxes.maven.minify.common.YuiConfig;
import com.samaxes.maven.minify.plugin.MinifyMojo;
import com.samaxes.maven.minify.plugin.ProcessCSSFilesTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.zip.GZIPOutputStream;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class ProcessFilesTask
implements Callable<Object> {
    public static final String TEMP_SUFFIX = ".tmp";
    protected final Log log;
    protected final boolean verbose;
    protected final Integer bufferSize;
    protected final Charset charset;
    protected final String suffix;
    protected final boolean nosuffix;
    protected final boolean skipMerge;
    protected final boolean skipMinify;
    protected final MinifyMojo.Engine engine;
    protected final YuiConfig yuiConfig;
    private final File sourceDir;
    private final File targetDir;
    private final String mergedFilename;
    private final List<File> files = new ArrayList<File>();
    private final boolean sourceFilesEmpty;
    private final boolean sourceIncludesEmpty;

    public ProcessFilesTask(Log log, boolean verbose, Integer bufferSize, Charset charset, String suffix, boolean nosuffix, boolean skipMerge, boolean skipMinify, String webappSourceDir, String webappTargetDir, String inputDir, List<String> sourceFiles, List<String> sourceIncludes, List<String> sourceExcludes, String outputDir, String outputFilename, MinifyMojo.Engine engine, YuiConfig yuiConfig) throws FileNotFoundException {
        this.log = log;
        this.verbose = verbose;
        this.bufferSize = bufferSize;
        this.charset = charset;
        this.suffix = suffix;
        this.nosuffix = nosuffix;
        this.skipMerge = skipMerge;
        this.skipMinify = skipMinify;
        this.engine = engine;
        this.yuiConfig = yuiConfig;
        this.sourceDir = new File(webappSourceDir + File.separator + inputDir);
        this.targetDir = new File(webappTargetDir + File.separator + outputDir);
        this.mergedFilename = outputFilename;
        for (String sourceFilename : sourceFiles) {
            this.addNewSourceFile(this.mergedFilename, sourceFilename);
        }
        for (File sourceInclude : this.getFilesToInclude(sourceIncludes, sourceExcludes)) {
            if (this.files.contains(sourceInclude)) continue;
            this.addNewSourceFile(this.mergedFilename, sourceInclude);
        }
        this.sourceFilesEmpty = sourceFiles.isEmpty();
        this.sourceIncludesEmpty = sourceIncludes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws IOException {
        Log log = this.log;
        synchronized (log) {
            String fileType = this instanceof ProcessCSSFilesTask ? "CSS" : "JavaScript";
            this.log.info((CharSequence)("Starting " + fileType + " task:"));
            if (!this.targetDir.exists() && !this.targetDir.mkdirs()) {
                throw new RuntimeException("Unable to create target directory for: " + this.targetDir);
            }
            if (!this.files.isEmpty()) {
                if (this.skipMerge) {
                    this.log.info((CharSequence)"Skipping the merge step...");
                    String sourceBasePath = this.sourceDir.getAbsolutePath();
                    for (File mergedFile : this.files) {
                        String originalPath = mergedFile.getAbsolutePath();
                        String subPath = originalPath.substring(sourceBasePath.length(), originalPath.lastIndexOf(File.separator));
                        File targetPath = new File(this.targetDir.getAbsolutePath() + subPath);
                        if (!targetPath.exists() && !targetPath.mkdirs()) {
                            throw new RuntimeException("Unable to create target directory for: " + targetPath);
                        }
                        File minifiedFile = new File(targetPath, this.nosuffix ? mergedFile.getName() : FileUtils.removeExtension((String)this.mergedFilename) + this.suffix + "." + FileUtils.extension((String)mergedFile.getName()));
                        this.minify(mergedFile, minifiedFile);
                    }
                } else if (this.skipMinify) {
                    File mergedFile = new File(this.targetDir, this.mergedFilename);
                    this.merge(mergedFile);
                    this.log.info((CharSequence)"Skipping the minify step...");
                } else {
                    File mergedFile = new File(this.targetDir, this.nosuffix ? this.mergedFilename + TEMP_SUFFIX : this.mergedFilename);
                    this.merge(mergedFile);
                    File minifiedFile = new File(this.targetDir, this.nosuffix ? this.mergedFilename : FileUtils.removeExtension((String)this.mergedFilename) + this.suffix + "." + FileUtils.extension((String)this.mergedFilename));
                    this.minify(mergedFile, minifiedFile);
                    if (this.nosuffix && !mergedFile.delete()) {
                        mergedFile.deleteOnExit();
                    }
                }
                this.log.info((CharSequence)"");
            } else if (!this.sourceFilesEmpty || !this.sourceIncludesEmpty) {
                this.log.error((CharSequence)("No valid " + fileType + " source files found to process."));
            }
        }
        return null;
    }

    protected void merge(File mergedFile) throws IOException {
        if (!mergedFile.getParentFile().exists() && !mergedFile.getParentFile().mkdirs()) {
            throw new RuntimeException("Unable to create target directory for: " + mergedFile.getParentFile());
        }
        try (SequenceInputStream sequence = new SequenceInputStream(new SourceFilesEnumeration(this.log, this.files, this.verbose));
             FileOutputStream out = new FileOutputStream(mergedFile);
             InputStreamReader sequenceReader = new InputStreamReader((InputStream)sequence, this.charset);
             OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out, this.charset);){
            this.log.info((CharSequence)("Creating the merged file [" + (this.verbose ? mergedFile.getPath() : mergedFile.getName()) + "]."));
            IOUtil.copy((Reader)sequenceReader, (Writer)outWriter, (int)this.bufferSize);
        }
        catch (IOException e) {
            this.log.error((CharSequence)"Failed to concatenate files.", (Throwable)e);
            throw e;
        }
    }

    abstract void minify(File var1, File var2) throws IOException;

    void logCompressionGains(File mergedFile, File minifiedFile) {
        try {
            File temp = File.createTempFile(minifiedFile.getName(), ".gz");
            try (FileInputStream in = new FileInputStream(minifiedFile);
                 FileOutputStream out = new FileOutputStream(temp);
                 GZIPOutputStream outGZIP = new GZIPOutputStream(out);){
                IOUtil.copy((InputStream)in, (OutputStream)outGZIP, (int)this.bufferSize);
            }
            this.log.info((CharSequence)("Uncompressed size: " + mergedFile.length() + " bytes."));
            this.log.info((CharSequence)("Compressed size: " + minifiedFile.length() + " bytes minified (" + temp.length() + " bytes gzipped)."));
            temp.deleteOnExit();
        }
        catch (IOException e) {
            this.log.debug((CharSequence)"Failed to calculate the gzipped file size.", (Throwable)e);
        }
    }

    private void addNewSourceFile(String finalFilename, String sourceFilename) throws FileNotFoundException {
        File sourceFile = new File(this.sourceDir, sourceFilename);
        this.addNewSourceFile(finalFilename, sourceFile);
    }

    private void addNewSourceFile(String finalFilename, File sourceFile) throws FileNotFoundException {
        if (sourceFile.exists()) {
            if (finalFilename.equalsIgnoreCase(sourceFile.getName())) {
                this.log.warn((CharSequence)("The source file [" + (this.verbose ? sourceFile.getPath() : sourceFile.getName()) + "] has the same name as the final file."));
            }
        } else {
            throw new FileNotFoundException("The source file [" + (this.verbose ? sourceFile.getPath() : sourceFile.getName()) + "] does not exist.");
        }
        this.log.debug((CharSequence)("Adding source file [" + (this.verbose ? sourceFile.getPath() : sourceFile.getName()) + "]."));
        this.files.add(sourceFile);
    }

    private List<File> getFilesToInclude(List<String> includes, List<String> excludes) {
        ArrayList<File> includedFiles = new ArrayList<File>();
        if (includes != null && !includes.isEmpty()) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(includes.toArray(new String[includes.size()]));
            scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
            scanner.addDefaultExcludes();
            scanner.setBasedir(this.sourceDir);
            scanner.scan();
            for (String includedFilename : scanner.getIncludedFiles()) {
                includedFiles.add(new File(this.sourceDir, includedFilename));
            }
            Collections.sort(includedFiles, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
        }
        return includedFiles;
    }
}

