/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.knoxwsm.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.samsung.knoxwsm.identity.KnoxIdentity;
import com.samsung.knoxwsm.identity.KnoxToken;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;

public class KnoxTokenUtility {
    private static final String JSON_PRIVATE_KEY_NAME = "Private";
    private static final String JSON_PUBLIC_KEY_NAME = "Public";
    private static final String JSON_ID_NAME = "Identifier";
    private static final String ALGORITHM = "RSA";

    private KnoxTokenUtility() {
    }

    public static Builder signedAccessTokenBuilder() {
        return new AccessTokenBuilder();
    }

    public static Builder signedClientIdentifierBuilder() {
        return new ClientIdentifierTokenBuilder();
    }

    public static String generateSignedAccessTokenJWT(PrivateKey privateKey, PublicKey publicKey, String token) {
        return KnoxTokenUtility.signedAccessTokenBuilder().setSigningKey(privateKey).setPublicKeyBase64EncodedString(publicKey).setToken(token).build();
    }

    public static String generateSignedAccessTokenJWT(KnoxIdentity knoxIdentity, String token) {
        return KnoxTokenUtility.signedAccessTokenBuilder().setSigningKey(knoxIdentity.getKeyPair().getPrivate()).setPublicKeyBase64EncodedString(knoxIdentity.getKeyPair().getPublic()).setToken(token).build();
    }

    public static String generateSignedAccessTokenJWT(InputStream knoxIdentityInputStream, String token) {
        return KnoxTokenUtility.signedAccessTokenBuilder().setKnoxIdentity(knoxIdentityInputStream).setToken(token).build();
    }

    public static String generateSignedClientIdentifierJWT(PrivateKey privateKey, String token) {
        return KnoxTokenUtility.signedClientIdentifierBuilder().setSigningKey(privateKey).setToken(token).build();
    }

    public static String generateSignedClientIdentifierJWT(KnoxIdentity knoxIdentity, String token) {
        return KnoxTokenUtility.signedClientIdentifierBuilder().setSigningKey(knoxIdentity.getKeyPair().getPrivate()).setToken(token).build();
    }

    public static String generateSignedClientIdentifierJWT(InputStream knoxIdentityInputStream, String token) {
        return KnoxTokenUtility.signedClientIdentifierBuilder().setKnoxIdentity(knoxIdentityInputStream).setToken(token).build();
    }

    public static String generateBase64EncodedStringPublicKey(InputStream knoxIdentityInputStream) {
        return Base64.encodeBase64String((byte[])KnoxTokenUtility.generateKnoxIdentity(knoxIdentityInputStream).getKeyPair().getPublic().getEncoded());
    }

    private static PrivateKey createPrivateKey(String pkcs8FormatStringPrivateKeyEncoded) {
        if (pkcs8FormatStringPrivateKeyEncoded == null || pkcs8FormatStringPrivateKeyEncoded.length() == 0) {
            throw new IllegalArgumentException("Cannot create private key from empty string");
        }
        try {
            byte[] bytes = Base64.decodeBase64((String)pkcs8FormatStringPrivateKeyEncoded);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not construct private key");
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Could not construct private key");
        }
    }

    static KnoxIdentity generateKnoxIdentity(InputStream inputStream) {
        Key privateKey = null;
        Key publicKey = null;
        String identifier = null;
        try {
            JsonNode jsonNode = new ObjectMapper().readTree(inputStream);
            privateKey = KnoxTokenUtility.constructKey(JSON_PRIVATE_KEY_NAME, jsonNode.get(JSON_PRIVATE_KEY_NAME).asText());
            publicKey = KnoxTokenUtility.constructKey(JSON_PUBLIC_KEY_NAME, jsonNode.get(JSON_PUBLIC_KEY_NAME).asText());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read contents of file.", e);
        }
        return new KnoxIdentity(new KeyPair((PublicKey)publicKey, (PrivateKey)privateKey), identifier);
    }

    private static Key constructKey(String keyType, String value) {
        Key key;
        block4: {
            key = null;
            try {
                if (JSON_PRIVATE_KEY_NAME.equals(keyType)) {
                    byte[] bytes = Base64.decodeBase64((String)value);
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
                    KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
                    key = keyFactory.generatePrivate(keySpec);
                    break block4;
                }
                if (JSON_PUBLIC_KEY_NAME.equals(keyType)) {
                    X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)value));
                    key = KeyFactory.getInstance(ALGORITHM).generatePublic(x509EncodedKeySpec);
                    break block4;
                }
                throw new RuntimeException();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not construct KeyPair from provided File", e);
            }
        }
        return key;
    }

    private static class ClientIdentifierTokenBuilder
    extends Builder {
        private ClientIdentifierTokenBuilder() {
        }
    }

    private static class AccessTokenBuilder
    extends Builder {
        private AccessTokenBuilder() {
        }
    }

    public static class Builder {
        private static final int DURATION_TOKEN_VALID = 30;
        private KnoxIdentity knoxIdentity;
        private PrivateKey privateKey;
        private PublicKey publicKey;
        private static final String AUDIENCE = "KnoxWSM";
        private static final String CLAIM_ACCESS_TOKEN = "accessToken";
        private static final String CLAIM_CLIENT_IDENTIFIER = "clientIdentifier";
        private static final String CLAIM_PUBLIC_KEY = "publicKey";
        private static final long DURATION_VALID_MILLISECONDS = 1800000L;
        private Map<String, Object> claims = new HashMap<String, Object>();
        private long durationValidForInMilliseconds;

        private Builder() {
        }

        public Builder setSigningKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder setPublicKeyBase64EncodedString(PublicKey publicKey) {
            this.publicKey = publicKey;
            this.claims.put(CLAIM_PUBLIC_KEY, Base64.encodeBase64String((byte[])publicKey.getEncoded()));
            return this;
        }

        public Builder setKnoxIdentity(InputStream knoxIdentityInputStream) {
            this.knoxIdentity = KnoxTokenUtility.generateKnoxIdentity(knoxIdentityInputStream);
            this.privateKey = this.knoxIdentity.getKeyPair().getPrivate();
            this.publicKey = this.knoxIdentity.getKeyPair().getPublic();
            this.claims.put(CLAIM_PUBLIC_KEY, Base64.encodeBase64String((byte[])this.publicKey.getEncoded()));
            return this;
        }

        public Builder setToken(String token) {
            if (this instanceof AccessTokenBuilder) {
                this.claims.put(CLAIM_ACCESS_TOKEN, token);
            } else if (this instanceof ClientIdentifierTokenBuilder) {
                this.claims.put(CLAIM_CLIENT_IDENTIFIER, token);
            }
            return this;
        }

        public Builder setValidForMinutes(int duration) {
            if (duration < 0 || duration > 30) {
                throw new IllegalArgumentException("Invalid duration provided. Duration must be >= 0 and <= 30");
            }
            this.durationValidForInMilliseconds = duration * 60 * 1000;
            return this;
        }

        public String build() {
            if (this.claims == null || this.claims.isEmpty()) {
                throw new IllegalArgumentException("Cannot create empty token. Please provide value for token");
            }
            Date nowDate = new Date();
            return Jwts.builder().setClaims(this.claims).setId(UUID.randomUUID().toString() + UUID.randomUUID().toString()).setIssuedAt(nowDate).setExpiration(new Date(nowDate.getTime() + (this.durationValidForInMilliseconds == 0L ? 1800000L : this.durationValidForInMilliseconds))).setAudience(AUDIENCE).signWith(SignatureAlgorithm.RS256, (Key)this.privateKey).compact();
        }

        public KnoxToken buildKnoxToken() {
            if (this.claims == null || this.claims.isEmpty()) {
                throw new IllegalArgumentException("Cannot create empty token. Please provide value for token");
            }
            Date nowDate = new Date();
            String jwt = Jwts.builder().setClaims(this.claims).setId(UUID.randomUUID().toString() + UUID.randomUUID().toString()).setIssuedAt(nowDate).setExpiration(new Date(nowDate.getTime() + (this.durationValidForInMilliseconds == 0L ? 1800000L : this.durationValidForInMilliseconds))).setAudience(AUDIENCE).signWith(SignatureAlgorithm.RS256, (Key)this.privateKey).compact();
            String identifier = this.knoxIdentity != null ? this.knoxIdentity.getIdentifier() : null;
            return new KnoxToken(identifier, jwt);
        }
    }
}

