/*
 * Decompiled with CFR 0.152.
 */
package com.edulify.play.hikaricp;

import com.edulify.play.hikaricp.HikariCPConfig;
import com.zaxxer.hikari.HikariConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import play.api.Configuration;
import play.api.Logger$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class HikariCPConfig$ {
    public static final HikariCPConfig$ MODULE$;
    private String DEFAULT_DATASOURCE_NAME;
    private String HIKARI_CP_PROPERTIES_FILE;
    private volatile byte bitmap$0;

    static {
        new HikariCPConfig$();
    }

    private String DEFAULT_DATASOURCE_NAME$lzycompute() {
        HikariCPConfig$ hikariCPConfig$ = this;
        synchronized (hikariCPConfig$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.DEFAULT_DATASOURCE_NAME = "default";
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.DEFAULT_DATASOURCE_NAME;
        }
    }

    private String HIKARI_CP_PROPERTIES_FILE$lzycompute() {
        HikariCPConfig$ hikariCPConfig$ = this;
        synchronized (hikariCPConfig$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.HIKARI_CP_PROPERTIES_FILE = "hikaricp.properties";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.HIKARI_CP_PROPERTIES_FILE;
        }
    }

    public String DEFAULT_DATASOURCE_NAME() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.DEFAULT_DATASOURCE_NAME$lzycompute() : this.DEFAULT_DATASOURCE_NAME;
    }

    public String HIKARI_CP_PROPERTIES_FILE() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.HIKARI_CP_PROPERTIES_FILE$lzycompute() : this.HIKARI_CP_PROPERTIES_FILE;
    }

    public HikariConfig getHikariConfig(Configuration dbConfig2) {
        File file = new File(this.HIKARI_CP_PROPERTIES_FILE());
        return file.exists() ? new HikariConfig(this.props(file)) : new HikariConfig(this.mapFromPlayConfiguration(dbConfig2));
    }

    /*
     * WARNING - void declaration
     */
    private Properties props(File file) {
        if (file.exists()) {
            void var2_2;
            Logger$.MODULE$.info((Function0)new Serializable(file){
                public static final long serialVersionUID = 0L;
                private final File file$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Loading Hikari configuration from ").append((Object)this.file$1).toString();
                }
                {
                    this.file$1 = file$1;
                }
            });
            Properties properties = this.loadProperties(file);
            this.logProperties(properties);
            return var2_2;
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hikari configuration file ", " doesn't exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
    }

    /*
     * WARNING - void declaration
     */
    private Properties loadProperties(File file) {
        void var2_2;
        Properties props2 = new Properties();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            props2.load(reader);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        reader.close();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Properties mapFromPlayConfiguration(Configuration dbConfig2) {
        void var3_3;
        Logger$.MODULE$.info((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Loading Hikari configuration from Play configuration.";
            }
        });
        Option configFile = dbConfig2.getString("hikaricp.file", dbConfig2.getString$default$2());
        if (configFile.nonEmpty()) {
            Logger$.MODULE$.info((Function0)new Serializable(configFile){
                public static final long serialVersionUID = 0L;
                private final Option configFile$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Loading from file configured by db.default.hikaricp.file that is ").append((Object)this.configFile$1).toString();
                }
                {
                    this.configFile$1 = configFile$1;
                }
            });
            return this.props(new File((String)configFile.get()));
        }
        HikariCPConfig.ConfigProperties properties = new HikariCPConfig.ConfigProperties(dbConfig2);
        properties.setPropertyFromConfig("driverClassName", "driver", properties.setPropertyFromConfig$default$3());
        properties.setPropertyFromConfig("jdbcUrl", "url", properties.setPropertyFromConfig$default$3());
        properties.setPropertyFromConfig("username", "user", properties.setPropertyFromConfig$default$3());
        properties.setPropertyFromConfig("password", "password", properties.setPropertyFromConfig$default$3());
        properties.setProperty("maximumPoolSize", this.maxPoolSize(dbConfig2));
        properties.setProperty("minimumIdle", this.minPoolSize(dbConfig2));
        properties.setProperty("maxLifetime", this.maxLifetime(dbConfig2));
        properties.setProperty("idleTimeout", this.idleTimeout(dbConfig2));
        properties.setProperty("connectionTimeout", this.connectionTimeout(dbConfig2));
        properties.setProperty("leakDetectionThreshold", this.leakDetectionThreshold(dbConfig2));
        properties.setPropertyFromConfig("catalog", "defaultCatalog", properties.setPropertyFromConfig$default$3());
        properties.setPropertyFromConfig("autoCommit", "defaultAutoCommit", "true");
        properties.setPropertyFromConfig("connectionTestQuery", "connectionTestStatement", properties.setPropertyFromConfig$default$3());
        properties.setProperty("jdbc4ConnectionTest", ((Object)BoxesRunTime.boxToBoolean((properties.getProperty("connectionTestQuery") == null ? 1 : 0) != 0)).toString());
        properties.setPropertyFromConfig("transactionIsolation", "defaultTransactionIsolation", properties.setPropertyFromConfig$default$3());
        properties.setPropertyFromConfig("readOnly", "defaultReadOnly", "false");
        properties.setPropertyFromConfig("registerMbeans", "statisticsEnabled", "false");
        properties.setPropertyFromConfig("connectionInitSql", "initSQL", properties.setPropertyFromConfig$default$3());
        this.logProperties(properties);
        return var3_3;
    }

    private void logProperties(Properties properties) {
        Logger$.MODULE$.info((Function0)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Properties: ").append((Object)((TraversableOnce)JavaConversions$.MODULE$.propertiesAsScalaMap(this.properties$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            if (name != null) {
                                String string = name;
                                if (value != null) {
                                    String string2 = value;
                                    String string3 = string.contains("password") ? new StringOps(Predef$.MODULE$.augmentString("%s=%.1s%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, string2, ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(string2.substring(string2.length()))).padTo(string2.length() - 1, (Object)"*", Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString()})) : new StringOps(Predef$.MODULE$.augmentString("%s=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, string2}));
                                    return string3;
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString();
            }
            {
                this.properties$1 = properties$1;
            }
        });
    }

    private String maxPoolSize(Configuration config) {
        int partitionCount = BoxesRunTime.unboxToInt((Object)config.getInt("partitionCount").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }));
        int maxConnectionsPerPartition = BoxesRunTime.unboxToInt((Object)config.getInt("maxConnectionsPerPartition").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 30;
            }
        }));
        return ((Object)BoxesRunTime.boxToInteger((int)(partitionCount * maxConnectionsPerPartition))).toString();
    }

    private String minPoolSize(Configuration config) {
        int partitionCount = BoxesRunTime.unboxToInt((Object)config.getInt("partitionCount").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 1;
            }
        }));
        int maxConnectionsPerPartition = BoxesRunTime.unboxToInt((Object)config.getInt("minConnectionsPerPartition").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 5;
            }
        }));
        return ((Object)BoxesRunTime.boxToInteger((int)(partitionCount * maxConnectionsPerPartition))).toString();
    }

    private String maxLifetime(Configuration config) {
        LongRef maxLife = new LongRef(BoxesRunTime.unboxToLong((Object)config.getLong("maxConnectionAgeInMinutes").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 30L;
            }
        })));
        maxLife.elem = BoxesRunTime.unboxToLong((Object)config.getLong("maxConnectionAgeInSeconds").getOrElse((Function0)new Serializable(maxLife){
            public static final long serialVersionUID = 0L;
            private final LongRef maxLife$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.maxLife$1.elem * 60L;
            }
            {
                this.maxLife$1 = maxLife$1;
            }
        }));
        maxLife.elem = BoxesRunTime.unboxToLong((Object)config.getMilliseconds("maxConnectionAge").getOrElse((Function0)new Serializable(maxLife){
            public static final long serialVersionUID = 0L;
            private final LongRef maxLife$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.maxLife$1.elem * 1000L;
            }
            {
                this.maxLife$1 = maxLife$1;
            }
        }));
        return ((Object)BoxesRunTime.boxToLong((long)maxLife.elem)).toString();
    }

    private String idleTimeout(Configuration config) {
        LongRef idleMaxAge = new LongRef(BoxesRunTime.unboxToLong((Object)config.getLong("idleMaxAgeInMinutes").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 10L;
            }
        })));
        idleMaxAge.elem = BoxesRunTime.unboxToLong((Object)config.getLong("idleMaxAgeInSeconds").getOrElse((Function0)new Serializable(idleMaxAge){
            public static final long serialVersionUID = 0L;
            private final LongRef idleMaxAge$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.idleMaxAge$1.elem;
            }
            {
                this.idleMaxAge$1 = idleMaxAge$1;
            }
        })) * 60L;
        idleMaxAge.elem = BoxesRunTime.unboxToLong((Object)config.getMilliseconds("idleMaxAge").getOrElse((Function0)new Serializable(idleMaxAge){
            public static final long serialVersionUID = 0L;
            private final LongRef idleMaxAge$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.idleMaxAge$1.elem;
            }
            {
                this.idleMaxAge$1 = idleMaxAge$1;
            }
        })) * 1000L;
        return ((Object)BoxesRunTime.boxToLong((long)idleMaxAge.elem)).toString();
    }

    private String connectionTimeout(Configuration config) {
        LongRef timeout = new LongRef(BoxesRunTime.unboxToLong((Object)config.getLong("connectionTimeoutInMs").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 30000L;
            }
        })));
        timeout.elem = BoxesRunTime.unboxToLong((Object)config.getMilliseconds("connectionTimeout").getOrElse((Function0)new Serializable(timeout){
            public static final long serialVersionUID = 0L;
            private final LongRef timeout$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.timeout$1.elem;
            }
            {
                this.timeout$1 = timeout$1;
            }
        }));
        return ((Object)BoxesRunTime.boxToLong((long)timeout.elem)).toString();
    }

    private String leakDetectionThreshold(Configuration config) {
        ObjectRef threshold = new ObjectRef(config.getLong("closeConnectionWatchTimeoutInMs").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        threshold.elem = config.getMilliseconds("closeConnectionWatchTimeout").getOrElse((Function0)new Serializable(threshold){
            public static final long serialVersionUID = 0L;
            private final ObjectRef threshold$1;

            public final Object apply() {
                return this.threshold$1.elem;
            }
            {
                this.threshold$1 = threshold$1;
            }
        });
        return threshold.elem.toString();
    }

    private HikariCPConfig$() {
        MODULE$ = this;
    }
}

