/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.AbstractGetval;
import com.sap.db.jdbc.converters.AbstractPutval;
import com.sap.db.jdbc.converters.GetvalBlob;
import com.sap.db.jdbc.converters.GetvalClob;
import com.sap.db.jdbc.converters.PutvalBlob;
import com.sap.db.jdbc.converters.PutvalClob;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Set;

@NotThreadSafe
abstract class AbstractLobConverter
extends AbstractConverter {
    protected AbstractLobConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, false, null, true);
    }

    protected abstract AbstractGetval _getLob(SQLParamController var1, HDataPart var2) throws SQLException;

    @Override
    public int getEstimatedColumnSize() {
        return 1056;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof AbstractPutval)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        return 10;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof AbstractPutval)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        return ((AbstractPutval)data).putDescriptor(true, dataPart);
    }

    @Override
    public int getPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        AbstractGetval getval = this._getLob(controller, dataPart);
        return getval;
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        if (value instanceof byte[]) {
            return this.setBytes((byte[])value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        AbstractGetval getval = this._getLob(controller, dataPart);
        return getval != null ? getval._getString() : null;
    }

    @Override
    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        AbstractGetval getval = this._getLob(controller, dataPart);
        return getval != null ? getval._getBytes() : null;
    }

    @Override
    public Reader getCharacterStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        AbstractGetval getval = this._getLob(controller, dataPart);
        return getval != null ? getval._getCharacterStream() : null;
    }

    @Override
    public InputStream getAsciiStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        AbstractGetval getval = this._getLob(controller, dataPart);
        return getval != null ? getval._getAsciiStream() : null;
    }

    @Override
    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        AbstractGetval getval = this._getLob(controller, dataPart);
        return getval != null ? getval._getBinaryStream() : null;
    }

    @Override
    public Object cloneObjectForBatch(Object object) {
        return object != null ? ((AbstractPutval)object).cloneForBatch() : null;
    }

    protected static PutvalClob _convertStringToClob(String value, int inputFieldPos, boolean isNClob) throws SQLException {
        return new PutvalClob(value, inputFieldPos, null, -1, isNClob);
    }

    protected static PutvalBlob _convertBytesToBlob(byte[] value, int inputFieldPos) throws SQLException {
        return new PutvalBlob(value, inputFieldPos, null, -1);
    }

    protected static PutvalClob _convertReaderToClob(Reader reader, long length, int inputFieldPos, boolean isNClob) throws SQLException {
        return new PutvalClob(reader, length, inputFieldPos, isNClob);
    }

    protected static PutvalBlob _convertInputStreamToBlob(InputStream stream, long length, int inputFieldPos) throws SQLException {
        return new PutvalBlob(stream, length, inputFieldPos);
    }

    protected static PutvalClob _convertClobToClob(Clob value, int inputFieldPos, boolean isNClob) throws SQLException {
        Reader reader = null;
        try {
            reader = value instanceof GetvalClob ? ((GetvalClob)value)._getCharacterStream() : value.getCharacterStream();
            PutvalClob putvalClob = reader != null ? AbstractLobConverter._convertReaderToClob(reader, -1L, inputFieldPos, isNClob) : null;
            return putvalClob;
        }
        catch (SQLException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static PutvalBlob _convertBlobToBlob(Blob value, int inputFieldPos) throws SQLException {
        InputStream stream = null;
        try {
            stream = value instanceof GetvalBlob ? ((GetvalBlob)value)._getBinaryStream() : value.getBinaryStream();
            PutvalBlob putvalBlob = stream != null ? AbstractLobConverter._convertInputStreamToBlob(stream, -1L, inputFieldPos) : null;
            return putvalBlob;
        }
        catch (SQLException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

