/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum ProfileElement {
    SendTime(0),
    ReceiveTime(1),
    Unknown(-1);

    private static final ProfileElement[] VALUES;

    public static ProfileElement decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return ProfileElement.decode(value).name() + '(' + value + ')';
    }

    private ProfileElement(int value) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = ProfileElement.values();
    }
}

