/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.trace.TraceConfiguration;
import com.sap.db.util.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

@NotThreadSafe
public class TraceTool
extends JFrame
implements WindowListener,
ActionListener,
DocumentListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static final String TITLE = "HANA JDBC Driver Trace Configuration";
    private static final Dimension DIMENSION = new Dimension(900, 550);
    private static final Insets INSETS = new Insets(5, 5, 5, 5);
    private static final Insets INSETS_INDENT = new Insets(5, 25, 5, 5);
    private final GridBagConstraints _gridBagConstraints = new GridBagConstraints();
    private final TraceConfiguration _settings = new TraceConfiguration();
    private boolean _hasUnsavedChanges;
    private JLabel _driverVersionTextLabel;
    private JLabel _driverVersionLabel;
    private JLabel _settingsFileNameTextLabel;
    private JLabel _settingsFileNameLabel;
    private JLabel _sharedMemoryFileNameTextLabel;
    private JLabel _sharedMemoryFileNameLabel;
    private JCheckBox _traceEnabledCheckBox;
    private JLabel _traceFileNameTextLabel;
    private JTextField _traceFileNameTextField;
    private JButton _traceFileNameBrowseButton;
    private JLabel _traceLevelTextLabel;
    private JCheckBox _traceLevelConnectionsCheckBox;
    private JCheckBox _traceLevelAPICheckBox;
    private JCheckBox _traceLevelPacketCheckBox;
    private JCheckBox _traceLevelDistributionCheckBox;
    private JCheckBox _traceLevelStatisticsCheckBox;
    private JCheckBox _traceLevelCleanersCheckBox;
    private JCheckBox _traceLevelDebugCheckBox;
    private JCheckBox _showPlainTextCSECheckBox;
    private JCheckBox _showTimestampsCheckBox;
    private JCheckBox _showElapsedTimesCheckBox;
    private JCheckBox _limitFileSizeCheckBox;
    private JTextField _limitFileSizeTextField;
    private JComboBox<String> _limitFileSizeComboBox;
    private JCheckBox _stopOnErrorCheckBox;
    private JTextField _stopOnErrorTextField;
    private JCheckBox _performanceTraceEnabledCheckBox;
    private JLabel _performanceTraceFileNameTextLabel;
    private JTextField _performanceTraceFileNameTextField;
    private JButton _performanceTraceFileNameBrowseButton;
    private JButton _okButton;
    private JButton _cancelButton;
    private JButton _applyButton;

    public static void showWindow() {
        SwingUtilities.invokeLater(TraceTool::new);
    }

    private TraceTool() {
        this._initFrame();
        this._loadSettings();
        this._enableComponents();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Object source = e.getSource();
        if (source == this) {
            System.exit(0);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._traceEnabledCheckBox || source == this._traceLevelConnectionsCheckBox || source == this._traceLevelAPICheckBox || source == this._traceLevelPacketCheckBox || source == this._traceLevelDistributionCheckBox || source == this._traceLevelStatisticsCheckBox || source == this._traceLevelCleanersCheckBox || source == this._traceLevelDebugCheckBox || source == this._showPlainTextCSECheckBox || source == this._showTimestampsCheckBox || source == this._showElapsedTimesCheckBox || source == this._limitFileSizeCheckBox || source == this._limitFileSizeComboBox || source == this._stopOnErrorCheckBox || source == this._performanceTraceEnabledCheckBox) {
            this._hasUnsavedChanges = true;
            this._enableComponents();
        } else if (source == this._traceFileNameBrowseButton) {
            this._browseForTraceFile();
        } else if (source == this._performanceTraceFileNameBrowseButton) {
            this._browseForPerformanceTraceFile();
        } else if (source == this._okButton) {
            this._handleOK();
        } else if (source == this._cancelButton) {
            this._handleCancel();
        } else if (source == this._applyButton) {
            this._handleApply();
        } else {
            String command = e.getActionCommand();
            if (command != null && command.equals(ESCAPE_KEY_COMMAND)) {
                this._handleCancel();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this._handleDocumentEvent(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this._handleDocumentEvent(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this._handleDocumentEvent(e);
    }

    private void _handleDocumentEvent(DocumentEvent e) {
        Document source = e.getDocument();
        if (source == this._traceFileNameTextField.getDocument() || source == this._limitFileSizeTextField.getDocument() || source == this._stopOnErrorTextField.getDocument() || source == this._performanceTraceFileNameTextField.getDocument()) {
            this._hasUnsavedChanges = true;
            this._enableComponents();
        }
    }

    private static void _setPreferredWidthToDigits(JTextField textField, int digitCount) {
        FontMetrics fontMetrics = textField.getFontMetrics(textField.getFont());
        char[] nines = new char[digitCount];
        Arrays.fill(nines, '9');
        int width = fontMetrics.stringWidth(String.valueOf(nines));
        TraceTool._setPreferredWidth(textField, width, true, true);
    }

    private static void _setPreferredWidth(JTextField textField, int width, boolean addInsets, boolean setMinimumSize) {
        if (addInsets) {
            Insets borderInsets;
            Border border;
            Insets insets = textField.getInsets();
            if (insets != null) {
                width += insets.left + insets.right;
            }
            if ((border = textField.getBorder()) != null && (borderInsets = border.getBorderInsets(textField)) != null) {
                width += borderInsets.left + borderInsets.right;
            }
        }
        textField.setPreferredSize(new Dimension(width, textField.getPreferredSize().height));
        if (setMinimumSize) {
            textField.setMinimumSize(new Dimension(width, textField.getPreferredSize().height));
        }
    }

    private static void _makeComponentsSameWidth(JComponent ... components) {
        int i;
        int count = components.length;
        int[] widths = new int[count];
        for (i = 0; i < count; ++i) {
            widths[i] = components[i].getPreferredSize().width;
        }
        int width = 0;
        for (i = 0; i < count; ++i) {
            if (widths[i] <= width) continue;
            width = widths[i];
        }
        for (JComponent component : components) {
            component.setMinimumSize(new Dimension(width, component.getMinimumSize().height));
            component.setPreferredSize(new Dimension(width, component.getPreferredSize().height));
            component.setMaximumSize(new Dimension(width, component.getMaximumSize().height));
        }
    }

    private void _initFrame() {
        this.setTitle(TITLE);
        this.setSize(DIMENSION);
        this.setContentPane(this._initContentPanel());
        this.pack();
        this.setVisible(true);
        this.addWindowListener(this);
    }

    private JPanel _initContentPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(INSETS));
        contentPanel.setPreferredSize(DIMENSION);
        contentPanel.add((Component)this._initSettingsPanel(), "Center");
        contentPanel.add((Component)this._initButtonPanel(), "South");
        return contentPanel;
    }

    private JPanel _initSettingsPanel() {
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        int gridy = -1;
        settingsPanel.setBorder(new EmptyBorder(INSETS));
        this._driverVersionTextLabel = new JLabel("Driver version:");
        this._driverVersionLabel = new JLabel();
        this._driverVersionLabel.setFont(new Font("Dialog", 0, 12));
        this._addToGridBag(settingsPanel, this._driverVersionTextLabel, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(settingsPanel, this._driverVersionLabel, 1, gridy, 0, 1, 1.0, 0.0, 17, 2, INSETS);
        this._settingsFileNameTextLabel = new JLabel("Settings file name:");
        this._settingsFileNameLabel = new JLabel();
        this._settingsFileNameLabel.setFont(new Font("Dialog", 0, 12));
        this._addToGridBag(settingsPanel, this._settingsFileNameTextLabel, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(settingsPanel, this._settingsFileNameLabel, 1, gridy, 0, 1, 1.0, 0.0, 17, 2, INSETS);
        this._sharedMemoryFileNameTextLabel = new JLabel("Shared memory file name:");
        this._sharedMemoryFileNameLabel = new JLabel();
        this._sharedMemoryFileNameLabel.setFont(new Font("Dialog", 0, 12));
        this._addToGridBag(settingsPanel, this._sharedMemoryFileNameTextLabel, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(settingsPanel, this._sharedMemoryFileNameLabel, 1, gridy, 0, 1, 1.0, 0.0, 17, 2, INSETS);
        this._addToGridBag(settingsPanel, new JSeparator(), 0, ++gridy, 0, 1, 1.0, 0.0, 17, 2, INSETS);
        this._traceEnabledCheckBox = new JCheckBox("Enable tracing");
        this._traceEnabledCheckBox.setMnemonic('E');
        this._addToGridBag(settingsPanel, this._traceEnabledCheckBox, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, INSETS);
        this._traceFileNameTextField = new JTextField();
        this._traceFileNameTextLabel = new JLabel("Trace file name:");
        this._traceFileNameTextLabel.setDisplayedMnemonic('T');
        this._traceFileNameTextLabel.setLabelFor(this._traceFileNameTextField);
        this._traceFileNameBrowseButton = new JButton("Browse");
        this._traceFileNameBrowseButton.setMnemonic('B');
        this._addToGridBag(settingsPanel, this._traceFileNameTextLabel, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, INSETS_INDENT);
        this._addToGridBag(settingsPanel, this._traceFileNameTextField, 1, gridy, 2, 1, 1.0, 0.0, 17, 2, INSETS);
        this._addToGridBag(settingsPanel, this._traceFileNameBrowseButton, 3, gridy, 0, 1, 0.0, 0.0, 17, 0, INSETS);
        this._traceLevelTextLabel = new JLabel("Trace levels:");
        this._traceLevelConnectionsCheckBox = new JCheckBox("Connections");
        this._traceLevelConnectionsCheckBox.setMnemonic('C');
        this._traceLevelAPICheckBox = new JCheckBox("JDBC APIs");
        this._traceLevelAPICheckBox.setMnemonic('J');
        this._traceLevelPacketCheckBox = new JCheckBox("Packets");
        this._traceLevelPacketCheckBox.setMnemonic('P');
        this._traceLevelDistributionCheckBox = new JCheckBox("Distribution");
        this._traceLevelDistributionCheckBox.setMnemonic('D');
        this._traceLevelStatisticsCheckBox = new JCheckBox("Statistics");
        this._traceLevelStatisticsCheckBox.setMnemonic('S');
        this._traceLevelCleanersCheckBox = new JCheckBox("Cleaners");
        this._traceLevelCleanersCheckBox.setMnemonic('l');
        this._traceLevelDebugCheckBox = new JCheckBox("Debug");
        this._traceLevelDebugCheckBox.setMnemonic('g');
        this._addToGridBag(settingsPanel, this._traceLevelTextLabel, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, INSETS_INDENT);
        JPanel subPanel = new JPanel(new GridBagLayout());
        subPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._addToGridBag(subPanel, this._traceLevelConnectionsCheckBox, 0, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(subPanel, this._traceLevelAPICheckBox, 1, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(subPanel, this._traceLevelPacketCheckBox, 2, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(subPanel, this._traceLevelDistributionCheckBox, 3, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(subPanel, this._traceLevelStatisticsCheckBox, 4, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(subPanel, this._traceLevelCleanersCheckBox, 5, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(subPanel, this._traceLevelDebugCheckBox, 6, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(settingsPanel, subPanel, 1, gridy, 0, 1, 0.0, 0.0, 17, 0, INSETS);
        this._showPlainTextCSECheckBox = new JCheckBox("Show client-side encrypted values in plain-text");
        this._showPlainTextCSECheckBox.setMnemonic('h');
        this._addToGridBag(settingsPanel, this._showPlainTextCSECheckBox, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, INSETS_INDENT);
        this._showTimestampsCheckBox = new JCheckBox("Show timestamps");
        this._showTimestampsCheckBox.setMnemonic('w');
        this._addToGridBag(settingsPanel, this._showTimestampsCheckBox, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, INSETS_INDENT);
        this._showElapsedTimesCheckBox = new JCheckBox("Show elapsed times");
        this._showElapsedTimesCheckBox.setMnemonic('m');
        this._addToGridBag(settingsPanel, this._showElapsedTimesCheckBox, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, INSETS_INDENT);
        this._limitFileSizeCheckBox = new JCheckBox("Limit trace file to:");
        this._limitFileSizeCheckBox.setMnemonic('i');
        this._limitFileSizeTextField = new JTextField();
        this._limitFileSizeTextField.setHorizontalAlignment(4);
        TraceTool._setPreferredWidthToDigits(this._limitFileSizeTextField, 19);
        this._limitFileSizeTextField.setDocument(new IntegerDocument());
        this._limitFileSizeComboBox = new JComboBox<String>(TraceConfiguration.SizeUnits.getDisplayStrings());
        this._addToGridBag(settingsPanel, this._limitFileSizeCheckBox, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, INSETS_INDENT);
        this._addToGridBag(settingsPanel, this._limitFileSizeTextField, 1, gridy, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(settingsPanel, this._limitFileSizeComboBox, 2, gridy, 0, 1, 0.0, 0.0, 17, 0, INSETS);
        this._stopOnErrorCheckBox = new JCheckBox("Stop tracing on error code:");
        this._stopOnErrorCheckBox.setMnemonic('o');
        this._stopOnErrorTextField = new JTextField();
        TraceTool._setPreferredWidthToDigits(this._stopOnErrorTextField, 6);
        this._addToGridBag(settingsPanel, this._stopOnErrorCheckBox, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, INSETS_INDENT);
        this._addToGridBag(settingsPanel, this._stopOnErrorTextField, 1, gridy, 0, 1, 0.0, 0.0, 17, 0, INSETS);
        this._performanceTraceEnabledCheckBox = new JCheckBox("Enable performance tracing");
        this._performanceTraceEnabledCheckBox.setMnemonic('n');
        this._addToGridBag(settingsPanel, this._performanceTraceEnabledCheckBox, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, INSETS);
        this._performanceTraceFileNameTextField = new JTextField();
        this._performanceTraceFileNameTextLabel = new JLabel("Performance trace file name:");
        this._performanceTraceFileNameTextLabel.setDisplayedMnemonic('f');
        this._performanceTraceFileNameTextLabel.setLabelFor(this._performanceTraceFileNameTextField);
        this._performanceTraceFileNameBrowseButton = new JButton("Browse");
        this._performanceTraceFileNameBrowseButton.setMnemonic('r');
        this._addToGridBag(settingsPanel, this._performanceTraceFileNameTextLabel, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, INSETS_INDENT);
        this._addToGridBag(settingsPanel, this._performanceTraceFileNameTextField, 1, gridy, 2, 1, 1.0, 0.0, 17, 2, INSETS);
        this._addToGridBag(settingsPanel, this._performanceTraceFileNameBrowseButton, 3, gridy, 0, 1, 0.0, 0.0, 17, 0, INSETS);
        this._addToGridBag(settingsPanel, Box.createGlue(), 0, ++gridy, 0, 1, 1.0, 1.0, 10, 1, INSETS);
        this._traceEnabledCheckBox.addActionListener(this);
        this._traceFileNameTextField.getDocument().addDocumentListener(this);
        this._traceFileNameBrowseButton.addActionListener(this);
        this._traceLevelConnectionsCheckBox.addActionListener(this);
        this._traceLevelAPICheckBox.addActionListener(this);
        this._traceLevelPacketCheckBox.addActionListener(this);
        this._traceLevelDistributionCheckBox.addActionListener(this);
        this._traceLevelStatisticsCheckBox.addActionListener(this);
        this._traceLevelCleanersCheckBox.addActionListener(this);
        this._traceLevelDebugCheckBox.addActionListener(this);
        this._showPlainTextCSECheckBox.addActionListener(this);
        this._showTimestampsCheckBox.addActionListener(this);
        this._showElapsedTimesCheckBox.addActionListener(this);
        this._limitFileSizeCheckBox.addActionListener(this);
        this._limitFileSizeTextField.getDocument().addDocumentListener(this);
        this._limitFileSizeComboBox.addActionListener(this);
        this._stopOnErrorCheckBox.addActionListener(this);
        this._stopOnErrorTextField.getDocument().addDocumentListener(this);
        this._performanceTraceEnabledCheckBox.addActionListener(this);
        this._performanceTraceFileNameTextField.getDocument().addDocumentListener(this);
        this._performanceTraceFileNameBrowseButton.addActionListener(this);
        return settingsPanel;
    }

    private JPanel _initButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        JRootPane rootPane = this.getRootPane();
        buttonPanel.setBorder(new EmptyBorder(INSETS));
        this._okButton = new JButton("OK");
        rootPane.setDefaultButton(this._okButton);
        this._cancelButton = new JButton("Cancel");
        rootPane.registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this._applyButton = new JButton("Apply");
        this._applyButton.setMnemonic('A');
        TraceTool._makeComponentsSameWidth(this._okButton, this._cancelButton, this._applyButton);
        this._addToGridBag(buttonPanel, this._okButton, 0, 0, 1, 1, 0.0, 0.0, 13, 0, INSETS);
        this._addToGridBag(buttonPanel, this._cancelButton, 1, 0, 1, 1, 0.0, 0.0, 10, 0, INSETS);
        this._addToGridBag(buttonPanel, this._applyButton, 2, 0, 1, 1, 0.0, 0.0, 17, 0, INSETS);
        this._okButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        this._applyButton.addActionListener(this);
        return buttonPanel;
    }

    private void _addToGridBag(JPanel panel, Component component, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        this._gridBagConstraints.gridx = gridx;
        this._gridBagConstraints.gridy = gridy;
        this._gridBagConstraints.gridwidth = gridwidth;
        this._gridBagConstraints.gridheight = gridheight;
        this._gridBagConstraints.weightx = weightx;
        this._gridBagConstraints.weighty = weighty;
        this._gridBagConstraints.anchor = anchor;
        this._gridBagConstraints.fill = fill;
        this._gridBagConstraints.insets = insets;
        this._gridBagConstraints.ipadx = 0;
        this._gridBagConstraints.ipady = 0;
        panel.add(component, this._gridBagConstraints);
    }

    private void _loadSettings() {
        int stopOnError = this._settings.getStopOnError();
        this._driverVersionLabel.setText(Driver.getVersionInfo().toShortVersionNumberString());
        this._settingsFileNameLabel.setText(TraceConfiguration.getSettingsFileName());
        this._sharedMemoryFileNameLabel.setText(TraceConfiguration.getSharedMemoryFileName());
        this._traceEnabledCheckBox.setSelected(this._settings.isTraceEnabled());
        this._traceFileNameTextField.setText(this._settings.getTraceFileName());
        this._traceLevelConnectionsCheckBox.setSelected(this._settings.hasTraceLevel(TraceConfiguration.TraceLevel.CONNECTIONS));
        this._traceLevelAPICheckBox.setSelected(this._settings.hasTraceLevel(TraceConfiguration.TraceLevel.API));
        this._traceLevelPacketCheckBox.setSelected(this._settings.hasTraceLevel(TraceConfiguration.TraceLevel.PACKET));
        this._traceLevelDistributionCheckBox.setSelected(this._settings.hasTraceLevel(TraceConfiguration.TraceLevel.DISTRIBUTION));
        this._traceLevelStatisticsCheckBox.setSelected(this._settings.hasTraceLevel(TraceConfiguration.TraceLevel.STATISTICS));
        this._traceLevelCleanersCheckBox.setSelected(this._settings.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS));
        this._traceLevelDebugCheckBox.setSelected(this._settings.hasTraceLevel(TraceConfiguration.TraceLevel.DEBUG));
        this._showPlainTextCSECheckBox.setSelected(this._settings.isShowPlainTextCSEEnabled());
        this._showTimestampsCheckBox.setSelected(this._settings.isShowTimestampsEnabled());
        this._showElapsedTimesCheckBox.setSelected(this._settings.isShowElapsedTimesEnabled());
        if (this._settings.getTraceSize() == Long.MAX_VALUE) {
            this._limitFileSizeCheckBox.setSelected(false);
        } else {
            this._limitFileSizeCheckBox.setSelected(true);
            this._limitFileSizeTextField.setText(this._settings.getDisplayTraceSize());
            this._limitFileSizeComboBox.setSelectedItem(this._settings.getDisplayTraceSizeUnits());
        }
        if (stopOnError == 0) {
            this._stopOnErrorCheckBox.setSelected(false);
        } else {
            this._stopOnErrorCheckBox.setSelected(true);
            this._stopOnErrorTextField.setText(String.valueOf(this._settings.getStopOnError()));
        }
        this._performanceTraceEnabledCheckBox.setSelected(this._settings.isPerformanceTraceEnabled());
        this._performanceTraceFileNameTextField.setText(this._settings.getPerformanceTraceFileName());
        this._hasUnsavedChanges = false;
    }

    private boolean _saveSettings() {
        String fileName;
        if (!this._hasUnsavedChanges) {
            return true;
        }
        boolean isTraceEnabledSelected = this._traceEnabledCheckBox.isSelected();
        boolean isTraceLevelConnectionsSelected = this._traceLevelConnectionsCheckBox.isSelected();
        boolean isTraceLevelAPISelected = this._traceLevelAPICheckBox.isSelected();
        boolean isTraceLevelPacketSelected = this._traceLevelPacketCheckBox.isSelected();
        boolean isTraceLevelDistributionSelected = this._traceLevelDistributionCheckBox.isSelected();
        boolean isTraceLevelStatisticsSelected = this._traceLevelStatisticsCheckBox.isSelected();
        boolean isTraceLevelCleanersSelected = this._traceLevelCleanersCheckBox.isSelected();
        boolean isTraceLevelDebugSelected = this._traceLevelDebugCheckBox.isSelected();
        boolean isPerformanceTraceEnabledSelected = this._performanceTraceEnabledCheckBox.isSelected();
        this._settings.setTraceEnabled(isTraceEnabledSelected);
        if (isTraceEnabledSelected) {
            fileName = this._traceFileNameTextField.getText().trim();
            if (fileName.isEmpty()) {
                this._showError("You must specify a trace file name.");
                this._traceFileNameTextField.requestFocusInWindow();
                return false;
            }
            this._settings.setTraceFileName(fileName);
            if (!(isTraceLevelConnectionsSelected || isTraceLevelAPISelected || isTraceLevelPacketSelected || isTraceLevelDistributionSelected || isTraceLevelStatisticsSelected || isTraceLevelCleanersSelected || isTraceLevelDebugSelected)) {
                this._showError("You must select at least one trace level. ");
                this._traceLevelConnectionsCheckBox.requestFocusInWindow();
                return false;
            }
            this._settings.setTraceLevel(TraceConfiguration.TraceLevel.CONNECTIONS, isTraceLevelConnectionsSelected);
            this._settings.setTraceLevel(TraceConfiguration.TraceLevel.API, isTraceLevelAPISelected);
            this._settings.setTraceLevel(TraceConfiguration.TraceLevel.PACKET, isTraceLevelPacketSelected);
            this._settings.setTraceLevel(TraceConfiguration.TraceLevel.DISTRIBUTION, isTraceLevelDistributionSelected);
            this._settings.setTraceLevel(TraceConfiguration.TraceLevel.STATISTICS, isTraceLevelStatisticsSelected);
            this._settings.setTraceLevel(TraceConfiguration.TraceLevel.CLEANERS, isTraceLevelCleanersSelected);
            this._settings.setTraceLevel(TraceConfiguration.TraceLevel.DEBUG, isTraceLevelDebugSelected);
            this._settings.setShowPlainTextCSEEnabled(this._showPlainTextCSECheckBox.isSelected());
            this._settings.setShowTimestampsEnabled(this._showTimestampsCheckBox.isSelected());
            this._settings.setShowElapsedTimesEnabled(this._showElapsedTimesCheckBox.isSelected());
            if (this._limitFileSizeCheckBox.isSelected()) {
                try {
                    this._settings.setTraceSize(Long.parseLong(this._limitFileSizeTextField.getText()), (String)this._limitFileSizeComboBox.getSelectedItem());
                }
                catch (NumberFormatException e) {
                    this._showError("You must specify a file size.");
                    this._limitFileSizeTextField.requestFocusInWindow();
                    return false;
                }
            } else {
                this._settings.setTraceSize(Long.MAX_VALUE, "");
            }
            if (this._stopOnErrorCheckBox.isSelected()) {
                try {
                    this._settings.setStopOnError(Integer.parseInt(this._stopOnErrorTextField.getText()));
                }
                catch (NumberFormatException e) {
                    this._showError("You must specify an error code number.");
                    this._stopOnErrorTextField.requestFocusInWindow();
                    return false;
                }
            } else {
                this._settings.setStopOnError(0);
            }
        }
        this._settings.setPerformanceTraceEnabled(isPerformanceTraceEnabledSelected);
        if (isPerformanceTraceEnabledSelected) {
            fileName = this._performanceTraceFileNameTextField.getText().trim();
            if (fileName.isEmpty()) {
                this._showError("You must specify a performance trace file name.");
                this._performanceTraceFileNameTextField.requestFocusInWindow();
                return false;
            }
            this._settings.setPerformanceTraceFileName(fileName);
        }
        try {
            this._settings.saveTraceSettings();
        }
        catch (IOException e) {
            this._showError("Could not save trace settings: " + e.getMessage());
            return false;
        }
        this._settings.setTraceSettingsChanged();
        this._hasUnsavedChanges = false;
        return true;
    }

    private void _enableComponents() {
        boolean isTraceEnabledSelected = this._traceEnabledCheckBox.isSelected();
        boolean isTraceLevelAPISelected = this._traceLevelAPICheckBox.isSelected();
        boolean isLimitFileSizeSelected = this._limitFileSizeCheckBox.isSelected();
        boolean isStopOnErrorSelected = this._stopOnErrorCheckBox.isSelected();
        boolean isPerformanceTraceEnabledSelected = this._performanceTraceEnabledCheckBox.isSelected();
        this._traceFileNameTextLabel.setEnabled(isTraceEnabledSelected);
        this._traceFileNameTextField.setEnabled(isTraceEnabledSelected);
        this._traceFileNameBrowseButton.setEnabled(isTraceEnabledSelected);
        this._traceLevelTextLabel.setEnabled(isTraceEnabledSelected);
        this._traceLevelConnectionsCheckBox.setEnabled(isTraceEnabledSelected);
        this._traceLevelAPICheckBox.setEnabled(isTraceEnabledSelected);
        this._traceLevelPacketCheckBox.setEnabled(isTraceEnabledSelected);
        this._traceLevelDistributionCheckBox.setEnabled(isTraceEnabledSelected);
        this._traceLevelStatisticsCheckBox.setEnabled(isTraceEnabledSelected);
        this._traceLevelCleanersCheckBox.setEnabled(isTraceEnabledSelected);
        this._traceLevelDebugCheckBox.setEnabled(isTraceEnabledSelected);
        this._showPlainTextCSECheckBox.setEnabled(isTraceEnabledSelected && isTraceLevelAPISelected);
        this._showTimestampsCheckBox.setEnabled(isTraceEnabledSelected);
        this._showElapsedTimesCheckBox.setEnabled(isTraceEnabledSelected);
        this._limitFileSizeCheckBox.setEnabled(isTraceEnabledSelected);
        this._limitFileSizeTextField.setEnabled(isTraceEnabledSelected && isLimitFileSizeSelected);
        this._limitFileSizeComboBox.setEnabled(isTraceEnabledSelected && isLimitFileSizeSelected);
        this._stopOnErrorCheckBox.setEnabled(isTraceEnabledSelected);
        this._stopOnErrorTextField.setEnabled(isTraceEnabledSelected && isStopOnErrorSelected);
        this._performanceTraceFileNameTextLabel.setEnabled(isPerformanceTraceEnabledSelected);
        this._performanceTraceFileNameTextField.setEnabled(isPerformanceTraceEnabledSelected);
        this._performanceTraceFileNameBrowseButton.setEnabled(isPerformanceTraceEnabledSelected);
        this._applyButton.setEnabled(this._hasUnsavedChanges);
    }

    private void _browseForTraceFile() {
        String directoryName = FileUtils.getDirectoryName(this._traceFileNameTextField.getText());
        JFileChooser fileChooser = new JFileChooser(directoryName);
        if (0 == fileChooser.showDialog(this, "Choose Trace File")) {
            File file = fileChooser.getSelectedFile();
            this._traceFileNameTextField.setText(file.getAbsolutePath());
        }
    }

    private void _browseForPerformanceTraceFile() {
        String directoryName = FileUtils.getDirectoryName(this._performanceTraceFileNameTextField.getText());
        JFileChooser fileChooser = new JFileChooser(directoryName);
        if (0 == fileChooser.showDialog(this, "Choose Performance Trace File")) {
            File file = fileChooser.getSelectedFile();
            this._performanceTraceFileNameTextField.setText(file.getAbsolutePath());
        }
    }

    private void _handleOK() {
        if (this._saveSettings()) {
            System.exit(0);
        }
    }

    private void _handleCancel() {
        System.exit(0);
    }

    private void _handleApply() {
        this._saveSettings();
        this._enableComponents();
    }

    private void _showError(String error) {
        JOptionPane.showMessageDialog(this, error, TITLE, 0);
    }

    private static class IntegerDocument
    extends PlainDocument {
        private IntegerDocument() {
        }

        @Override
        public void insertString(int offset, String text, AttributeSet a) throws BadLocationException {
            char[] source = text.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            int n = result.length;
            for (int i = 0; i < n; ++i) {
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            super.insertString(offset, new String(result, 0, j), a);
        }
    }
}

