/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import java.util.Arrays;

@Immutable
public final class DES {
    private static final char[] DEFAULT_KEY = new char[]{'2', '\u00b9', '\u008f', '#', '<', '\u00a1', '\u00ae', '1', '\u0001', '7', '\u00d2', 'f', '\u00f1', ':', '\f', '\u00d0', 'O', '\u00aa', '?', 'Q', 'G', '\t', 'L', '\u00ea'};
    private static final char[] MODULE_NAME_2 = new char[]{'r', 's', 'e', 'c', 's', 't', 'o', 'r', '\u00f8', 'q', 'u', '%', '\u00b6', '\u00ee', '\u001a', '\u0084', '\u00f0', '4', '=', '\u00e7', '\u0019', '\u00d1', '>', '['};
    private static final int KEY_LENGTH = 24;
    private static final int[] NIBBLEBIT = new int[]{8, 4, 2, 1};
    private static final int[] BYTEBIT = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private static final char[] TOTROT = new char[]{'\u0001', '\u0002', '\u0004', '\u0006', '\b', '\n', '\f', '\u000e', '\u000f', '\u0011', '\u0013', '\u0015', '\u0017', '\u0019', '\u001b', '\u001c'};
    private static final char[] SCHLEIER_KEY = new char[]{'!', '\u00f1', '\u00b5', '\u0093', '\u00da', '\u00c4', 'H', '\u00f7'};
    private static final char[] MODULE_NAME = new char[]{'r', 's', 'e', 'c', 's', 't', 'o', 'c'};
    private static final char[][][] IPERM = new char[16][16][8];
    private static final char[][][] FPERM = new char[16][16][8];
    private static final char[] IP = new char[]{':', '2', '*', '\"', '\u001a', '\u0012', '\n', '\u0002', '<', '4', ',', '$', '\u001c', '\u0014', '\f', '\u0004', '>', '6', '.', '&', '\u001e', '\u0016', '\u000e', '\u0006', '@', '8', '0', '(', ' ', '\u0018', '\u0010', '\b', '9', '1', ')', '!', '\u0019', '\u0011', '\t', '\u0001', ';', '3', '+', '#', '\u001b', '\u0013', '\u000b', '\u0003', '=', '5', '-', '%', '\u001d', '\u0015', '\r', '\u0005', '?', '7', '/', '\'', '\u001f', '\u0017', '\u000f', '\u0007'};
    private static final char[] FP = new char[]{'(', '\b', '0', '\u0010', '8', '\u0018', '@', ' ', '\'', '\u0007', '/', '\u000f', '7', '\u0017', '?', '\u001f', '&', '\u0006', '.', '\u000e', '6', '\u0016', '>', '\u001e', '%', '\u0005', '-', '\r', '5', '\u0015', '=', '\u001d', '$', '\u0004', ',', '\f', '4', '\u0014', '<', '\u001c', '#', '\u0003', '+', '\u000b', '3', '\u0013', ';', '\u001b', '\"', '\u0002', '*', '\n', '2', '\u0012', ':', '\u001a', '!', '\u0001', ')', '\t', '1', '\u0011', '9', '\u0019'};
    private static final char[] P_32_I = new char[]{'\u0010', '\u0007', '\u0014', '\u0015', '\u001d', '\f', '\u001c', '\u0011', '\u0001', '\u000f', '\u0017', '\u001a', '\u0005', '\u0012', '\u001f', '\n', '\u0002', '\b', '\u0018', '\u000e', ' ', '\u001b', '\u0003', '\t', '\u0013', '\r', '\u001e', '\u0006', '\u0016', '\u000b', '\u0004', '\u0019'};
    private static final char[] PC_1 = new char[]{'9', '1', ')', '!', '\u0019', '\u0011', '\t', '\u0001', ':', '2', '*', '\"', '\u001a', '\u0012', '\n', '\u0002', ';', '3', '+', '#', '\u001b', '\u0013', '\u000b', '\u0003', '<', '4', ',', '$', '?', '7', '/', '\'', '\u001f', '\u0017', '\u000f', '\u0007', '>', '6', '.', '&', '\u001e', '\u0016', '\u000e', '\u0006', '=', '5', '-', '%', '\u001d', '\u0015', '\r', '\u0005', '\u001c', '\u0014', '\f', '\u0004'};
    private static final char[] PC_2 = new char[]{'\u000e', '\u0011', '\u000b', '\u0018', '\u0001', '\u0005', '\u0003', '\u001c', '\u000f', '\u0006', '\u0015', '\n', '\u0017', '\u0013', '\f', '\u0004', '\u001a', '\b', '\u0010', '\u0007', '\u001b', '\u0014', '\r', '\u0002', ')', '4', '\u001f', '%', '/', '7', '\u001e', '(', '3', '-', '!', '0', ',', '1', '\'', '8', '\"', '5', '.', '*', '2', '$', '\u001d', ' '};
    private static final int[][] SP = new int[8][64];
    private static final char[][] S_BOX = new char[][]{{'\u000e', '\u0004', '\r', '\u0001', '\u0002', '\u000f', '\u000b', '\b', '\u0003', '\n', '\u0006', '\f', '\u0005', '\t', '\u0000', '\u0007', '\u0000', '\u000f', '\u0007', '\u0004', '\u000e', '\u0002', '\r', '\u0001', '\n', '\u0006', '\f', '\u000b', '\t', '\u0005', '\u0003', '\b', '\u0004', '\u0001', '\u000e', '\b', '\r', '\u0006', '\u0002', '\u000b', '\u000f', '\f', '\t', '\u0007', '\u0003', '\n', '\u0005', '\u0000', '\u000f', '\f', '\b', '\u0002', '\u0004', '\t', '\u0001', '\u0007', '\u0005', '\u000b', '\u0003', '\u000e', '\n', '\u0000', '\u0006', '\r'}, {'\u000f', '\u0001', '\b', '\u000e', '\u0006', '\u000b', '\u0003', '\u0004', '\t', '\u0007', '\u0002', '\r', '\f', '\u0000', '\u0005', '\n', '\u0003', '\r', '\u0004', '\u0007', '\u000f', '\u0002', '\b', '\u000e', '\f', '\u0000', '\u0001', '\n', '\u0006', '\t', '\u000b', '\u0005', '\u0000', '\u000e', '\u0007', '\u000b', '\n', '\u0004', '\r', '\u0001', '\u0005', '\b', '\f', '\u0006', '\t', '\u0003', '\u0002', '\u000f', '\r', '\b', '\n', '\u0001', '\u0003', '\u000f', '\u0004', '\u0002', '\u000b', '\u0006', '\u0007', '\f', '\u0000', '\u0005', '\u000e', '\t'}, {'\n', '\u0000', '\t', '\u000e', '\u0006', '\u0003', '\u000f', '\u0005', '\u0001', '\r', '\f', '\u0007', '\u000b', '\u0004', '\u0002', '\b', '\r', '\u0007', '\u0000', '\t', '\u0003', '\u0004', '\u0006', '\n', '\u0002', '\b', '\u0005', '\u000e', '\f', '\u000b', '\u000f', '\u0001', '\r', '\u0006', '\u0004', '\t', '\b', '\u000f', '\u0003', '\u0000', '\u000b', '\u0001', '\u0002', '\f', '\u0005', '\n', '\u000e', '\u0007', '\u0001', '\n', '\r', '\u0000', '\u0006', '\t', '\b', '\u0007', '\u0004', '\u000f', '\u000e', '\u0003', '\u000b', '\u0005', '\u0002', '\f'}, {'\u0007', '\r', '\u000e', '\u0003', '\u0000', '\u0006', '\t', '\n', '\u0001', '\u0002', '\b', '\u0005', '\u000b', '\f', '\u0004', '\u000f', '\r', '\b', '\u000b', '\u0005', '\u0006', '\u000f', '\u0000', '\u0003', '\u0004', '\u0007', '\u0002', '\f', '\u0001', '\n', '\u000e', '\t', '\n', '\u0006', '\t', '\u0000', '\f', '\u000b', '\u0007', '\r', '\u000f', '\u0001', '\u0003', '\u000e', '\u0005', '\u0002', '\b', '\u0004', '\u0003', '\u000f', '\u0000', '\u0006', '\n', '\u0001', '\r', '\b', '\t', '\u0004', '\u0005', '\u000b', '\f', '\u0007', '\u0002', '\u000e'}, {'\u0002', '\f', '\u0004', '\u0001', '\u0007', '\n', '\u000b', '\u0006', '\b', '\u0005', '\u0003', '\u000f', '\r', '\u0000', '\u000e', '\t', '\u000e', '\u000b', '\u0002', '\f', '\u0004', '\u0007', '\r', '\u0001', '\u0005', '\u0000', '\u000f', '\n', '\u0003', '\t', '\b', '\u0006', '\u0004', '\u0002', '\u0001', '\u000b', '\n', '\r', '\u0007', '\b', '\u000f', '\t', '\f', '\u0005', '\u0006', '\u0003', '\u0000', '\u000e', '\u000b', '\b', '\f', '\u0007', '\u0001', '\u000e', '\u0002', '\r', '\u0006', '\u000f', '\u0000', '\t', '\n', '\u0004', '\u0005', '\u0003'}, {'\f', '\u0001', '\n', '\u000f', '\t', '\u0002', '\u0006', '\b', '\u0000', '\r', '\u0003', '\u0004', '\u000e', '\u0007', '\u0005', '\u000b', '\n', '\u000f', '\u0004', '\u0002', '\u0007', '\f', '\t', '\u0005', '\u0006', '\u0001', '\r', '\u000e', '\u0000', '\u000b', '\u0003', '\b', '\t', '\u000e', '\u000f', '\u0005', '\u0002', '\b', '\f', '\u0003', '\u0007', '\u0000', '\u0004', '\n', '\u0001', '\r', '\u000b', '\u0006', '\u0004', '\u0003', '\u0002', '\f', '\t', '\u0005', '\u000f', '\n', '\u000b', '\u000e', '\u0001', '\u0007', '\u0006', '\u0000', '\b', '\r'}, {'\u0004', '\u000b', '\u0002', '\u000e', '\u000f', '\u0000', '\b', '\r', '\u0003', '\f', '\t', '\u0007', '\u0005', '\n', '\u0006', '\u0001', '\r', '\u0000', '\u000b', '\u0007', '\u0004', '\t', '\u0001', '\n', '\u000e', '\u0003', '\u0005', '\f', '\u0002', '\u000f', '\b', '\u0006', '\u0001', '\u0004', '\u000b', '\r', '\f', '\u0003', '\u0007', '\u000e', '\n', '\u000f', '\u0006', '\b', '\u0000', '\u0005', '\t', '\u0002', '\u0006', '\u000b', '\r', '\b', '\u0001', '\u0004', '\n', '\u0007', '\t', '\u0005', '\u0000', '\u000f', '\u000e', '\u0002', '\u0003', '\f'}, {'\r', '\u0002', '\b', '\u0004', '\u0006', '\u000f', '\u000b', '\u0001', '\n', '\t', '\u0003', '\u000e', '\u0005', '\u0000', '\f', '\u0007', '\u0001', '\u000f', '\r', '\b', '\n', '\u0003', '\u0007', '\u0004', '\f', '\u0005', '\u0006', '\u000b', '\u0000', '\u000e', '\t', '\u0002', '\u0007', '\u000b', '\u0004', '\u0001', '\t', '\f', '\u000e', '\u0002', '\u0000', '\u0006', '\n', '\r', '\u000f', '\u0003', '\u0005', '\b', '\u0002', '\u0001', '\u000e', '\u0007', '\u0004', '\n', '\b', '\r', '\u000f', '\f', '\t', '\u0000', '\u0003', '\u0005', '\u0006', '\u000b'}};
    private static boolean sp_already_initialized = false;
    private static boolean perm_already_initialized = false;

    private DES() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static void RSecPDecrypt(char[] key, char[] buffer, int buflen) {
        char[] key1 = new char[8];
        char[] key2 = new char[8];
        char[] key3 = new char[8];
        char[] key4 = new char[24];
        if (DES.isNullKey(key)) {
            System.arraycopy(DEFAULT_KEY, 0, key4, 0, 24);
            DES.rsectd__t_decryptoC(MODULE_NAME_2, key4, 24);
            key = key4;
        }
        Arrays.fill(key1, '\u0000');
        Arrays.fill(key2, '\u0000');
        Arrays.fill(key3, '\u0000');
        System.arraycopy(key, 0, key1, 0, Math.min(key1.length, 24));
        System.arraycopy(key, 8, key2, 0, Math.min(key2.length, 16));
        System.arraycopy(key, 16, key3, 0, Math.min(key3.length, 8));
        DES._assert(buffer != null);
        DES._assert(buflen >= 8);
        DES.rsecdbv1__decode_block_v1(key3, 8, buffer, buflen);
        DES.rsecebv1__encode_block_v1(key2, 8, buffer, buflen);
        DES.rsecdbv1__decode_block_v1(key1, 8, buffer, buflen);
    }

    public static int rsecedv1_encode_default_v1(char[] buffer, int buflen) {
        char[] key = new char[8];
        if (buflen < 8) {
            return 1;
        }
        System.arraycopy(SCHLEIER_KEY, 0, key, 0, 8);
        DES.rsecdbv1__decode_block_v1(MODULE_NAME, 8, key, 8);
        DES.rsecebv1__encode_block_v1(key, 8, buffer, buflen);
        Arrays.fill(key, '\u0000');
        return 0;
    }

    private static void _assert(boolean test) {
        if (!test) {
            throw new AssertionError((Object)"Unexpected encryption/decryption error");
        }
    }

    private static boolean isNullKey(char[] key) {
        for (int i = 0; i < 24; ++i) {
            if (key[i] == '\u0000') continue;
            return false;
        }
        return true;
    }

    private static void rsecdbv1__decode_block_v1(char[] key, int keylen, char[] buffer, int buflen) {
        char[][] kshed = new char[16][8];
        char[] keycopy = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
        char[] chain = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
        int eptrPos = 0;
        DES._assert(buffer != null);
        DES._assert(buflen >= 8);
        DES.encode_init(0);
        System.arraycopy(key, 0, keycopy, 0, Math.min(keycopy.length, keylen));
        DES.rsec_setkey(kshed, keycopy);
        char[] eptr = buffer;
        int remaining = buflen;
        while (remaining >= 8) {
            DES.do_decode_v1(kshed, eptr, chain, eptrPos);
            remaining -= 8;
            eptrPos += 8;
        }
        if (remaining > 0) {
            throw new AssertionError((Object)"Invalid block passed for decryption");
        }
    }

    private static void rsecebv1__encode_block_v1(char[] key, int keylen, char[] buffer, int buflen) {
        char[][] kshed = new char[16][8];
        char[] keycopy = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
        char[] chain = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
        int eptrPos = 0;
        DES._assert(buffer != null);
        DES._assert(buflen >= 8);
        DES.encode_init(0);
        System.arraycopy(key, 0, keycopy, 0, Math.min(keycopy.length, keylen));
        DES.rsec_setkey(kshed, keycopy);
        char[] eptr = buffer;
        int remaining = buflen;
        while (remaining >= 8) {
            DES.do_encode_v1(kshed, eptr, chain, eptrPos);
            remaining -= 8;
            eptrPos += 8;
        }
        if (remaining > 0) {
            throw new AssertionError((Object)"Invalid block passed for decryption");
        }
    }

    private static void rsectd__t_decryptoC(char[] key, char[] buffer, int buflen) {
        char[][] kshed1 = new char[16][8];
        char[][] kshed2 = new char[16][8];
        char[] eptr = new char[buflen];
        int eptrPos = 0;
        char[] key1 = new char[8];
        char[] key2 = new char[8];
        char[] chainsave = new char[8];
        char[] chainsave2 = new char[8];
        Arrays.fill(key1, '\u0000');
        Arrays.fill(key2, '\u0000');
        System.arraycopy(key, 0, key1, 0, Math.min(key1.length, 24));
        System.arraycopy(key, 8, key2, 0, Math.min(key2.length, 16));
        DES._assert(buffer != null);
        DES._assert(buflen >= 8);
        DES.encode_init(0);
        DES.rsec_setkey(kshed1, key1);
        DES.rsec_setkey(kshed2, key2);
        System.arraycopy(buffer, 0, eptr, 0, eptr.length);
        int remaining = buflen;
        System.arraycopy(eptr, 0, chainsave2, 0, 8);
        while (remaining >= 8) {
            System.arraycopy(eptr, eptrPos, chainsave, 0, 8);
            DES.do_decode_v1(kshed1, eptr, null, eptrPos);
            DES.do_encode_v1(kshed2, eptr, null, eptrPos);
            DES.do_decode_v1(kshed1, eptr, null, eptrPos);
            if (remaining != buflen) {
                DES.excl_or(eptr, chainsave2, 8, eptrPos);
                System.arraycopy(chainsave, 0, chainsave2, 0, 8);
            }
            remaining -= 8;
            eptrPos += 8;
        }
        if (remaining > 0) {
            throw new AssertionError((Object)"Invalid block passed for decryption");
        }
    }

    private static void encode_init(int mode) {
        if (!sp_already_initialized) {
            DES.spinit();
            sp_already_initialized = true;
        }
        if (mode == 1) {
            return;
        }
        if (!perm_already_initialized) {
            DES.perminit(IPERM, IP);
            DES.perminit(FPERM, FP);
            perm_already_initialized = true;
        }
    }

    private static void excl_or(char[] srcdest, char[] pattern, int len, int srcdestPos) {
        for (int cnt = 0; cnt < len; ++cnt) {
            int n = srcdestPos++;
            srcdest[n] = (char)(srcdest[n] ^ pattern[cnt]);
        }
    }

    private static void perminit(char[][][] perm, char[] p) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 64; ++k) {
                    int l = p[k] - '\u0001';
                    if (l >> 2 != i || (j & NIBBLEBIT[l & 3]) == 0) continue;
                    int m = k & 7;
                    char[] cArray = perm[i][j];
                    int n = k >> 3;
                    cArray[n] = (char)(cArray[n] | BYTEBIT[m]);
                }
            }
        }
    }

    private static void spinit() {
        int i;
        char[] pbox = new char[32];
        block0: for (int p = 0; p < 32; ++p) {
            for (i = 0; i < 32; ++i) {
                if (P_32_I[i] - '\u0001' != p) continue;
                pbox[p] = (char)i;
                continue block0;
            }
        }
        for (int s = 0; s < 8; ++s) {
            for (i = 0; i < 64; ++i) {
                int val = 0;
                int rowcol = i & 0x20 | ((i & 1) != 0 ? 16 : 0) | i >> 1 & 0xF;
                for (int j = 0; j < 4; ++j) {
                    if ((S_BOX[s][rowcol] & 8 >> j) == 0) continue;
                    val |= 1 << 31 - pbox[4 * s + j];
                }
                DES.SP[s][i] = val;
            }
        }
    }

    private static void rsec_setkey(char[][] kn, char[] key) {
        int j;
        int i;
        char[] pc1m = new char[56];
        char[] pcr = new char[56];
        DES._assert(kn != null);
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 8; ++j) {
                kn[i][j] = '\u0000';
            }
        }
        for (j = 0; j < 56; ++j) {
            int overall_bit_index = PC_1[j] - '\u0001';
            int byte_index = overall_bit_index >> 3;
            int bit_within_byte = overall_bit_index & 7;
            char proj_bit = (char)(key[byte_index] & BYTEBIT[bit_within_byte]);
            pc1m[j] = (char)(proj_bit != '\u0000' ? 1 : 0);
        }
        for (i = 0; i < 16; ++i) {
            int l;
            for (j = 0; j < 56; ++j) {
                l = j + TOTROT[i];
                pcr[j] = pc1m[l < (j < 28 ? 28 : 56) ? l : l - 28];
            }
            for (j = 0; j < 48; ++j) {
                if (pcr[PC_2[j] - '\u0001'] == '\u0000') continue;
                l = j % 6;
                char[] cArray = kn[i];
                int n = j / 6;
                cArray[n] = (char)(cArray[n] | BYTEBIT[l] >> 2);
            }
        }
    }

    private static void do_encode_v1(char[][] kn, char[] block, char[] chain, int blockPos) {
        char[] work = new char[8];
        if (chain != null) {
            DES.excl_or(block, chain, 8, blockPos);
        }
        DES.permute(block, blockPos, IPERM, work, 0);
        int left = (work[0] & 0xFF) << 24 | (work[1] & 0xFF) << 16 | (work[2] & 0xFF) << 8 | work[3] & 0xFF;
        int right = (work[4] & 0xFF) << 24 | (work[5] & 0xFF) << 16 | (work[6] & 0xFF) << 8 | work[7] & 0xFF;
        int f_result = DES.f(right, kn[0]);
        left ^= f_result;
        f_result = DES.f(left, kn[1]);
        right ^= f_result;
        f_result = DES.f(right, kn[2]);
        left ^= f_result;
        f_result = DES.f(left, kn[3]);
        right ^= f_result;
        f_result = DES.f(right, kn[4]);
        left ^= f_result;
        f_result = DES.f(left, kn[5]);
        right ^= f_result;
        f_result = DES.f(right, kn[6]);
        left ^= f_result;
        f_result = DES.f(left, kn[7]);
        right ^= f_result;
        f_result = DES.f(right, kn[8]);
        left ^= f_result;
        f_result = DES.f(left, kn[9]);
        right ^= f_result;
        f_result = DES.f(right, kn[10]);
        left ^= f_result;
        f_result = DES.f(left, kn[11]);
        right ^= f_result;
        f_result = DES.f(right, kn[12]);
        left ^= f_result;
        f_result = DES.f(left, kn[13]);
        right ^= f_result;
        f_result = DES.f(right, kn[14]);
        left ^= f_result;
        f_result = DES.f(left, kn[15]);
        work[0] = (char)((right ^= f_result) >> 24 & 0xFF);
        work[1] = (char)(right >> 16 & 0xFF);
        work[2] = (char)(right >> 8 & 0xFF);
        work[3] = (char)(right & 0xFF);
        work[4] = (char)(left >> 24 & 0xFF);
        work[5] = (char)(left >> 16 & 0xFF);
        work[6] = (char)(left >> 8 & 0xFF);
        work[7] = (char)(left & 0xFF);
        DES.permute(work, 0, FPERM, block, blockPos);
        if (chain != null) {
            System.arraycopy(block, blockPos, chain, 0, 8);
        }
    }

    private static void permute(char[] inblock, int inBlockPos, char[][][] perm, char[] outblock, int outBlockPos) {
        Arrays.fill(outblock, outBlockPos, outBlockPos + 8, '\u0000');
        int index = 0;
        while (index < 16) {
            char[] p = perm[index][inblock[inBlockPos] >> 4 & 0xF];
            char[] q = perm[index + 1][inblock[inBlockPos] & 0xF];
            int n = outBlockPos;
            outblock[n] = (char)(outblock[n] | (p[0] | q[0]));
            int n2 = outBlockPos + 1;
            outblock[n2] = (char)(outblock[n2] | (p[1] | q[1]));
            int n3 = outBlockPos + 2;
            outblock[n3] = (char)(outblock[n3] | (p[2] | q[2]));
            int n4 = outBlockPos + 3;
            outblock[n4] = (char)(outblock[n4] | (p[3] | q[3]));
            int n5 = outBlockPos + 4;
            outblock[n5] = (char)(outblock[n5] | (p[4] | q[4]));
            int n6 = outBlockPos + 5;
            outblock[n6] = (char)(outblock[n6] | (p[5] | q[5]));
            int n7 = outBlockPos + 6;
            outblock[n7] = (char)(outblock[n7] | (p[6] | q[6]));
            int n8 = outBlockPos + 7;
            outblock[n8] = (char)(outblock[n8] | (p[7] | q[7]));
            index += 2;
            ++inBlockPos;
        }
    }

    private static int f(int r, char[] subkey) {
        int sp_value;
        long r_unsigned = (long)r & 0xFFFFFFFFL;
        long rt = r_unsigned << 1 & 0xFFFFFFFFL;
        if (r_unsigned >> 31 != 0L) {
            rt |= 1L;
        }
        int index = (int)((rt ^ (long)subkey[7]) & 0x3FL);
        int rval = sp_value = SP[7][index];
        rt = r_unsigned >> 3;
        index = (int)((rt ^ (long)subkey[6]) & 0x3FL);
        sp_value = SP[6][index];
        rval |= sp_value;
        index = (int)(((rt >>= 4) ^ (long)subkey[5]) & 0x3FL);
        sp_value = SP[5][index];
        rval |= sp_value;
        index = (int)(((rt >>= 4) ^ (long)subkey[4]) & 0x3FL);
        sp_value = SP[4][index];
        rval |= sp_value;
        index = (int)(((rt >>= 4) ^ (long)subkey[3]) & 0x3FL);
        sp_value = SP[3][index];
        rval |= sp_value;
        index = (int)(((rt >>= 4) ^ (long)subkey[2]) & 0x3FL);
        sp_value = SP[2][index];
        rval |= sp_value;
        index = (int)(((rt >>= 4) ^ (long)subkey[1]) & 0x3FL);
        sp_value = SP[1][index];
        rval |= sp_value;
        rt >>= 4;
        index = (int)(((rt |= (r_unsigned & 1L) << 5) ^ (long)subkey[0]) & 0x3FL);
        sp_value = SP[0][index];
        return rval |= sp_value;
    }

    private static void do_decode_v1(char[][] kn, char[] block, char[] chain, int blockPos) {
        char[] work = new char[8];
        char[] chainsave = new char[8];
        System.arraycopy(block, blockPos, chainsave, 0, 8);
        DES.permute(block, blockPos, IPERM, work, 0);
        int right = (work[0] & 0xFF) << 24 | (work[1] & 0xFF) << 16 | (work[2] & 0xFF) << 8 | work[3] & 0xFF;
        int left = (work[4] & 0xFF) << 24 | (work[5] & 0xFF) << 16 | (work[6] & 0xFF) << 8 | work[7] & 0xFF;
        int f_result = DES.f(left, kn[15]);
        right ^= f_result;
        f_result = DES.f(right, kn[14]);
        left ^= f_result;
        f_result = DES.f(left, kn[13]);
        right ^= f_result;
        f_result = DES.f(right, kn[12]);
        left ^= f_result;
        f_result = DES.f(left, kn[11]);
        right ^= f_result;
        f_result = DES.f(right, kn[10]);
        left ^= f_result;
        f_result = DES.f(left, kn[9]);
        right ^= f_result;
        f_result = DES.f(right, kn[8]);
        left ^= f_result;
        f_result = DES.f(left, kn[7]);
        right ^= f_result;
        f_result = DES.f(right, kn[6]);
        left ^= f_result;
        f_result = DES.f(left, kn[5]);
        right ^= f_result;
        f_result = DES.f(right, kn[4]);
        left ^= f_result;
        f_result = DES.f(left, kn[3]);
        right ^= f_result;
        f_result = DES.f(right, kn[2]);
        left ^= f_result;
        f_result = DES.f(left, kn[1]);
        right ^= f_result;
        f_result = DES.f(right, kn[0]);
        work[0] = (char)((left ^= f_result) >> 24 & 0xFF);
        work[1] = (char)(left >> 16 & 0xFF);
        work[2] = (char)(left >> 8 & 0xFF);
        work[3] = (char)(left & 0xFF);
        work[4] = (char)(right >> 24 & 0xFF);
        work[5] = (char)(right >> 16 & 0xFF);
        work[6] = (char)(right >> 8 & 0xFF);
        work[7] = (char)(right & 0xFF);
        DES.permute(work, 0, FPERM, block, blockPos);
        if (chain != null) {
            DES.excl_or(block, chain, 8, blockPos);
            System.arraycopy(chainsave, 0, chain, 0, 8);
        }
    }
}

