/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.CompileScope;
import com.sap.cloud.sdk.datamodel.odata.generator.DataModelGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odata.utility.NameSource;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=false)
public class DataModelGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="odatav2.generate.inputDirectory", defaultValue="input")
    private String inputDirectory;
    @Parameter(property="odatav2.generate.outputDirectory", defaultValue="target")
    private String outputDirectory;
    @Parameter(property="odatav2.generate.deleteOutputDirectory")
    private Boolean deleteOutputDirectory;
    @Parameter(property="odatav2.generate.overwriteFiles")
    private Boolean overwriteFiles;
    @Parameter(property="odatav2.generate.keepExistingSignatures")
    private Boolean keepExistingSignatures;
    @Parameter(property="odatav2.generate.compileScope")
    private CompileScope compileScope;
    @Parameter(property="odatav2.generate.packageName", defaultValue="com.sap.cloud.sdk.s4hana.datamodel.odata")
    private String packageName;
    @Parameter(property="odatav2.generate.serviceNameMappingFile", defaultValue="serviceNameMappings.properties")
    private String serviceNameMappingFile;
    @Parameter(property="odatav2.generate.defaultBasePath")
    private String defaultBasePath;
    @Parameter(property="odatav2.generate.namingStrategy", defaultValue="com.sap.cloud.sdk.datamodel.odata.utility.S4HanaNamingStrategy")
    private String namingStrategy;
    @Parameter(property="odatav2.generate.nameSource")
    private NameSource nameSource;
    @Parameter(property="odatav2.generate.annotationStrategy", defaultValue="com.sap.cloud.sdk.datamodel.odata.generator.annotation.DefaultAnnotationStrategy")
    private String annotationStrategy;
    @Parameter(property="odatav2.generate.pojosOnly")
    private Boolean pojosOnly;
    @Parameter(property="odatav2.generate.failOnWarning")
    private Boolean failOnWarning;
    @Parameter(property="odatav2.generate.excludes")
    private String excludes;
    @Parameter(property="odatav2.generate.linkToApiBusinessHub")
    private Boolean linkToApiBusinessHub;
    @Parameter(property="odatav2.generate.versionReference")
    private Boolean versionReference;
    @Parameter(property="odatav2.generate.copyrightHeader")
    private String copyrightHeader;
    @Parameter(property="odatav2.generate.sapCopyrightHeader")
    private Boolean sapCopyrightHeader;
    @Parameter(property="odatav2.generate.includeEntitySets")
    private Set<String> includeEntitySets;
    @Parameter(property="odatav2.generate.includeFunctionImports")
    private Set<String> includeFunctionImports;
    @Parameter(property="odatav2.generate.serviceMethodsPerEntitySet")
    private Boolean serviceMethodsPerEntitySet;

    private void initializeParameters() {
        if (this.deleteOutputDirectory == null) {
            this.deleteOutputDirectory = DataModelGenerator.DEFAULT_DELETE_OUTPUT_DIRECTORY;
        }
        if (this.overwriteFiles == null) {
            this.overwriteFiles = DataModelGenerator.DEFAULT_OVERWRITE_FILES;
        }
        if (this.keepExistingSignatures == null) {
            this.keepExistingSignatures = true;
        }
        if (this.compileScope == null) {
            this.compileScope = CompileScope.NONE;
        }
        if (this.nameSource == null) {
            this.nameSource = DataModelGenerator.DEFAULT_NAMING_SOURCE;
        }
        if (this.pojosOnly == null) {
            this.pojosOnly = DataModelGenerator.DEFAULT_POJOS_ONLY;
        }
        if (this.linkToApiBusinessHub == null) {
            this.linkToApiBusinessHub = DataModelGenerator.DEFAULT_LINK_TO_API_BUSINESS_HUB;
        }
        if (this.failOnWarning == null) {
            this.failOnWarning = DataModelGenerator.DEFAULT_FAIL_ON_WARNING;
        }
        if (this.versionReference == null) {
            this.versionReference = DataModelGenerator.DEFAULT_VERSION_REFERENCE;
        }
        if (this.sapCopyrightHeader == null) {
            this.sapCopyrightHeader = false;
        }
        if (this.copyrightHeader == null) {
            this.copyrightHeader = "";
        }
        if (this.excludes == null) {
            this.excludes = "";
        }
        if (this.serviceMethodsPerEntitySet == null) {
            this.serviceMethodsPerEntitySet = false;
        }
    }

    DataModelGenerator getDataModelGenerator() {
        DataModelGenerator dataModelGenerator = new DataModelGenerator();
        this.initializeParameters();
        if (this.sapCopyrightHeader.booleanValue()) {
            dataModelGenerator.sapCopyrightHeader();
        } else {
            dataModelGenerator.copyrightHeader(this.copyrightHeader);
        }
        return dataModelGenerator.withInputDirectory(this.inputDirectory).withOutputDirectory(this.outputDirectory).deleteOutputDirectory(this.deleteOutputDirectory.booleanValue()).overwriteFiles(this.overwriteFiles.booleanValue()).keepExistingSignatures(this.keepExistingSignatures.booleanValue()).withPackageName(this.packageName).withServiceNameMapping(this.serviceNameMappingFile).withDefaultBasePath(this.defaultBasePath).withNamingStrategy(this.namingStrategy).withNameSource(this.nameSource).withAnnotationStrategy(this.annotationStrategy).pojosOnly(this.pojosOnly.booleanValue()).withExcludeFilePattern(this.excludes).linkToApiBusinessHub(this.linkToApiBusinessHub.booleanValue()).versionReference(this.versionReference.booleanValue()).withIncludedEntitySets(this.includeEntitySets).withIncludedFunctionImports(this.includeFunctionImports).failOnWarning(this.failOnWarning.booleanValue()).serviceMethodsPerEntitySet(this.serviceMethodsPerEntitySet.booleanValue());
    }

    public void execute() throws MojoExecutionException {
        try {
            DataModelGenerator generator = this.getDataModelGenerator();
            generator.execute();
            if (generator.failureDueToWarningsNecessary()) {
                throw new MojoExecutionException("Failed to generate data model because warning occurred. See the log above.");
            }
            this.compileScope.addSourceRoot(this.project, this.outputDirectory);
            this.getLog().info((CharSequence)("Added generated sources according to compile scope '" + String.valueOf((Object)this.compileScope) + "'."));
        }
        catch (ODataGeneratorException e) {
            throw new MojoExecutionException("Failed to generate data model.", (Exception)((Object)e));
        }
    }
}

