/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingUtils;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ApiFunction;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EdmUtils;
import com.sap.cloud.sdk.datamodel.odatav4.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Multiplicity;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorReadException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Service;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ServiceDetails;
import com.sap.cloud.sdk.datamodel.odatav4.generator.TypeKind;
import io.vavr.control.Option;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmAnnotatable;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTyped;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmEnumTypeImpl;
import org.apache.olingo.commons.core.edm.primitivetype.AbstractGeospatialType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;
import org.slf4j.Logger;

class EdmService
implements Service {
    private static final Logger logger = MessageCollector.getLogger(EdmService.class);
    private static final String[] TERMS_LABEL = new String[]{"Common.Label", "SAP__common.Label"};
    private static final String[] TERMS_QUICK_INFO = new String[]{"Common.QuickInfo", "SAP__common.QuickInfo"};
    private static final String[] TERMS_DESCRIPTION = new String[]{"Core.Description", "SAP__core.Description"};
    private static final String[] TERMS_LONG_DESCRIPTION = new String[]{"Core.LongDescription", "SAP__core.LongDescription"};
    private final String name;
    private final PropertiesConfiguration serviceNameMappings;
    private final Edm metadata;
    private final ServiceDetails details;
    private final Function<String, Collection<ApiFunction>> allowedFunctionsByEntity;
    private final boolean hasLinkToApiBusinessHub;
    private boolean generateExplicitDeprecationNotices = false;
    private final Map<String, Service.EntitySet> entitySets = new LinkedHashMap<String, Service.EntitySet>();
    private final Multimap<String, Service.ServiceFunction> serviceFunctions = MultimapBuilder.linkedHashKeys().linkedListValues().build();
    private final Multimap<String, Service.ServiceBoundFunction> serviceBoundFunctions = MultimapBuilder.linkedHashKeys().linkedListValues().build();
    private final Multimap<String, Service.ServiceAction> serviceActions = MultimapBuilder.linkedHashKeys().linkedListValues().build();
    private final Multimap<String, Service.ServiceBoundAction> serviceBoundActions = MultimapBuilder.linkedHashKeys().linkedListValues().build();

    EdmService(String name, PropertiesConfiguration serviceNameMappings, Edm metadata, ServiceDetails details, Multimap<String, ApiFunction> allowedFunctionsByEntity, boolean hasLinkToApiBusinessHub) {
        this.name = name;
        this.serviceNameMappings = serviceNameMappings;
        this.metadata = metadata;
        this.details = details;
        this.allowedFunctionsByEntity = arg_0 -> allowedFunctionsByEntity.get(arg_0);
        this.hasLinkToApiBusinessHub = hasLinkToApiBusinessHub;
        try {
            this.workaroundOlingoLazyEntityTypeInstantiation(metadata);
            for (EdmEntitySet entitySet : metadata.getEntityContainer().getEntitySetsWithAnnotations()) {
                this.entitySets.put(entitySet.getName(), new EntitySetAdapter(entitySet));
            }
            for (EdmFunctionImport edmFunctionImport : metadata.getEntityContainer().getFunctionImports()) {
                for (EdmFunction edmUnboundFunction : edmFunctionImport.getUnboundFunctions()) {
                    this.serviceFunctions.put((Object)edmFunctionImport.getName(), (Object)new ServiceFunctionAdapter(edmFunctionImport, edmUnboundFunction));
                }
            }
            for (EdmActionImport edmActionImport : metadata.getEntityContainer().getActionImports()) {
                this.serviceActions.put((Object)edmActionImport.getName(), (Object)new ServiceActionAdapter(edmActionImport, edmActionImport.getUnboundAction()));
            }
            for (EdmFunction edmBoundFunction : ((EdmSchema)metadata.getSchemas().get(0)).getFunctions()) {
                if (!edmBoundFunction.isBound()) continue;
                logger.info("Found bound function with name:" + edmBoundFunction.getName());
                this.serviceBoundFunctions.put((Object)edmBoundFunction.getName(), (Object)new BoundFunctionAdapter(edmBoundFunction));
            }
            for (EdmAction edmBoundAction : ((EdmSchema)metadata.getSchemas().get(0)).getActions()) {
                if (!edmBoundAction.isBound()) continue;
                logger.info("Found bound action with name: {}", (Object)edmBoundAction.getName());
                this.serviceBoundActions.put((Object)edmBoundAction.getName(), (Object)new BoundActionAdapter(edmBoundAction));
            }
        }
        catch (EdmException e) {
            throw new ODataGeneratorReadException(e);
        }
    }

    private void workaroundOlingoLazyEntityTypeInstantiation(@Nonnull Edm metadata) {
        for (EdmEntitySet entitySet : metadata.getEntityContainer().getEntitySets()) {
            metadata.getEntityType(entitySet.getEntityType().getFullQualifiedName());
        }
    }

    @Override
    public String getTitle() {
        ServiceDetails.Info swaggerInfo = this.details.getInfo();
        if (swaggerInfo != null && !Strings.isNullOrEmpty((String)swaggerInfo.getTitle())) {
            return swaggerInfo.getTitle();
        }
        return NamingUtils.apiNameToServiceTitle((String)this.name);
    }

    @Override
    public boolean isDeprecated() {
        return this.generateExplicitDeprecationNotices || this.details.isDeprecated();
    }

    @Override
    public Option<Service.DeprecationInfo> getDeprecationInfo() {
        if (this.isDeprecated()) {
            return this.details.getStateInfo().map(DefaultDeprecationInfo::new);
        }
        return Option.none();
    }

    @Override
    public String getServiceUrl() {
        return this.details.getServiceUrl();
    }

    @Override
    public Service.EntitySet getEntitySet(String entitySetName) {
        return this.entitySets.get(entitySetName);
    }

    @Override
    public Collection<Service.EntitySet> getAllEntitySets() {
        return this.entitySets.values();
    }

    @Override
    public Collection<Service.ServiceFunction> getServiceFunction(String serviceFunctionName) {
        return this.serviceFunctions.get((Object)serviceFunctionName);
    }

    @Override
    public Collection<Service.ServiceFunction> getAllServiceFunctions() {
        return this.serviceFunctions.values();
    }

    @Override
    public Collection<Service.ServiceBoundFunction> getAllServiceBoundFunctions() {
        return this.serviceBoundFunctions.values();
    }

    @Override
    public Collection<Service.ServiceBoundAction> getAllServiceBoundActions() {
        return this.serviceBoundActions.values();
    }

    @Override
    public Collection<Service.ServiceAction> getServiceAction(String serviceActionName) {
        return this.serviceActions.get((Object)serviceActionName);
    }

    @Override
    public Collection<Service.ServiceAction> getAllServiceActions() {
        return this.serviceActions.values();
    }

    @Override
    public String getJavaPackageName() {
        String javaPackageNameKey = this.name + ".packageName";
        String javaPackageName = this.serviceNameMappings.getString(javaPackageNameKey);
        if (javaPackageName == null) {
            javaPackageName = NamingUtils.serviceNameToJavaPackageName((String)this.getTitle());
        }
        return javaPackageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJavaClassName() {
        String javaClassNameKey = this.name + ".className";
        String javaClassName = this.serviceNameMappings.getString(javaClassNameKey);
        if (javaClassName == null) {
            javaClassName = NamingUtils.serviceNameToBaseJavaClassName((String)this.getTitle());
        }
        return javaClassName;
    }

    @Override
    public String getInfoDescription() {
        if (this.details.getInfo() == null) {
            return null;
        }
        return this.details.getInfo().getDescription();
    }

    @Override
    public String getInfoVersion() {
        if (this.details.getInfo() == null) {
            return null;
        }
        return this.details.getInfo().getVersion();
    }

    @Override
    public String getMinErpVersion() {
        return this.details.getMinErpVersion();
    }

    @Override
    public String getExternalUrl() {
        if (this.details.getExternalDocs() == null) {
            return null;
        }
        return this.details.getExternalDocs().getUrl();
    }

    @Override
    public String getExternalDescription() {
        if (this.details.getExternalDocs() == null) {
            return null;
        }
        return this.details.getExternalDocs().getDescription();
    }

    public List<Service.ExternalOverview> getExternalOverview() {
        List<? extends ServiceDetails.ExternalOverview> input = this.details.getExtOverview();
        if (input == null) {
            return null;
        }
        ArrayList<Service.ExternalOverview> result = new ArrayList<Service.ExternalOverview>(input.size());
        for (ServiceDetails.ExternalOverview externalOverview : input) {
            result.add(new ExternalOverviewAdapter(externalOverview));
        }
        return result;
    }

    @Override
    public Collection<ApiFunction> getAllowedFunctionsByEntity(String entity) {
        return this.allowedFunctionsByEntity.apply(entity);
    }

    @Override
    public boolean hasLinkToApiBusinessHub() {
        return this.hasLinkToApiBusinessHub;
    }

    private Service.Type convertType(@Nonnull EdmType type) {
        if (type instanceof EdmEnumTypeImpl) {
            return new EnumTypeAdapter((EdmEnumTypeImpl)type);
        }
        if (type instanceof EdmPrimitiveType) {
            return new PrimitiveTypeAdapter((EdmPrimitiveType)type);
        }
        if (type instanceof EdmEntityType) {
            return new EntityTypeAdapter((EdmEntityType)type);
        }
        if (type instanceof EdmComplexType) {
            return new ComplexTypeAdapter((EdmComplexType)type);
        }
        throw new ODataGeneratorException("Found unknown EdmType implementation: " + type.getClass());
    }

    private String getAnnotationStringValue(EdmAnnotatable edmAnnotatable, String[] annotationTerms) {
        Map<EdmTerm, Object> annotationTermToValue = edmAnnotatable.getAnnotations().stream().filter(a -> a.getTerm() != null).filter(a -> a.getExpression().isConstant()).collect(Collectors.toMap(EdmAnnotation::getTerm, a -> a.getExpression().asConstant().asPrimitive()));
        for (String termFqn : annotationTerms) {
            EdmTerm term = this.metadata.getTerm(new FullQualifiedName(termFqn));
            Object result = annotationTermToValue.get(term);
            if (!(result instanceof String)) continue;
            return (String)result;
        }
        return null;
    }

    @Generated
    void setGenerateExplicitDeprecationNotices(boolean generateExplicitDeprecationNotices) {
        this.generateExplicitDeprecationNotices = generateExplicitDeprecationNotices;
    }

    private final class EntitySetAdapter
    implements Service.EntitySet {
        private final EdmEntitySet entitySet;

        private EntitySetAdapter(EdmEntitySet entitySet) {
            this.entitySet = entitySet;
        }

        @Override
        public String getName() {
            try {
                return this.entitySet.getName();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.EntityType getEntityType() {
            try {
                return new EntityTypeAdapter(this.entitySet.getEntityType());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Annotations getAnnotations() {
            return new AnnotationsAdapter((EdmAnnotatable)this.entitySet);
        }
    }

    private final class ServiceFunctionAdapter
    implements Service.ServiceFunction {
        private final EdmFunctionImport functionImport;
        private final EdmFunction unboundFunction;

        private ServiceFunctionAdapter(@Nonnull EdmFunctionImport functionImport, EdmFunction unboundFunction) {
            this.functionImport = functionImport;
            this.unboundFunction = unboundFunction;
        }

        @Override
        public String getName() {
            try {
                return this.functionImport.getName();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        @Nullable
        public Service.ReturnType getReturnType() {
            try {
                EdmReturnType returnType = this.unboundFunction.getReturnType();
                if (returnType == null) {
                    return null;
                }
                return new ReturnTypeAdapter(returnType);
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getHttpMethod() {
            return "GET";
        }

        @Override
        public Collection<String> getParameterNames() {
            try {
                return this.unboundFunction.getParameterNames();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Parameter getParameter(String parameterName) {
            try {
                return new ParameterAdapter(this.unboundFunction.getParameter(parameterName));
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Annotations getAnnotations() {
            return new AnnotationsAdapter((EdmAnnotatable)this.unboundFunction);
        }
    }

    private final class ServiceActionAdapter
    implements Service.ServiceAction {
        private final EdmActionImport actionImport;
        private final EdmAction unboundAction;

        private ServiceActionAdapter(@Nonnull EdmActionImport actionImport, EdmAction unboundAction) {
            this.actionImport = actionImport;
            this.unboundAction = unboundAction;
        }

        @Override
        public String getName() {
            try {
                return this.actionImport.getName();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        @Nullable
        public Service.ReturnType getReturnType() {
            try {
                EdmReturnType returnType = this.unboundAction.getReturnType();
                if (returnType == null) {
                    return null;
                }
                return new ReturnTypeAdapter(returnType);
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getHttpMethod() {
            return "POST";
        }

        @Override
        public Collection<String> getParameterNames() {
            try {
                return this.unboundAction.getParameterNames();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Parameter getParameter(String parameterName) {
            try {
                return new ParameterAdapter(this.unboundAction.getParameter(parameterName));
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Annotations getAnnotations() {
            return new AnnotationsAdapter((EdmAnnotatable)this.unboundAction);
        }
    }

    private final class BoundFunctionAdapter
    extends AbstractBoundOperationAdapter
    implements Service.ServiceBoundFunction {
        public BoundFunctionAdapter(EdmFunction function) {
            super((EdmOperation)function);
        }

        @Override
        @Nonnull
        public EdmFunction getBoundFunction() {
            return (EdmFunction)this.operation;
        }

        @Override
        public boolean isFunction() {
            return true;
        }
    }

    private final class BoundActionAdapter
    extends AbstractBoundOperationAdapter
    implements Service.ServiceBoundAction {
        public BoundActionAdapter(EdmAction action) {
            super((EdmOperation)action);
        }

        @Override
        @Nonnull
        public EdmAction getBoundAction() {
            return (EdmAction)this.operation;
        }

        @Override
        public boolean isFunction() {
            return false;
        }
    }

    private static final class ExternalOverviewAdapter
    implements Service.ExternalOverview {
        private final ServiceDetails.ExternalOverview overview;

        private ExternalOverviewAdapter(@Nonnull ServiceDetails.ExternalOverview overview) {
            this.overview = overview;
        }

        @Override
        public String getName() {
            return this.overview.getName();
        }

        @Override
        public List<String> getValues() {
            return this.overview.getValues();
        }
    }

    private final class EnumTypeAdapter
    extends TypeAdapter
    implements Service.EnumType {
        private final EdmEnumTypeImpl enumType;

        private EnumTypeAdapter(EdmEnumTypeImpl simpleType) {
            super((EdmType)simpleType);
            this.enumType = simpleType;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.enumType.getFullQualifiedName().getFullQualifiedNameAsString();
        }

        @Override
        public Collection<String> getMemberNames() {
            return this.enumType.getMemberNames();
        }

        @Override
        public String getMemberValue(String name) {
            return this.enumType.getMember(name).getValue();
        }

        @Override
        public Service.Annotations getAnnotations() {
            return new AnnotationsAdapter((EdmAnnotatable)this.enumType);
        }
    }

    private static final class PrimitiveTypeAdapter
    extends TypeAdapter
    implements Service.PrimitiveType {
        private final EdmPrimitiveType simpleType;

        private PrimitiveTypeAdapter(EdmPrimitiveType simpleType) {
            super((EdmType)simpleType);
            this.simpleType = simpleType;
        }

        @Override
        public Class<?> getDefaultJavaType() {
            if (this.simpleType instanceof EdmDate) {
                return LocalDate.class;
            }
            if (this.simpleType instanceof EdmTimeOfDay) {
                return LocalTime.class;
            }
            if (this.simpleType instanceof EdmDateTimeOffset) {
                return OffsetDateTime.class;
            }
            return this.simpleType.getDefaultType();
        }

        @Override
        public boolean isSupportedEdmType() {
            return !(this.simpleType instanceof AbstractGeospatialType);
        }
    }

    private final class EntityTypeAdapter
    extends StructuralTypeAdapter
    implements Service.EntityType {
        private final EdmEntityType entityType;

        private EntityTypeAdapter(EdmEntityType entityType) {
            super((EdmStructuredType)entityType);
            this.entityType = entityType;
        }

        @Override
        public Collection<String> getKeyPropertyNames() {
            try {
                return this.entityType.getKeyPredicateNames();
            }
            catch (EdmException e) {
                logger.info("Entity type \"" + this.entityType + "\" does not define a key.");
                return Collections.emptyList();
            }
        }

        @Override
        public Collection<String> getNavigationPropertyNames() {
            try {
                return this.entityType.getNavigationPropertyNames();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.NavigationProperty getNavigationProperty(String navigationPropertyName) {
            try {
                return new NavigationPropertyAdapter(this.entityType.getNavigationProperty(navigationPropertyName));
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public boolean hasMediaStream() {
            try {
                return this.entityType.hasStream();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }
    }

    private final class ComplexTypeAdapter
    extends StructuralTypeAdapter
    implements Service.ComplexType {
        private ComplexTypeAdapter(EdmComplexType edmComplexType) {
            super((EdmStructuredType)edmComplexType);
        }
    }

    private abstract class AbstractBoundOperationAdapter
    implements Service.ServiceBoundOperation {
        protected final EdmOperation operation;

        @Override
        public String getName() {
            try {
                return this.operation.getName();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        @Nullable
        public Service.ReturnType getReturnType() {
            try {
                EdmReturnType returnType = this.operation.getReturnType();
                if (returnType == null) {
                    return null;
                }
                return new ReturnTypeAdapter(returnType);
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getHttpMethod() {
            return "GET";
        }

        @Override
        public Collection<String> getParameterNames() {
            try {
                return this.operation.getParameterNames();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Parameter getParameter(String parameterName) {
            try {
                return new ParameterAdapter(this.operation.getParameter(parameterName));
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Annotations getAnnotations() {
            return new AnnotationsAdapter((EdmAnnotatable)this.operation);
        }

        @Generated
        public AbstractBoundOperationAdapter(EdmOperation operation) {
            this.operation = operation;
        }

        @Override
        @Generated
        public EdmOperation getOperation() {
            return this.operation;
        }
    }

    private abstract class StructuralTypeAdapter
    implements Service.StructuralType {
        private final EdmStructuredType edmStructuralType;

        StructuralTypeAdapter(EdmStructuredType edmStructuralType) {
            this.edmStructuralType = edmStructuralType;
        }

        @Override
        public String getName() {
            try {
                return this.edmStructuralType.getName();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public String getFullyQualifiedName() {
            return this.edmStructuralType.getFullQualifiedName().getFullQualifiedNameAsString();
        }

        @Override
        public Collection<String> getPropertyNames() {
            try {
                return this.edmStructuralType.getPropertyNames();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Property getProperty(String propertyName) {
            try {
                return new PropertyAdapter(this.edmStructuralType.getStructuralProperty(propertyName));
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Service.Annotations getAnnotations() {
            return new AnnotationsAdapter((EdmAnnotatable)this.edmStructuralType);
        }
    }

    private final class NavigationPropertyAdapter
    extends ElementAdapter
    implements Service.NavigationProperty {
        private final EdmNavigationProperty edmNavigationProperty;

        private NavigationPropertyAdapter(EdmNavigationProperty edmNavigationProperty) {
            super((EdmTyped)edmNavigationProperty);
            this.edmNavigationProperty = edmNavigationProperty;
        }

        @Override
        public Service.Facets getFacets() {
            return new NavigationPropertyFacetsAdapter(this.edmNavigationProperty);
        }

        @Override
        public Service.Annotations getAnnotations() {
            return new AnnotationsAdapter((EdmAnnotatable)this.edmNavigationProperty);
        }
    }

    private static final class NavigationPropertyFacetsAdapter
    implements Service.Facets {
        private final EdmNavigationProperty edmNavigationProperty;

        private NavigationPropertyFacetsAdapter(@Nonnull EdmNavigationProperty edmNavigationProperty) {
            this.edmNavigationProperty = edmNavigationProperty;
        }

        @Override
        public Boolean isNullable() {
            return this.edmNavigationProperty.isNullable();
        }

        @Override
        public String getDefaultValue() {
            return null;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getPrecision() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }
    }

    private final class PropertyAdapter
    extends ElementAdapter
    implements Service.Property {
        private final EdmProperty edmProperty;

        private PropertyAdapter(EdmProperty edmProperty) {
            super((EdmTyped)edmProperty);
            this.edmProperty = edmProperty;
        }

        @Override
        public Service.Facets getFacets() {
            return new PropertyFacetsAdapter(this.edmProperty);
        }

        @Override
        public Service.Annotations getAnnotations() {
            return new AnnotationsAdapter((EdmAnnotatable)this.edmProperty);
        }
    }

    private static final class PropertyFacetsAdapter
    implements Service.Facets {
        private final EdmProperty edmProperty;

        private PropertyFacetsAdapter(@Nonnull EdmProperty edmProperty) {
            this.edmProperty = edmProperty;
        }

        @Override
        public Boolean isNullable() {
            return this.edmProperty.isNullable();
        }

        @Override
        public String getDefaultValue() {
            return this.edmProperty.getDefaultValue();
        }

        @Override
        public Integer getMaxLength() {
            return this.edmProperty.getMaxLength();
        }

        @Override
        public Integer getPrecision() {
            return this.edmProperty.getPrecision();
        }

        @Override
        public Integer getScale() {
            return this.edmProperty.getScale();
        }
    }

    private final class ParameterAdapter
    extends ElementAdapter
    implements Service.Parameter {
        private final EdmParameter edmParameter;

        private ParameterAdapter(EdmParameter edmParameter) {
            super((EdmTyped)edmParameter);
            this.edmParameter = edmParameter;
        }

        @Override
        public Service.Facets getFacets() {
            return new ParameterFacetsAdapter(this.edmParameter);
        }

        @Override
        public Service.Annotations getAnnotations() {
            return new AnnotationsAdapter((EdmAnnotatable)this.edmParameter);
        }
    }

    private static final class ParameterFacetsAdapter
    implements Service.Facets {
        private final EdmParameter edmParameter;

        private ParameterFacetsAdapter(@Nonnull EdmParameter edmParameter) {
            this.edmParameter = edmParameter;
        }

        @Override
        public Boolean isNullable() {
            return this.edmParameter.isNullable();
        }

        @Override
        public String getDefaultValue() {
            return null;
        }

        @Override
        public Integer getMaxLength() {
            return this.edmParameter.getMaxLength();
        }

        @Override
        public Integer getPrecision() {
            return this.edmParameter.getPrecision();
        }

        @Override
        public Integer getScale() {
            return this.edmParameter.getScale();
        }
    }

    private final class ReturnTypeAdapter
    extends ElementAdapter
    implements Service.ReturnType {
        private final EdmReturnType edmReturnType;

        private ReturnTypeAdapter(EdmReturnType edmReturnType) {
            super((EdmTyped)edmReturnType);
            this.edmReturnType = edmReturnType;
        }

        @Override
        public Service.Facets getFacets() {
            return new ReturnTypeFacetsAdapter(this.edmReturnType);
        }
    }

    private static final class ReturnTypeFacetsAdapter
    implements Service.Facets {
        private final EdmReturnType edmReturnType;

        private ReturnTypeFacetsAdapter(@Nonnull EdmReturnType edmReturnType) {
            this.edmReturnType = edmReturnType;
        }

        @Override
        public Boolean isNullable() {
            return this.edmReturnType.isNullable();
        }

        @Override
        public String getDefaultValue() {
            return null;
        }

        @Override
        public Integer getMaxLength() {
            return this.edmReturnType.getMaxLength();
        }

        @Override
        public Integer getPrecision() {
            return this.edmReturnType.getPrecision();
        }

        @Override
        public Integer getScale() {
            return this.edmReturnType.getScale();
        }
    }

    private abstract class ElementAdapter
    implements Service.Element {
        private final EdmTyped edmTyped;

        ElementAdapter(EdmTyped edmTyped) {
            this.edmTyped = edmTyped;
        }

        @Override
        public Service.Type getType() {
            try {
                return EdmService.this.convertType(this.edmTyped.getType());
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public Multiplicity getMultiplicity() {
            try {
                return EdmUtils.convertMultiplicity(this.edmTyped);
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }
    }

    private static abstract class TypeAdapter
    implements Service.Type {
        private final EdmType edmType;

        TypeAdapter(@Nonnull EdmType edmType) {
            this.edmType = edmType;
        }

        @Override
        public String getName() {
            try {
                return this.edmType.getName();
            }
            catch (EdmException e) {
                throw new ODataGeneratorReadException(e);
            }
        }

        @Override
        public TypeKind getKind() {
            return EdmUtils.convertTypeKind(this.edmType.getKind());
        }
    }

    private class AnnotationsAdapter
    implements Service.Annotations {
        private final EdmAnnotatable edmAnnotatable;

        protected AnnotationsAdapter(EdmAnnotatable edmAnnotatable) {
            this.edmAnnotatable = edmAnnotatable;
        }

        @Override
        public String getLabel() {
            return EdmService.this.getAnnotationStringValue(this.edmAnnotatable, TERMS_LABEL);
        }

        @Override
        public String getQuickInfo() {
            return EdmService.this.getAnnotationStringValue(this.edmAnnotatable, TERMS_QUICK_INFO);
        }

        @Override
        public String getDescription() {
            return EdmService.this.getAnnotationStringValue(this.edmAnnotatable, TERMS_DESCRIPTION);
        }

        @Override
        public String getLongDescription() {
            return EdmService.this.getAnnotationStringValue(this.edmAnnotatable, TERMS_LONG_DESCRIPTION);
        }
    }

    static class DefaultDeprecationInfo
    implements Service.DeprecationInfo {
        static DefaultDeprecationInfo EMPTY = new DefaultDeprecationInfo(new ServiceDetails.StateInfo(){

            @Override
            public ServiceDetails.State getState() {
                return null;
            }

            @Override
            public String getDeprecationRelease() {
                return null;
            }

            @Override
            public String getSuccessorApi() {
                return null;
            }

            @Override
            public String getDeprecationDate() {
                return null;
            }
        });
        @Nonnull
        private final ServiceDetails.StateInfo details;

        @Override
        public Option<String> getSuccessorApi() {
            return Option.of((Object)this.details.getSuccessorApi());
        }

        @Override
        public Option<String> getDeprecationDate() {
            return Option.of((Object)this.details.getDeprecationDate());
        }

        @Override
        public Option<String> getDeprecationRelease() {
            return Option.of((Object)this.details.getDeprecationRelease());
        }

        @Generated
        public DefaultDeprecationInfo(@Nonnull ServiceDetails.StateInfo details) {
            if (details == null) {
                throw new NullPointerException("details is marked non-null but is null");
            }
            this.details = details;
        }
    }
}

