/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

@Beta
public class MessageCollector {
    private static final MessageCollectorCollection collection = new MessageCollectorCollection();

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls) {
        return new MessageCollectorLogger(cls, collection);
    }

    @Nonnull
    public static List<String> getErrorMessages() {
        return collection.getMessages(LogLevel.ERROR);
    }

    @Nonnull
    public static List<String> getWarningMessages() {
        return collection.getMessages(LogLevel.WARN);
    }

    private static final class MessageCollectorLogger
    implements Logger {
        private final Logger baseLogger;
        private final Class<?> cls;
        private final MessageCollectorCollection collection;

        private MessageCollectorLogger(Class<?> cls, MessageCollectorCollection collection) {
            this.baseLogger = LoggerFactory.getLogger(cls);
            this.cls = cls;
            this.collection = collection;
        }

        @Nonnull
        public String getName() {
            return this.baseLogger.getName();
        }

        public boolean isTraceEnabled() {
            return this.baseLogger.isTraceEnabled();
        }

        public void trace(@Nullable String msg) {
            this.baseLogger.trace(msg);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public void trace(@Nullable String format, @Nullable Object arg) {
            this.baseLogger.trace(format, arg);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, LoggerContent.of(format, arg));
        }

        public void trace(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.baseLogger.trace(format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, LoggerContent.of(format, arg1, arg2));
        }

        public void trace(@Nullable String format, Object ... arguments) {
            this.baseLogger.trace(format, arguments);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, LoggerContent.of(format, arguments));
        }

        public void trace(@Nullable String msg, @Nullable Throwable t) {
            this.baseLogger.trace(msg, t);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public boolean isTraceEnabled(@Nonnull Marker marker) {
            return this.baseLogger.isTraceEnabled(marker);
        }

        public void trace(@Nonnull Marker marker, @Nullable String msg) {
            this.baseLogger.trace(marker, msg);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public void trace(@Nonnull Marker marker, @Nullable String format, @Nullable Object arg) {
            this.baseLogger.trace(marker, format, arg);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, LoggerContent.of(format, arg));
        }

        public void trace(@Nonnull Marker marker, @Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.baseLogger.trace(marker, format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, LoggerContent.of(format, arg1, arg2));
        }

        public void trace(@Nonnull Marker marker, @Nullable String format, Object ... argArray) {
            this.baseLogger.trace(marker, format, argArray);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, LoggerContent.of(format, argArray));
        }

        public void trace(@Nonnull Marker marker, @Nullable String msg, @Nullable Throwable t) {
            this.baseLogger.trace(marker, msg, t);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public boolean isDebugEnabled() {
            return this.baseLogger.isDebugEnabled();
        }

        public void debug(@Nullable String msg) {
            this.baseLogger.debug(msg);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public void debug(@Nullable String format, @Nullable Object arg) {
            this.baseLogger.debug(format, arg);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, LoggerContent.of(format, arg));
        }

        public void debug(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.baseLogger.debug(format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, LoggerContent.of(format, arg1, arg2));
        }

        public void debug(@Nullable String format, Object ... arguments) {
            this.baseLogger.debug(format, arguments);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, LoggerContent.of(format, arguments));
        }

        public void debug(@Nullable String msg, @Nullable Throwable t) {
            this.baseLogger.debug(msg, t);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public boolean isDebugEnabled(@Nonnull Marker marker) {
            return this.baseLogger.isDebugEnabled(marker);
        }

        public void debug(@Nonnull Marker marker, @Nullable String msg) {
            this.baseLogger.debug(marker, msg);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public void debug(@Nonnull Marker marker, @Nullable String format, @Nullable Object arg) {
            this.baseLogger.debug(marker, format, arg);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, LoggerContent.of(format, arg));
        }

        public void debug(@Nonnull Marker marker, @Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.baseLogger.debug(marker, format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, LoggerContent.of(format, arg1, arg2));
        }

        public void debug(@Nonnull Marker marker, @Nullable String format, Object ... arguments) {
            this.baseLogger.debug(marker, format, arguments);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, LoggerContent.of(format, arguments));
        }

        public void debug(@Nonnull Marker marker, @Nullable String msg, @Nullable Throwable t) {
            this.baseLogger.debug(marker, msg, t);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public boolean isInfoEnabled() {
            return this.baseLogger.isInfoEnabled();
        }

        public void info(@Nullable String msg) {
            this.baseLogger.info(msg);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public void info(@Nullable String format, @Nullable Object arg) {
            this.baseLogger.info(format, arg);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, LoggerContent.of(format, arg));
        }

        public void info(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.baseLogger.info(format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, LoggerContent.of(format, arg1, arg2));
        }

        public void info(@Nullable String format, Object ... arguments) {
            this.baseLogger.info(format, arguments);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, LoggerContent.of(format, arguments));
        }

        public void info(@Nullable String msg, @Nullable Throwable t) {
            this.baseLogger.info(msg, t);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public boolean isInfoEnabled(@Nonnull Marker marker) {
            return this.baseLogger.isInfoEnabled(marker);
        }

        public void info(@Nonnull Marker marker, @Nullable String msg) {
            this.baseLogger.info(marker, msg);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public void info(@Nonnull Marker marker, @Nullable String format, @Nullable Object arg) {
            this.baseLogger.info(marker, format, arg);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, LoggerContent.of(format, arg));
        }

        public void info(@Nonnull Marker marker, @Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.baseLogger.info(marker, format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, LoggerContent.of(format, arg1, arg2));
        }

        public void info(@Nonnull Marker marker, @Nullable String format, Object ... arguments) {
            this.baseLogger.info(marker, format, arguments);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, LoggerContent.of(format, arguments));
        }

        public void info(@Nonnull Marker marker, @Nullable String msg, @Nullable Throwable t) {
            this.baseLogger.info(marker, msg, t);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, LoggerContent.of(msg, t));
        }

        public boolean isWarnEnabled() {
            return this.baseLogger.isWarnEnabled();
        }

        public void warn(@Nullable String msg) {
            this.baseLogger.warn(msg);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public void warn(@Nullable String format, @Nullable Object arg) {
            this.baseLogger.warn(format, arg);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, LoggerContent.of(format, arg));
        }

        public void warn(@Nullable String format, Object ... arguments) {
            this.baseLogger.warn(format, arguments);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, LoggerContent.of(format, arguments));
        }

        public void warn(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.baseLogger.warn(format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, LoggerContent.of(format, arg1, arg2));
        }

        public void warn(@Nullable String msg, @Nullable Throwable t) {
            this.baseLogger.warn(msg, t);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, LoggerContent.of(msg, t));
        }

        public boolean isWarnEnabled(@Nonnull Marker marker) {
            return this.baseLogger.isWarnEnabled(marker);
        }

        public void warn(@Nonnull Marker marker, @Nullable String msg) {
            this.baseLogger.warn(marker, msg);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public void warn(@Nonnull Marker marker, @Nullable String format, @Nullable Object arg) {
            this.baseLogger.warn(marker, format, arg);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, LoggerContent.of(format, arg));
        }

        public void warn(@Nonnull Marker marker, @Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.baseLogger.warn(marker, format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, LoggerContent.of(format, arg1, arg2));
        }

        public void warn(@Nonnull Marker marker, @Nullable String format, Object ... arguments) {
            this.baseLogger.warn(marker, format, arguments);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, LoggerContent.of(format, arguments));
        }

        public void warn(@Nonnull Marker marker, @Nullable String msg, @Nullable Throwable t) {
            this.baseLogger.warn(marker, msg, t);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public boolean isErrorEnabled() {
            return this.baseLogger.isErrorEnabled();
        }

        public void error(@Nullable String msg) {
            this.baseLogger.error(msg);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public void error(@Nullable String format, @Nullable Object arg) {
            this.baseLogger.error(format, arg);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, LoggerContent.of(format, arg));
        }

        public void error(@Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.baseLogger.error(format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, LoggerContent.of(format, arg1, arg2));
        }

        public void error(@Nullable String format, Object ... arguments) {
            this.baseLogger.error(format, arguments);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, LoggerContent.of(format, arguments));
        }

        public void error(@Nullable String msg, @Nullable Throwable t) {
            this.baseLogger.error(msg, t);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, LoggerContent.of(msg, t));
        }

        public boolean isErrorEnabled(@Nonnull Marker marker) {
            return this.baseLogger.isErrorEnabled(marker);
        }

        public void error(@Nonnull Marker marker, @Nullable String msg) {
            this.baseLogger.error(marker, msg);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, LoggerContent.of(msg, new Object[0]));
        }

        public void error(@Nonnull Marker marker, @Nullable String format, @Nullable Object arg) {
            this.baseLogger.error(marker, format, arg);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, LoggerContent.of(format, arg));
        }

        public void error(@Nonnull Marker marker, @Nullable String format, @Nullable Object arg1, @Nullable Object arg2) {
            this.baseLogger.error(marker, format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, LoggerContent.of(format, arg1, arg2));
        }

        public void error(@Nonnull Marker marker, @Nullable String format, Object ... arguments) {
            this.baseLogger.error(marker, format, arguments);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, LoggerContent.of(format, arguments));
        }

        public void error(@Nonnull Marker marker, @Nullable String msg, @Nullable Throwable t) {
            this.baseLogger.error(marker, msg, t);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, LoggerContent.of(msg, new Object[0]));
        }
    }

    private static final class MessageCollectorCollection {
        private final Map<LogLevel, Map<Class<?>, List<LoggerContent>>> collector = new EnumMap(LogLevel.class);

        private MessageCollectorCollection() {
        }

        void collectLogMessage(LogLevel logLevel, Class<?> cls, LoggerContent content) {
            Map levelEntries = MessageCollectorCollection.getOrDefault(this.collector, logLevel, new HashMap());
            List classEntries = MessageCollectorCollection.getOrDefault(levelEntries, cls, new ArrayList());
            classEntries.add(content);
            levelEntries.put(cls, classEntries);
            this.collector.put(logLevel, levelEntries);
        }

        List<String> getMessages(LogLevel level) {
            Map levelEntries = MessageCollectorCollection.getOrDefault(this.collector, level, Collections.emptyMap());
            ArrayList<String> allMessages = new ArrayList<String>();
            for (List contents : levelEntries.values()) {
                for (LoggerContent content : contents) {
                    allMessages.add((String)content.get());
                }
            }
            return allMessages;
        }

        static <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
            return map.getOrDefault(key, defaultValue);
        }
    }

    private static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    private static interface LoggerContent
    extends Supplier<String> {
        @Nonnull
        public static LoggerContent of(@Nullable String message, Object ... arguments) {
            return () -> MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage();
        }
    }
}

