/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction;
import com.sap.cloud.sdk.datamodel.odatav4.core.BoundFunction;
import com.sap.cloud.sdk.datamodel.odatav4.generator.TypeKind;

class BoundOperationGenerator {
    BoundOperationGenerator() {
    }

    static Class<?> getFunctionClass(boolean boundToCollection, boolean returnsCollection, TypeKind resultTypeKind, boolean composable) {
        if (!boundToCollection && !returnsCollection) {
            if (!composable) {
                return BoundFunction.SingleToSingle.class;
            }
            switch (resultTypeKind) {
                case ENTITY: {
                    return BoundFunction.SingleToSingleEntity.Composable.class;
                }
            }
            return BoundFunction.SingleToSingle.class;
        }
        if (!boundToCollection && returnsCollection) {
            if (!composable) {
                return BoundFunction.SingleToCollection.class;
            }
            switch (resultTypeKind) {
                case ENTITY: {
                    return BoundFunction.SingleToCollectionEntity.Composable.class;
                }
            }
            return BoundFunction.SingleToCollection.class;
        }
        if (boundToCollection && !returnsCollection) {
            if (!composable) {
                return BoundFunction.CollectionToSingle.class;
            }
            switch (resultTypeKind) {
                case ENTITY: {
                    return BoundFunction.CollectionToSingleEntity.Composable.class;
                }
            }
            return BoundFunction.SingleToCollection.class;
        }
        if (boundToCollection && returnsCollection) {
            if (!composable) {
                return BoundFunction.CollectionToCollection.class;
            }
            switch (resultTypeKind) {
                case ENTITY: {
                    return BoundFunction.CollectionToCollectionEntity.Composable.class;
                }
            }
            return BoundFunction.SingleToCollection.class;
        }
        throw new IllegalStateException("At this point all cases must be handled.");
    }

    static Class<?> getActionClass(boolean boundToCollection, boolean returnsCollection) {
        if (!boundToCollection && !returnsCollection) {
            return BoundAction.SingleToSingle.class;
        }
        if (!boundToCollection && returnsCollection) {
            return BoundAction.SingleToCollection.class;
        }
        if (boundToCollection && !returnsCollection) {
            return BoundAction.CollectionToSingle.class;
        }
        if (boundToCollection && returnsCollection) {
            return BoundAction.CollectionToCollection.class;
        }
        throw new IllegalStateException("At this point all cases must be handled.");
    }

    static String getJavadocDescriptionForOperation(boolean isFunction, boolean boundToCollection) {
        String singleBindingText = " that can be applied to any entity object of this class.</p>";
        String collectionBindingText = " that can be applied to a collection of entities of this class.</p>";
        return (isFunction ? "Function" : "Action") + (boundToCollection ? " that can be applied to a collection of entities of this class.</p>" : " that can be applied to any entity object of this class.</p>");
    }

    static String getJavadocReturnForOperation(boolean isFunction, boolean boundToCollection) {
        String operation = isFunction ? "Function" : "Action";
        String singleBindingDescriptionText = operation + " object prepared with the given parameters to be applied to any entity object of this class.</p>";
        String collectionBindingDescriptionText = operation + " object prepared with the given parameters to be applied to a collection of entities of this class.</p>";
        String singleBindingUsageText = String.format(" To execute it use the {@code service.forEntity(entity).apply%s(this%s)} API.", operation, operation);
        String collectionBindingUsageText = String.format(" To execute it use the {@code service.forEntity(entity).apply%s(this%s)} API.", operation, operation);
        return boundToCollection ? collectionBindingDescriptionText + collectionBindingUsageText : singleBindingDescriptionText + singleBindingUsageText;
    }
}

