/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.sap.cloud.sdk.datamodel.odata.utility.LegacyClassScanner;
import com.sap.cloud.sdk.datamodel.odatav4.generator.CopyrightHeaderCodeWriter;
import com.sap.cloud.sdk.datamodel.odatav4.generator.DataModelGeneratorConfig;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EdmService;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EntitySetProcessor;
import com.sap.cloud.sdk.datamodel.odatav4.generator.GeneratorReferenceCodeWriter;
import com.sap.cloud.sdk.datamodel.odatav4.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odatav4.generator.NamespaceClassGenerator;
import com.sap.cloud.sdk.datamodel.odatav4.generator.NamingContext;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorWriteException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataToVdmGenerator;
import com.sap.cloud.sdk.datamodel.odatav4.generator.PreparedEntityBluePrint;
import com.sap.cloud.sdk.datamodel.odatav4.generator.SafeCodeWriter;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Service;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ServiceClassGenerator;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;

class CodeModelClassGenerator {
    private static final Logger logger = MessageCollector.getLogger(ODataToVdmGenerator.class);
    private final NamespaceClassGenerator namespaceClassGenerator;
    private final ServiceClassGenerator serviceClassGenerator;
    private final JCodeModel codeModel;
    private final DataModelGeneratorConfig config;
    private LegacyClassScanner classScanner;

    CodeModelClassGenerator(@Nonnull DataModelGeneratorConfig config, @Nonnull String namespaceParentPackageName, @Nonnull String servicePackageName) {
        this.config = config;
        this.codeModel = new JCodeModel();
        JPackage namespaceParentPackage = this.codeModel._package(namespaceParentPackageName);
        this.classScanner = config.isKeepExistingSignatures() ? new LegacyClassScanner(config.getOutputDirectory()) : LegacyClassScanner.DISABLED;
        this.namespaceClassGenerator = new NamespaceClassGenerator(this.codeModel, namespaceParentPackage, config.getNamingStrategy(), config.getAnnotationStrategy(), config.isGeneratePojosOnly(), config.isServiceMethodsPerEntitySet(), this.classScanner);
        if (config.isGeneratePojosOnly()) {
            this.serviceClassGenerator = null;
        } else {
            JPackage servicePackage = this.codeModel._package(servicePackageName);
            this.serviceClassGenerator = new ServiceClassGenerator(this.codeModel, servicePackage, namespaceParentPackage, config.getNamingStrategy(), config.isServiceMethodsPerEntitySet(), this.classScanner);
        }
    }

    void processService(Service service, Collection<String> includedEntitySets, Collection<String> includedFunctionImports, Collection<String> includedActionImports) {
        String serviceTitle = service.getTitle();
        String odataEndpointPath = service.getServiceUrl();
        logger.info("Processing OData service '" + serviceTitle + "' at " + odataEndpointPath);
        EntitySetProcessor entitySetProcessor = new EntitySetProcessor(service, this.namespaceClassGenerator, this.serviceClassGenerator);
        NamingContext entityClassNamingContext = new NamingContext(NamingContext.NameEqualityStrategy.CASE_INSENSITIVE);
        if (this.config.getDeprecationNotice() != null) {
            ((EdmService)service).setGenerateExplicitDeprecationNotices(true);
            this.serviceClassGenerator.setCustomDeprecationNoticeForService(this.config.getDeprecationNotice());
        }
        List<PreparedEntityBluePrint> preparedEntityBluePrints = entitySetProcessor.processEntitySets(includedEntitySets, entityClassNamingContext);
        entitySetProcessor.processNavigationPropertyModels(preparedEntityBluePrints, entityClassNamingContext);
        if (!this.config.isGeneratePojosOnly()) {
            entitySetProcessor.processFunctionImports(includedFunctionImports, entityClassNamingContext);
            entitySetProcessor.processActionImports(includedActionImports, entityClassNamingContext);
            entitySetProcessor.processBoundFunctions(entityClassNamingContext);
            entitySetProcessor.processBoundActions(entityClassNamingContext);
        }
    }

    void writeClasses(@Nonnull DataModelGeneratorConfig config, @Nonnull Charset encoding) {
        this.ensureDirectoryExists(config.getOutputDirectory());
        CodeWriter codeWriter = this.getCodeWriter(config, encoding);
        this.writeCodeModel(codeWriter);
    }

    private void writeCodeModel(CodeWriter codeWriter) {
        try {
            this.codeModel.build(codeWriter);
        }
        catch (IOException e) {
            throw new ODataGeneratorWriteException(e);
        }
    }

    private void ensureDirectoryExists(File targetDir) {
        boolean success;
        if (!targetDir.exists() && !(success = targetDir.mkdirs())) {
            throw new ODataGeneratorWriteException("Could not create directory at '" + targetDir.getAbsolutePath() + "'");
        }
    }

    private CodeWriter getCodeWriter(@Nonnull DataModelGeneratorConfig config, @Nonnull Charset encoding) {
        CodeWriter codeWriter;
        if (config.isForceFileOverride()) {
            try {
                codeWriter = new FileCodeWriter(config.getOutputDirectory(), encoding.toString());
            }
            catch (IOException e) {
                throw new ODataGeneratorWriteException(e);
            }
        } else {
            codeWriter = new SafeCodeWriter(config.getOutputDirectory(), encoding.toString());
        }
        if (!config.getCopyrightHeader().isEmpty()) {
            codeWriter = new CopyrightHeaderCodeWriter(codeWriter, config.getCopyrightHeader(), encoding.toString());
        }
        if (config.isGenerateVersionReference()) {
            codeWriter = new GeneratorReferenceCodeWriter(codeWriter, encoding.toString());
        }
        return codeWriter;
    }

    boolean wasServiceGenerated(String serviceName) {
        return this.serviceClassGenerator != null && this.serviceClassGenerator.wasServiceGenerated(serviceName);
    }

    @Generated
    NamespaceClassGenerator getNamespaceClassGenerator() {
        return this.namespaceClassGenerator;
    }

    @Generated
    ServiceClassGenerator getServiceClassGenerator() {
        return this.serviceClassGenerator;
    }
}

