/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.sap.cloud.sdk.datamodel.odatav4.generator.EdmService;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Service;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class DeprecationUtils {
    static final String INDENT = "    ";

    private DeprecationUtils() {
    }

    static void addGetDefaultServicePathBody(JMethod createdMethod, JDefinedClass serviceInterface, Service service) {
        if (service.isDeprecated()) {
            createdMethod.body().directStatement("@SuppressWarnings( \"deprecation\" )\n        final String defaultServicePath = " + serviceInterface.fullName() + ".DEFAULT_SERVICE_PATH;\n        return defaultServicePath;");
        } else {
            createdMethod.body()._return((JExpression)serviceInterface.staticRef("DEFAULT_SERVICE_PATH"));
        }
    }

    static void createBasicServiceInterfaceField(JDefinedClass classToAddTheFieldTo, JDefinedClass serviceInterface, String fieldName, Service service) {
        if (service.isDeprecated()) {
            classToAddTheFieldTo.direct("\n    @SuppressWarnings( \"deprecation\" )\n    @Nonnull\n    private final " + serviceInterface.fullName() + " " + fieldName + ";\n");
        } else {
            JFieldVar serviceField = classToAddTheFieldTo.field(12, (JType)serviceInterface, fieldName);
            serviceField.annotate(Nonnull.class);
        }
    }

    static void addStatusInformation(@Nonnull JDefinedClass affectedClass, @Nonnull Service service, @Nullable String customDeprecationNotice) {
        if (service.isDeprecated()) {
            DeprecationUtils.addDeprecationInformation(affectedClass, (Service.DeprecationInfo)service.getDeprecationInfo().getOrElse((Object)EdmService.DefaultDeprecationInfo.EMPTY), customDeprecationNotice);
        }
    }

    private static void addDeprecationInformation(@Nonnull JDefinedClass affectedClass, @Nonnull Service.DeprecationInfo deprecationInfo, @Nullable String customDeprecationNotice) {
        String release = (String)deprecationInfo.getDeprecationRelease().map(r -> " as of release " + r).getOrElse((Object)"");
        String date = (String)deprecationInfo.getDeprecationDate().map(d -> " (" + d + ")").getOrElse((Object)"");
        String defaultDeprecationNotice = "Please use the odata generator to generate the VDM. ";
        String deprecationNotice = " " + (customDeprecationNotice != null && !customDeprecationNotice.isEmpty() ? customDeprecationNotice : "Please use the odata generator to generate the VDM. ");
        String successor = (String)deprecationInfo.getSuccessorApi().map(s -> " Please use the <a href=\"" + s + "\"> successor API</a> instead.").getOrElse((Object)deprecationNotice);
        affectedClass.javadoc().addDeprecated().add((Object)("The service and all its related classes are deprecated" + release + date + "." + successor));
        affectedClass.annotate(Deprecated.class);
    }
}

