/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.sap.cloud.sdk.datamodel.odatav4.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odatav4.generator.NamespaceClassGenerator;
import com.sap.cloud.sdk.datamodel.odatav4.generator.NamingContext;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorReadException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorWriteException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.PreparedEntityBluePrint;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Service;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ServiceClassGenerator;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

final class EntitySetProcessor {
    private static final Logger logger = MessageCollector.getLogger(EntitySetProcessor.class);
    private final Map<String, JDefinedClass> generatedEntities = new HashMap<String, JDefinedClass>();
    private final Map<String, JDefinedClass> generatedComplexTypes = new HashMap<String, JDefinedClass>();
    private final Map<String, JDefinedClass> generatedEnumTypes = new HashMap<String, JDefinedClass>();
    private final Service service;
    private final NamespaceClassGenerator namespaceClassGenerator;
    private final ServiceClassGenerator serviceClassGenerator;

    EntitySetProcessor(Service service, NamespaceClassGenerator namespaceClassGenerator, ServiceClassGenerator serviceClassGenerator) {
        this.service = service;
        this.namespaceClassGenerator = namespaceClassGenerator;
        this.serviceClassGenerator = serviceClassGenerator;
    }

    List<PreparedEntityBluePrint> processEntitySets(Collection<String> includeEntitySets, NamingContext entityClassNamingContext) {
        ArrayList<PreparedEntityBluePrint> entityResults = new ArrayList<PreparedEntityBluePrint>();
        ArrayList<Service.EntitySet> entitySetsToProcess = new ArrayList<Service.EntitySet>();
        if (includeEntitySets != null && !includeEntitySets.isEmpty()) {
            for (String entitySetName : includeEntitySets) {
                Service.EntitySet entitySet = this.service.getEntitySet(entitySetName);
                if (entitySet != null) {
                    entitySetsToProcess.add(entitySet);
                    continue;
                }
                logger.warn(String.format("Entity set '%s' was not found in the EDMX for service '%s', skipping.", entitySetName, this.service.getName()));
            }
        } else {
            entitySetsToProcess.addAll(this.service.getAllEntitySets());
        }
        for (Service.EntitySet entitySet : entitySetsToProcess) {
            try {
                Option<PreparedEntityBluePrint> entityStuffAfterFirstPass = this.namespaceClassGenerator.processEntitySet(this.serviceClassGenerator, this.service, this.generatedEntities, this.generatedComplexTypes, this.generatedEnumTypes, entitySet, entityClassNamingContext);
                entityStuffAfterFirstPass.peek(entityResults::add);
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorWriteException(e);
            }
        }
        return entityResults;
    }

    void processNavigationPropertyModels(Iterable<PreparedEntityBluePrint> entityBluePrints, NamingContext entityClassNamingContext) {
        for (PreparedEntityBluePrint entityBluePrint : entityBluePrints) {
            if (entityBluePrint.getNavigationProperties().isEmpty()) continue;
            try {
                this.namespaceClassGenerator.addNavigationPropertyCode(entityBluePrint, this.generatedEntities, this.generatedComplexTypes, this.generatedEnumTypes, entityClassNamingContext);
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorWriteException(e);
            }
        }
    }

    void processFunctionImports(Collection<String> includeFunctionImports, NamingContext entityClassNamingContext) {
        NamingContext functionImportFetchMethodNamingContext = new NamingContext();
        ArrayList<Service.ServiceFunction> functionImportsToProcess = new ArrayList<Service.ServiceFunction>();
        if (includeFunctionImports != null && !includeFunctionImports.isEmpty()) {
            for (String functionImportName : includeFunctionImports) {
                Collection<Service.ServiceFunction> functionImports = this.service.getServiceFunction(functionImportName);
                if (functionImports != null && !functionImports.isEmpty()) {
                    functionImportsToProcess.addAll(functionImports);
                    continue;
                }
                logger.warn(String.format("Function import '%s' was not found in the EDMX for service '%s', skipping.", functionImportName, this.service.getName()));
            }
        } else {
            functionImportsToProcess.addAll(this.service.getAllServiceFunctions());
        }
        for (Service.ServiceFunction functionImport : functionImportsToProcess) {
            this.validateFunctionOrActionImport(functionImport);
            try {
                this.namespaceClassGenerator.processUnboundOperation(this.serviceClassGenerator, this.service, this.generatedEntities, this.generatedComplexTypes, this.generatedEnumTypes, functionImport, entityClassNamingContext, functionImportFetchMethodNamingContext, true);
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorWriteException(e);
            }
        }
    }

    void processActionImports(Collection<String> includeActionImports, NamingContext entityClassNamingContext) {
        NamingContext actionImportFetchMethodNamingContext = new NamingContext();
        ArrayList<Service.ServiceAction> actionImportsToProcess = new ArrayList<Service.ServiceAction>();
        if (includeActionImports != null && !includeActionImports.isEmpty()) {
            for (String actionImportName : includeActionImports) {
                Collection<Service.ServiceAction> actionImports = this.service.getServiceAction(actionImportName);
                if (actionImports != null && !actionImports.isEmpty()) {
                    actionImportsToProcess.addAll(actionImports);
                    continue;
                }
                logger.warn(String.format("Action import '%s' was not found in the EDMX for service '%s', skipping.", actionImportName, this.service.getName()));
            }
        } else {
            actionImportsToProcess.addAll(this.service.getAllServiceActions());
        }
        for (Service.ServiceAction actionImport : actionImportsToProcess) {
            this.validateFunctionOrActionImport(actionImport);
            try {
                this.namespaceClassGenerator.processUnboundOperation(this.serviceClassGenerator, this.service, this.generatedEntities, this.generatedComplexTypes, this.generatedEnumTypes, actionImport, entityClassNamingContext, actionImportFetchMethodNamingContext, false);
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorWriteException(e);
            }
        }
    }

    private void validateFunctionOrActionImport(Service.ServiceOperation unboundOperation) {
        if (unboundOperation.getHttpMethod() == null) {
            throw new ODataGeneratorReadException("There was not HTTP method given for function/action import " + unboundOperation.getName() + ". You need to provide one via the 'm:HttpMethod' property.");
        }
    }

    void processBoundFunctions(NamingContext entityClassNamingContext) {
        Collection<Service.ServiceBoundFunction> allServiceBoundFunctions = this.service.getAllServiceBoundFunctions();
        allServiceBoundFunctions.forEach(f -> {
            try {
                this.namespaceClassGenerator.processBoundOperation(this.service, this.generatedEntities, this.generatedComplexTypes, this.generatedEnumTypes, (Service.ServiceBoundOperation)f, entityClassNamingContext);
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorWriteException(e);
            }
        });
    }

    void processBoundActions(NamingContext entityClassNamingContext) {
        Collection<Service.ServiceBoundAction> allServiceBoundActions = this.service.getAllServiceBoundActions();
        allServiceBoundActions.forEach(action -> {
            try {
                this.namespaceClassGenerator.processBoundOperation(this.service, this.generatedEntities, this.generatedComplexTypes, this.generatedEnumTypes, (Service.ServiceBoundOperation)action, entityClassNamingContext);
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorWriteException(e);
            }
        });
    }
}

