/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.util.StringUtils;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odata.utility.LegacyClassScanner;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingStrategy;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingUtils;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmEnumDeserializer;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmEnumSerializer;
import com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmComplex;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEnum;
import com.sap.cloud.sdk.datamodel.odatav4.generator.AnnotationHelper;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ApiFunction;
import com.sap.cloud.sdk.datamodel.odatav4.generator.BoundOperationGenerator;
import com.sap.cloud.sdk.datamodel.odatav4.generator.DeprecationUtils;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EntityMetadata;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EntityPropertyModel;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EntityPropertyModelAnnotationWrapper;
import com.sap.cloud.sdk.datamodel.odatav4.generator.JavadocUtils;
import com.sap.cloud.sdk.datamodel.odatav4.generator.LowercaseNameFormattingStrategy;
import com.sap.cloud.sdk.datamodel.odatav4.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Multiplicity;
import com.sap.cloud.sdk.datamodel.odatav4.generator.NamingContext;
import com.sap.cloud.sdk.datamodel.odatav4.generator.NavigationPropertyMethodsGenerator;
import com.sap.cloud.sdk.datamodel.odatav4.generator.NavigationPropertyModel;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.OperationParameterModel;
import com.sap.cloud.sdk.datamodel.odatav4.generator.PreparedEntityBluePrint;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Service;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ServiceClassGenerator;
import com.sap.cloud.sdk.datamodel.odatav4.generator.TypeKind;
import com.sap.cloud.sdk.datamodel.odatav4.generator.VdmObjectModel;
import com.sap.cloud.sdk.datamodel.odatav4.generator.VdmObjectModelAnnotationWrapper;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.AnnotationDefinition;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.AnnotationStrategy;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.EntityPropertyAnnotationModel;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.Getter;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.slf4j.Logger;

class NamespaceClassGenerator {
    private static final Logger logger = MessageCollector.getLogger(NamespaceClassGenerator.class);
    private final Map<String, JPackage> generatedNamespacePackages = new HashMap<String, JPackage>();
    private final Map<String, PreparedEntityBluePrint> entityBluePrintMap = new HashMap<String, PreparedEntityBluePrint>();
    private final JCodeModel codeModel;
    private final JPackage namespaceParentPackage;
    private final NamingStrategy codeNamingStrategy;
    private final AnnotationStrategy annotationStrategy;
    private final boolean generatePojosOnly;
    private final boolean serviceMethodsPerEntitySet;
    private final LegacyClassScanner classScanner;

    NamespaceClassGenerator(JCodeModel codeModel, JPackage namespaceParentPackage, NamingStrategy codeNamingStrategy, AnnotationStrategy annotationStrategy, boolean generatePojosOnly, boolean serviceMethodsPerEntitySet, LegacyClassScanner classScanner) {
        this.codeModel = codeModel;
        this.namespaceParentPackage = namespaceParentPackage;
        this.codeNamingStrategy = codeNamingStrategy;
        this.annotationStrategy = annotationStrategy;
        this.generatePojosOnly = generatePojosOnly;
        this.serviceMethodsPerEntitySet = serviceMethodsPerEntitySet;
        this.classScanner = classScanner;
    }

    private ClassGeneratorResult generateEdmEntityClass(JPackage namespacePackage, VdmObjectModel entityModel) throws JClassAlreadyExistsException {
        JDefinedClass generatedEntityClass = this.generateEntityClassStub((JClassContainer)namespacePackage, entityModel.getJavaClassName());
        generatedEntityClass = this.completeEntityClassGeneration(generatedEntityClass, entityModel);
        return new ClassGeneratorResult(generatedEntityClass);
    }

    private JDefinedClass generateEntityClassStub(JClassContainer namespacePackage, String javaClassName) throws JClassAlreadyExistsException {
        JDefinedClass entityClass = namespacePackage._class(1, javaClassName);
        entityClass._extends(this.codeModel.ref(VdmEntity.class).narrow((JClass)entityClass));
        return entityClass;
    }

    private JDefinedClass completeEntityClassGeneration(JDefinedClass entityClass, VdmObjectModel entityModel) {
        JFieldVar odataTypeField = entityClass.field(12, (JType)this.codeModel.ref(String.class), "odataType", JExpr.lit((String)entityModel.getEdmNameFullyQualified()));
        odataTypeField.annotate(Getter.class);
        JMethod getTypeMethod = entityClass.method(1, (JType)this.codeModel.ref(Class.class).narrow((JClass)entityClass), "getType");
        getTypeMethod.annotate(this.codeModel.ref(Nonnull.class));
        getTypeMethod.annotate(this.codeModel.ref(Override.class));
        getTypeMethod.body()._return(entityClass.dotclass());
        if (!Strings.isNullOrEmpty((String)entityModel.getDescription())) {
            entityClass.javadoc().add((Object)entityModel.getDescription());
        }
        entityClass.javadoc().add((Object)String.format("<p>Original entity name from the Odata EDM: <b>%s</b></p>", entityModel.getEdmName()));
        if (!this.generatePojosOnly) {
            entityClass.field(25, (JType)this.codeModel.ref(SimpleProperty.class).narrow((JClass)entityClass), "ALL_FIELDS", (JExpression)JExpr.invoke((String)"all")).javadoc().add((Object)("Selector for all available fields of " + entityClass.name() + "."));
        }
        VdmObjectModelAnnotationWrapper entityAnnotationModel = new VdmObjectModelAnnotationWrapper(entityModel);
        AnnotationHelper.addAllAnnotationsToJavaItem(this.annotationStrategy.getAnnotationsForEntity(entityAnnotationModel), (JAnnotatable)entityClass);
        for (Map.Entry<String, EntityPropertyModel> entry : entityModel.getProperties().entrySet()) {
            EntityPropertyModel mapping = entry.getValue();
            this.addPropertyAsField(entityClass, mapping, this.annotationStrategy::getAnnotationsForEntityProperty);
        }
        JMethod entityCollectionMethod = entityClass.method(2, String.class, "getEntityCollection");
        entityCollectionMethod.annotate(Override.class);
        entityCollectionMethod.body()._return(JExpr.lit((String)entityModel.getEdmEntityCollectionName()));
        if (!this.generatePojosOnly) {
            this.createMethodGetKey(entityModel.getProperties(), entityClass);
            this.createMethodToMap(entityModel.getProperties(), entityClass);
            this.processClassFields(entityModel.getProperties(), entityClass);
        }
        return entityClass;
    }

    private void createSimpleProperty(@Nonnull JDefinedClass entityClass, @Nullable JClass javaFieldClass, @Nonnull String javaConstantName, @Nonnull String edmName, boolean isCollection, boolean isEnum, @Nonnull String edmType) {
        JClass t;
        JClass primitiveType;
        Class<SimpleProperty.String> simplePropertyType;
        int mods = 25;
        switch (edmType) {
            case "String": {
                simplePropertyType = SimpleProperty.String.class;
                primitiveType = this.codeModel.ref(String.class);
                break;
            }
            case "Boolean": {
                simplePropertyType = SimpleProperty.Boolean.class;
                primitiveType = this.codeModel.ref(Boolean.class);
                break;
            }
            case "Decimal": 
            case "Single": 
            case "Double": {
                simplePropertyType = SimpleProperty.NumericDecimal.class;
                primitiveType = this.codeModel.ref(Double.class);
                break;
            }
            case "Int64": 
            case "Int32": 
            case "Int16": 
            case "Byte": {
                simplePropertyType = SimpleProperty.NumericInteger.class;
                primitiveType = this.codeModel.ref(Integer.class);
                break;
            }
            case "Duration": {
                simplePropertyType = SimpleProperty.Duration.class;
                primitiveType = this.codeModel.ref(Duration.class);
                break;
            }
            case "DateTimeOffset": {
                simplePropertyType = SimpleProperty.DateTime.class;
                primitiveType = this.codeModel.ref(OffsetDateTime.class);
                break;
            }
            case "Date": {
                simplePropertyType = SimpleProperty.Date.class;
                primitiveType = this.codeModel.ref(LocalDate.class);
                break;
            }
            case "TimeOfDay": {
                simplePropertyType = SimpleProperty.Time.class;
                primitiveType = this.codeModel.ref(LocalTime.class);
                break;
            }
            case "Guid": {
                simplePropertyType = SimpleProperty.Guid.class;
                primitiveType = this.codeModel.ref(UUID.class);
                break;
            }
            case "Binary": {
                simplePropertyType = SimpleProperty.Binary.class;
                primitiveType = this.codeModel.ref(byte[].class);
                break;
            }
            case "Stream": {
                logger.warn("    Unsupported type detected:\n      property name: {}, type: {}", (Object)edmName, (Object)edmType);
                return;
            }
            default: {
                if (isEnum) {
                    simplePropertyType = SimpleProperty.Enum.class;
                    primitiveType = javaFieldClass;
                    break;
                }
                logger.error("    Unsupported type detected:\n      property name: {}, type: {}", (Object)edmName, (Object)edmType);
                return;
            }
        }
        if (!isCollection) {
            if (!isEnum) {
                t = this.codeModel.ref(simplePropertyType).narrow((JClass)entityClass);
                JInvocation init = JExpr._new((JClass)t).arg(entityClass.dotclass()).arg(edmName);
                entityClass.field(25, (JType)t, javaConstantName, (JExpression)init);
                return;
            }
            t = this.codeModel.ref(simplePropertyType).narrow(new JClass[]{entityClass, primitiveType});
            JInvocation init = JExpr._new((JClass)t).arg(entityClass.dotclass()).arg(edmName).arg(edmType);
            entityClass.field(25, (JType)t, javaConstantName, (JExpression)init);
            return;
        }
        t = this.codeModel.ref(SimpleProperty.Collection.class).narrow(new JClass[]{entityClass, primitiveType});
        JInvocation init = JExpr._new((JClass)t).arg(entityClass.dotclass()).arg(edmName).arg(primitiveType.dotclass());
        entityClass.field(25, (JType)t, javaConstantName, (JExpression)init);
    }

    private void addPropertyAsField(JDefinedClass entityClass, EntityPropertyModel mapping, Function<EntityPropertyAnnotationModel, Set<AnnotationDefinition>> annotationSupplier) {
        JClass javaFieldType = mapping.getJavaFieldClass();
        if (mapping.isCollection()) {
            javaFieldType = this.codeModel.ref(Collection.class).narrow((JType)javaFieldType);
        }
        JFieldVar entityClassField = entityClass.field(4, (JType)javaFieldType, mapping.getJavaFieldName());
        if (mapping.isKeyField()) {
            entityClassField.javadoc().add((Object)"(Key Field)");
        }
        entityClassField.javadoc().add((Object)mapping.getConstraintsDescription());
        entityClassField.javadoc().add((Object)String.format("<p>Original property name from the Odata EDM: <b>%s</b></p>", mapping.getEdmName()));
        if (!Strings.isNullOrEmpty((String)mapping.getDetailedDescription())) {
            entityClassField.javadoc().add((Object)String.format("<p>%s</p>", mapping.getDetailedDescription()));
        }
        if (!Strings.isNullOrEmpty((String)mapping.getBasicDescription())) {
            entityClassField.javadoc().addReturn().add((Object)mapping.getBasicDescription());
        } else {
            entityClassField.javadoc().addReturn().add((Object)String.format("The %s contained in this {@link %s}.", entityClassField.name(), entityClass._extends().erasure().name()));
        }
        EntityPropertyModelAnnotationWrapper propertyAnnotationModel = new EntityPropertyModelAnnotationWrapper(mapping);
        AnnotationHelper.addAllAnnotationsToJavaItem(annotationSupplier.apply(propertyAnnotationModel), (JAnnotatable)entityClassField);
        this.generateSetterMethod(entityClass, entityClassField, mapping.getEdmName(), mapping.getBasicDescription());
        if (!this.generatePojosOnly) {
            if (mapping.isSimpleType() || mapping.isEnum()) {
                this.createSimpleProperty(entityClass, mapping.getJavaFieldClass(), mapping.getJavaConstantName(), mapping.getEdmName(), mapping.isCollection(), mapping.isEnum(), mapping.getEdmType());
            } else {
                this.createComplexProperty(entityClass, mapping.getJavaFieldClass(), mapping.getJavaConstantName(), mapping.getEdmName(), mapping.isCollection());
            }
        }
    }

    private void generateSetterMethod(@Nonnull JDefinedClass entityClass, @Nonnull JFieldVar fieldVar, @Nonnull String fieldName, @Nullable String parameterDescription) {
        JMethod setterMethod = entityClass.method(1, (JType)this.codeModel.VOID, "set" + StringUtils.capitalize((String)fieldVar.name()));
        JVar inputParam = setterMethod.param(8, fieldVar.type(), fieldVar.name());
        inputParam.annotate(Nullable.class);
        setterMethod.body().invoke("rememberChangedField").arg(fieldName).arg((JExpression)JExpr._this().ref((JVar)fieldVar));
        setterMethod.body().assign((JAssignmentTarget)JExpr._this().ref(fieldVar.name()), (JExpression)inputParam);
        String paramJavadoc = Strings.isNullOrEmpty((String)parameterDescription) ? String.format("The %s to set.", fieldVar.name()) : parameterDescription;
        setterMethod.javadoc().add((Object)fieldVar.javadoc());
        setterMethod.javadoc().addParam(inputParam).append((Object)paramJavadoc);
    }

    void addNavigationPropertyCode(PreparedEntityBluePrint entityBluePrint, Map<String, JDefinedClass> generatedEntities, Map<String, JDefinedClass> generatedComplexTypes, Map<String, JDefinedClass> generatedEnumTypes, NamingContext entityClassNamingContext) throws JClassAlreadyExistsException {
        for (NavigationPropertyModel navigationProperty : entityBluePrint.getNavigationProperties()) {
            JDefinedClass associatedEntity = generatedEntities.get(navigationProperty.getReturnEntityType().getName());
            if (associatedEntity != null) continue;
            PreparedEntityBluePrint childEntityBluePrint = this.processEntity(entityBluePrint.getEntityClass().getPackage(), generatedComplexTypes, generatedEnumTypes, navigationProperty.getReturnEntityType(), navigationProperty.getEdmName(), entityClassNamingContext);
            generatedEntities.put(navigationProperty.getReturnEntityType().getName(), childEntityBluePrint.getEntityClass());
            this.addNavigationPropertyCode(childEntityBluePrint, generatedEntities, generatedComplexTypes, generatedEnumTypes, entityClassNamingContext);
        }
        NavigationPropertyMethodsGenerator navPropGenerator = new NavigationPropertyMethodsGenerator(this.codeModel, entityBluePrint.getEntityClass());
        Map<String, JFieldVar> generatedNavigationPropertyFields = navPropGenerator.createNavigationPropertyFields(entityBluePrint.getNavigationProperties(), generatedEntities, this.annotationStrategy);
        if (!this.generatePojosOnly) {
            navPropGenerator.addNavigationPropertyMethods(generatedEntities, entityBluePrint.getKeyProperties(), entityBluePrint.getNavigationProperties(), generatedNavigationPropertyFields);
        }
    }

    private void createComplexProperty(@Nonnull JDefinedClass entityClass, @Nonnull JClass associatedEntity, @Nonnull String complexPropertyConstantName, @Nonnull String complexPropertyEdmName, boolean isOneToMany) {
        JClass navPropertyType = isOneToMany ? this.codeModel.ref(ComplexProperty.Collection.class).narrow(new JClass[]{entityClass, associatedEntity}) : this.codeModel.ref(ComplexProperty.Single.class).narrow(new JClass[]{entityClass, associatedEntity});
        JInvocation initLink = JExpr._new((JClass)navPropertyType).arg(entityClass.dotclass()).arg(complexPropertyEdmName).arg(associatedEntity.dotclass());
        JFieldVar navPropertyConstantField = entityClass.field(25, (JType)navPropertyType, complexPropertyConstantName, (JExpression)initLink);
        navPropertyConstantField.javadoc().add((Object)String.format("Use with available request builders to apply the <b>%s</b> complex property to query operations.", complexPropertyEdmName));
    }

    private JDefinedClass generateComplexTypeClass(JPackage namespacePackage, VdmObjectModel complexTypeModel) throws JClassAlreadyExistsException {
        JDefinedClass complexTypeClass = namespacePackage._class(1, complexTypeModel.getJavaClassName());
        complexTypeClass._extends(this.codeModel.ref(VdmComplex.class).narrow((JClass)complexTypeClass));
        JFieldVar odataTypeField = complexTypeClass.field(12, (JType)this.codeModel.ref(String.class), "odataType", JExpr.lit((String)complexTypeModel.getEdmNameFullyQualified()));
        odataTypeField.annotate(Getter.class);
        JMethod getTypeMethod = complexTypeClass.method(1, (JType)this.codeModel.ref(Class.class).narrow((JClass)complexTypeClass), "getType");
        getTypeMethod.annotate(this.codeModel.ref(Nonnull.class));
        getTypeMethod.annotate(this.codeModel.ref(Override.class));
        getTypeMethod.body()._return(complexTypeClass.dotclass());
        if (!Strings.isNullOrEmpty((String)complexTypeModel.getDescription())) {
            complexTypeClass.javadoc().add((Object)complexTypeModel.getDescription());
        }
        complexTypeClass.javadoc().add((Object)String.format("<p>Original complex type name from the Odata EDM: <b>%s</b></p>", complexTypeModel.getEdmName()));
        VdmObjectModelAnnotationWrapper complexTypeAnnotationModel = new VdmObjectModelAnnotationWrapper(complexTypeModel);
        AnnotationHelper.addAllAnnotationsToJavaItem(this.annotationStrategy.getAnnotationsForComplexType(complexTypeAnnotationModel), (JAnnotatable)complexTypeClass);
        this.createMethodToMap(complexTypeModel.getProperties(), complexTypeClass);
        this.processClassFields(complexTypeModel.getProperties(), complexTypeClass);
        this.createMethodGetKey(complexTypeModel.getProperties(), complexTypeClass);
        for (Map.Entry<String, EntityPropertyModel> entry : complexTypeModel.getProperties().entrySet()) {
            EntityPropertyModel mapping = entry.getValue();
            this.addPropertyAsField(complexTypeClass, mapping, this.annotationStrategy::getAnnotationsForComplexTypeProperty);
        }
        return complexTypeClass;
    }

    @Nonnull
    private JDefinedClass generateEnumTypeClass(JPackage namespacePackage, Service.EnumType enumTypeModel) throws JClassAlreadyExistsException {
        JDefinedClass clazz = namespacePackage._enum(enumTypeModel.getName());
        clazz._implements(this.codeModel.ref(VdmEnum.class));
        clazz.annotate(this.codeModel.ref(JsonAdapter.class)).param("value", (JType)this.codeModel.ref(GsonVdmAdapterFactory.class));
        clazz.annotate(this.codeModel.ref(JsonSerialize.class)).param("using", (JType)this.codeModel.ref(JacksonVdmEnumSerializer.class));
        clazz.annotate(this.codeModel.ref(JsonDeserialize.class)).param("using", (JType)this.codeModel.ref(JacksonVdmEnumDeserializer.class));
        enumTypeModel.getMemberNames().forEach(memberName -> {
            String classConstantName = this.codeNamingStrategy.generateJavaConstantName(memberName, null);
            String value = enumTypeModel.getMemberValue((String)memberName);
            JExpression enumValue = (JExpression)Try.of((CheckedFunction0 & Serializable)() -> JExpr.lit((long)Long.parseLong(value))).getOrElse(JExpr::_null);
            clazz.enumConstant(classConstantName).arg(JExpr.lit((String)memberName)).arg(enumValue).javadoc().add(memberName);
        });
        JFieldVar fieldName = clazz.field(12, String.class, "name");
        JFieldVar fieldValue = clazz.field(12, Long.class, "value");
        JMethod constructor = clazz.constructor(4);
        JVar paramName = constructor.param(8, String.class, "enumName");
        JVar paramValue = constructor.param(8, Long.class, "enumValue");
        constructor.body().assign((JAssignmentTarget)fieldName, (JExpression)paramName).assign((JAssignmentTarget)fieldValue, (JExpression)paramValue);
        JMethod getName = clazz.method(1, String.class, "getName");
        getName.annotate(Override.class);
        getName.body()._return((JExpression)fieldName);
        JMethod getValue = clazz.method(1, Long.class, "getValue");
        getValue.annotate(Override.class);
        getValue.body()._return((JExpression)fieldValue);
        clazz.javadoc().add((Object)String.format("<p>Original enum type name from the Odata EDM: <b>%s</b></p>", enumTypeModel.getName()));
        return clazz;
    }

    private void createMethodToMap(Map<String, EntityPropertyModel> entityClassFields, JDefinedClass entityClass) {
        JClass fieldMapClass = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        JMethod toMapMethod = entityClass.method(2, (JType)fieldMapClass, "toMapOfFields");
        toMapMethod.annotate(Nonnull.class);
        toMapMethod.annotate(Override.class);
        JBlock body = toMapMethod.body();
        JVar v = body.decl(8, (JType)fieldMapClass, "cloudSdkValues", (JExpression)JExpr._super().invoke("toMapOfFields"));
        for (Map.Entry<String, EntityPropertyModel> entry : entityClassFields.entrySet()) {
            String javaFieldName = entry.getValue().getJavaFieldName();
            String javaMethodName = "get" + StringUtils.capitalize((String)javaFieldName);
            body.invoke((JExpression)v, "put").arg(entry.getKey()).arg((JExpression)JExpr.invoke((String)javaMethodName));
        }
        body._return((JExpression)v);
    }

    private void processClassFields(Map<String, EntityPropertyModel> entityClassFields, JDefinedClass entityClass) {
        JClass fieldMapClass = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        JMethod fromMapMethod = entityClass.method(2, (JType)this.codeModel.VOID, "fromMap");
        fromMapMethod.annotate(Override.class);
        JVar inputValues = fromMapMethod.param(8, (JType)fieldMapClass, "inputValues");
        JBlock body = fromMapMethod.body();
        JVar values = body.decl(8, (JType)fieldMapClass, "cloudSdkValues", (JExpression)this.codeModel.ref(Maps.class).staticInvoke("newLinkedHashMap").arg((JExpression)inputValues));
        body.block().directStatement("// simple properties");
        JBlock simplePropertiesBlock = new JBlock(true, true);
        body.add((JStatement)simplePropertiesBlock);
        body.block().directStatement("// structured properties");
        JBlock complexPropertiesBlock = new JBlock(true, true);
        body.add((JStatement)complexPropertiesBlock);
        for (Map.Entry<String, EntityPropertyModel> entry : entityClassFields.entrySet()) {
            this.processClassField(fieldMapClass, values, simplePropertiesBlock, complexPropertiesBlock, entry);
        }
        body.block().directStatement("// navigation properties");
        JBlock navigationPropertiesBlock = new JBlock(true, true);
        body.add((JStatement)navigationPropertiesBlock);
        body.block().invoke(JExpr._super(), "fromMap").arg((JExpression)values);
    }

    private void processClassField(JClass fieldMapClass, JVar values, JBlock simplePropertiesBlock, JBlock complexPropertiesBlock, Map.Entry<String, EntityPropertyModel> entry) {
        JClass typeObject = this.codeModel.ref(Object.class);
        JClass typeIterable = this.codeModel.ref(Iterable.class);
        JClass typeEnum = this.codeModel.ref(VdmEnum.class);
        JClass typeString = this.codeModel.ref(String.class);
        String javaFieldName = entry.getValue().getJavaFieldName();
        String javaMethodGet = "get" + StringUtils.capitalize((String)javaFieldName);
        String javaMethodSet = "set" + StringUtils.capitalize((String)javaFieldName);
        JClass javaType = entry.getValue().getJavaFieldClass();
        JClass listType = this.codeModel.ref(LinkedList.class).narrow((JType)javaType);
        boolean isPrimitive = entry.getValue().isSimpleType();
        boolean isCollection = entry.getValue().isCollection();
        boolean isEnum = entry.getValue().isEnum();
        JBlock block = isPrimitive || isEnum ? simplePropertiesBlock : complexPropertiesBlock;
        JBlock ifFoundBody = block._if((JExpression)values.invoke("containsKey").arg(entry.getKey()))._then();
        JInvocation invokeRemove = values.invoke("remove").arg(entry.getKey());
        JVar value = ifFoundBody.decl(8, (JType)typeObject, "cloudSdkValue", (JExpression)invokeRemove);
        JExpression valueIsNull = value.eq(JExpr._null());
        JInvocation objectsEquals = this.codeModel.ref(Objects.class).staticInvoke("equals");
        if (isEnum) {
            JInvocation enumDeserializer = typeEnum.staticInvoke("getConstant").arg(javaType.boxify().dotclass());
            if (isCollection) {
                JExpression fieldIsNotEmpty = JExpr.invoke((String)javaMethodGet).ne(JExpr._null());
                ifFoundBody._if(valueIsNull.cand(fieldIsNotEmpty))._then().invoke(javaMethodSet).arg(JExpr._null());
                JBlock ifChangeBody = ifFoundBody._if(value._instanceof((JType)typeIterable))._then();
                JVar listInst = ifChangeBody.decl(8, (JType)listType, javaFieldName, (JExpression)JExpr._new((JType)listType));
                JCast iter = JExpr.cast((JType)typeIterable.narrow(this.codeModel.wildcard()), (JExpression)value);
                JForEach forEach = ifChangeBody.forEach((JType)typeObject, "cloudSdkItem", (JExpression)iter);
                JBlock ifString = forEach.body()._if(forEach.var()._instanceof((JType)typeString))._then();
                JInvocation enumLookup = enumDeserializer.arg((JExpression)JExpr.cast((JType)typeString, (JExpression)forEach.var()));
                JVar enumConstant = ifString.decl(8, (JType)javaType, "enumConstant", (JExpression)enumLookup);
                ifString.add((JStatement)listInst.invoke("add").arg((JExpression)enumConstant));
                JExpression valueChange = objectsEquals.arg((JExpression)listInst).arg((JExpression)JExpr.invoke((String)javaMethodGet)).not();
                ifChangeBody._if(valueChange)._then().invoke(javaMethodSet).arg((JExpression)listInst);
            } else {
                JBlock ifString = ifFoundBody._if(value._instanceof((JType)typeString).cor(valueIsNull))._then();
                JInvocation enumLookup = enumDeserializer.arg((JExpression)JExpr.cast((JType)typeString, (JExpression)value));
                JVar enumConstant = ifString.decl(8, (JType)javaType, javaFieldName, (JExpression)enumLookup);
                JExpression valueChange = objectsEquals.arg((JExpression)enumConstant).arg((JExpression)JExpr.invoke((String)javaMethodGet)).not();
                ifString._if(valueChange)._then().invoke(javaMethodSet).arg((JExpression)enumConstant);
            }
        } else if (isPrimitive) {
            if (isCollection) {
                JBlock ifChangeBody = ifFoundBody._if(value._instanceof((JType)typeIterable))._then();
                JVar listInst = ifChangeBody.decl(8, (JType)listType, javaFieldName, (JExpression)JExpr._new((JType)listType));
                JCast iter = JExpr.cast((JType)typeIterable.narrow(this.codeModel.wildcard()), (JExpression)value);
                JForEach forEach = ifChangeBody.forEach((JType)typeObject, "cloudSdkItem", (JExpression)iter);
                forEach.body().add((JStatement)listInst.invoke("add").arg((JExpression)JExpr.cast((JType)javaType, (JExpression)forEach.var())));
                ifChangeBody.invoke(javaMethodSet).arg((JExpression)listInst);
            } else {
                JExpression valueChanged = value.invoke("equals").arg((JExpression)JExpr.invoke((String)javaMethodGet)).not();
                JBlock ifChangedBody = ifFoundBody._if(valueIsNull.cor(valueChanged))._then();
                ifChangedBody.invoke(javaMethodSet).arg((JExpression)JExpr.cast((JType)javaType, (JExpression)value));
            }
        } else {
            if (isCollection) {
                JBlock ifValueIsList = ifFoundBody._if(value._instanceof((JType)typeIterable))._then();
                JVar listInst = ifValueIsList.decl(8, (JType)listType, javaFieldName, (JExpression)JExpr._new((JType)listType));
                JCast iter = JExpr.cast((JType)typeIterable.narrow(this.codeModel.wildcard()), (JExpression)value);
                JForEach forEach = ifValueIsList.forEach((JType)typeObject, "cloudSdkProperties", (JExpression)iter);
                JBlock isMap = forEach.body()._if(forEach.var()._instanceof((JType)this.codeModel.ref(Map.class)))._then();
                JVar item = isMap.decl(8, (JType)javaType, "cloudSdkItem", (JExpression)JExpr._new((JType)javaType));
                isMap.directStatement("@SuppressWarnings(\"unchecked\")");
                JCast castValueMap = JExpr.cast((JType)fieldMapClass, (JExpression)value);
                JVar varInputMap = isMap.decl(8, (JType)fieldMapClass, "inputMap", (JExpression)castValueMap);
                isMap.add((JStatement)item.invoke("fromMap").arg((JExpression)varInputMap));
                isMap.add((JStatement)listInst.invoke("add").arg((JExpression)item));
                ifValueIsList.invoke(javaMethodSet).arg((JExpression)listInst);
            } else {
                JBlock ifValueIsMap = ifFoundBody._if(value._instanceof((JType)this.codeModel.ref(Map.class)))._then();
                JBlock ifFieldIsEmpty = ifValueIsMap._if(JExpr.invoke((String)javaMethodGet).eq(JExpr._null()))._then();
                ifFieldIsEmpty.invoke(javaMethodSet).arg((JExpression)JExpr._new((JType)javaType));
                ifValueIsMap.directStatement("@SuppressWarnings(\"unchecked\")");
                JCast castValueMap = JExpr.cast((JType)fieldMapClass, (JExpression)value);
                JVar varInputMap = ifValueIsMap.decl(8, (JType)fieldMapClass, "inputMap", (JExpression)castValueMap);
                ifValueIsMap.invoke((JExpression)JExpr.invoke((String)javaMethodGet), "fromMap").arg((JExpression)varInputMap);
            }
            JExpression fieldIsNotEmpty = JExpr.invoke((String)javaMethodGet).ne(JExpr._null());
            ifFoundBody._if(valueIsNull.cand(fieldIsNotEmpty))._then().invoke(javaMethodSet).arg(JExpr._null());
        }
    }

    private void createMethodGetKey(Map<String, EntityPropertyModel> entityClassFields, JDefinedClass entityClass) {
        JClass oDataEntityKeyClass = this.codeModel.ref(ODataEntityKey.class);
        JMethod getKeyMethod = entityClass.method(2, (JType)oDataEntityKeyClass, "getKey");
        getKeyMethod.annotate(Nonnull.class);
        getKeyMethod.annotate(Override.class);
        JBlock body = getKeyMethod.body();
        JVar v = body.decl(8, (JType)oDataEntityKeyClass, "entityKey", (JExpression)JExpr._super().invoke("getKey"));
        for (Map.Entry<String, EntityPropertyModel> entry : entityClassFields.entrySet()) {
            if (!entry.getValue().isKeyField()) continue;
            String javaFieldName = entry.getValue().getJavaFieldName();
            String javaMethodName = "get" + StringUtils.capitalize((String)javaFieldName);
            body.invoke((JExpression)v, "addKeyProperty").arg(entry.getKey()).arg((JExpression)JExpr.invoke((String)javaMethodName));
        }
        body._return((JExpression)v);
    }

    private JPackage getOrGenerateNamespacePackage(String packageName) {
        JPackage namespacePackage = this.generatedNamespacePackages.get(packageName);
        if (namespacePackage == null) {
            namespacePackage = this.namespaceParentPackage.subPackage(packageName);
            this.generatedNamespacePackages.put(packageName, namespacePackage);
        }
        return namespacePackage;
    }

    void processUnboundOperation(ServiceClassGenerator serviceClassGenerator, Service service, Map<String, JDefinedClass> generatedEntities, Map<String, JDefinedClass> generatedComplexTypes, Map<String, JDefinedClass> generatedEnumTypes, Service.ServiceOperation unboundOperation, NamingContext entityClassNamingContext, NamingContext unboundOperationFetchMethodNamingContext, boolean isFunction) throws JClassAlreadyExistsException {
        JPackage namespacePackage = this.getOrGenerateNamespacePackage(service.getJavaPackageName());
        List<OperationParameterModel> parameters = this.processOperationParameters(namespacePackage, unboundOperation, false, generatedEntities, generatedComplexTypes, generatedEnumTypes);
        if (parameters == null) {
            return;
        }
        ServiceClassGenerator.ServiceClassAmplifier serviceClassAmplifier = serviceClassGenerator.getOrGenerateServiceClassesAndGetAmplifier(service);
        Service.Type edmReturnType = unboundOperation.getReturnType() != null ? unboundOperation.getReturnType().getType() : null;
        JClass javaReturnType = this.getOrGenerateClassForOperation(service, generatedEntities, generatedComplexTypes, generatedEnumTypes, edmReturnType, unboundOperation.getName(), null, entityClassNamingContext);
        if (javaReturnType == null) {
            return;
        }
        boolean isCollectionReturnType = edmReturnType != null ? unboundOperation.getReturnType().getMultiplicity() == Multiplicity.MANY : false;
        if (isFunction) {
            String functionImportName = unboundOperation.getName();
            String functionImportLabel = unboundOperation.getAnnotations().getLabel();
            String functionImportDescription = JavadocUtils.getCompleteDescription(unboundOperation);
            serviceClassAmplifier.addUnboundOperation(functionImportName, functionImportLabel, functionImportDescription, parameters, unboundOperationFetchMethodNamingContext, isCollectionReturnType, javaReturnType, true);
        } else {
            String actionImportName = unboundOperation.getName();
            String actionImportLabel = unboundOperation.getAnnotations().getLabel();
            String actionImportDescription = JavadocUtils.getCompleteDescription(unboundOperation);
            serviceClassAmplifier.addUnboundOperation(actionImportName, actionImportLabel, actionImportDescription, parameters, unboundOperationFetchMethodNamingContext, isCollectionReturnType, javaReturnType, false);
        }
    }

    private List<OperationParameterModel> processOperationParameters(JPackage namespacePackage, Service.ServiceOperation operation, boolean isBound, Map<String, JDefinedClass> generatedEntities, Map<String, JDefinedClass> generatedComplexTypes, Map<String, JDefinedClass> generatedEnumTypes) throws JClassAlreadyExistsException {
        LinkedList<OperationParameterModel> unboundOperationParameters = new LinkedList<OperationParameterModel>();
        NamingContext unboundOperationParameterNamingContext = new NamingContext();
        List<String> parameterList = operation.getParameterNames().stream().skip(isBound ? 1L : 0L).toList();
        for (String parameterName : parameterList) {
            Service.Parameter parameter = operation.getParameter(parameterName);
            Service.Type edmParameterType = parameter.getType();
            JType javaType = null;
            switch (edmParameterType.getKind()) {
                case PRIMITIVE: {
                    javaType = this.codeModel.ref(((Service.PrimitiveType)edmParameterType).getDefaultJavaType());
                    break;
                }
                case ENTITY: {
                    javaType = (JType)generatedEntities.get(edmParameterType.getName());
                    if (javaType != null) break;
                    logger.warn("Skipping operation {} generation as it contains entity parameter {} unassociated with an entity set.", (Object)operation.getName(), (Object)parameterName);
                    return null;
                }
                case COMPLEX: {
                    javaType = (JType)generatedComplexTypes.get(edmParameterType.getName());
                    if (javaType != null) break;
                    javaType = this.processComplexType(namespacePackage, generatedComplexTypes, generatedEnumTypes, (Service.ComplexType)edmParameterType);
                    generatedComplexTypes.put(edmParameterType.getName(), (JDefinedClass)javaType);
                    break;
                }
                case ENUM: {
                    javaType = (JType)generatedEnumTypes.get(edmParameterType.getName());
                    if (javaType != null) break;
                    javaType = this.processEnumType(namespacePackage, (Service.EnumType)edmParameterType);
                    generatedEnumTypes.put(edmParameterType.getName(), (JDefinedClass)javaType);
                }
            }
            if (parameter.getMultiplicity() == Multiplicity.MANY) {
                javaType = this.codeModel.ref(Collection.class).narrow(javaType);
            }
            String parameterLabel = parameter.getAnnotations().getLabel();
            String javaName = unboundOperationParameterNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaMethodParameterName(parameterName, parameterLabel));
            unboundOperationParameters.add(new OperationParameterModel(parameterName, edmParameterType.getName(), javaName, javaType, JavadocUtils.getDescriptionAndConstraints(parameterName, parameter), parameter.getFacets().isNullable()));
        }
        return unboundOperationParameters;
    }

    @Nonnull
    private JDefinedClass processComplexType(JPackage namespacePackage, Map<String, JDefinedClass> generatedComplexTypes, Map<String, JDefinedClass> generatedEnumTypes, Service.ComplexType complexTypeMetadata) throws JClassAlreadyExistsException {
        logger.info("  Found complex type " + complexTypeMetadata.getName());
        String complexTypeDescription = JavadocUtils.getCompleteDescription(complexTypeMetadata);
        NamingContext complexTypePropertyNamingContext = new NamingContext();
        complexTypePropertyNamingContext.loadGettersAndSettersOfClassAsAlreadyPresentFields(VdmComplex.class);
        Map<String, EntityPropertyModel> entityClassFields = this.processProperties(namespacePackage, generatedComplexTypes, generatedEnumTypes, complexTypeMetadata, complexTypePropertyNamingContext, new NamingContext());
        VdmObjectModel complexTypeModel = new VdmObjectModel(complexTypeMetadata.getName(), complexTypeMetadata.getFullyQualifiedName(), complexTypeMetadata.getAnnotations().getLabel(), null, complexTypeMetadata.getName(), entityClassFields, complexTypeDescription, false);
        return this.generateComplexTypeClass(namespacePackage, complexTypeModel);
    }

    @Nonnull
    private JDefinedClass processEnumType(JPackage namespacePackage, Service.EnumType enumTypeMetadata) throws JClassAlreadyExistsException {
        logger.info("  Found enum type " + enumTypeMetadata.getName());
        return this.generateEnumTypeClass(namespacePackage, enumTypeMetadata);
    }

    private Map<String, EntityPropertyModel> processProperties(JPackage namespacePackage, Map<String, JDefinedClass> generatedComplexTypes, Map<String, JDefinedClass> generatedEnumTypes, Service.StructuralType typeMetadata, NamingContext entityNamingContext, NamingContext entityClassConstantNamingContext) throws JClassAlreadyExistsException {
        LinkedHashMap<String, EntityPropertyModel> entityClassFields = new LinkedHashMap<String, EntityPropertyModel>();
        for (String propertyName : typeMetadata.getPropertyNames()) {
            Service.Property propertyMetadata = typeMetadata.getProperty(propertyName);
            Service.Type propertyType = propertyMetadata.getType();
            if (propertyType instanceof Service.PrimitiveType && !((Service.PrimitiveType)propertyType).isSupportedEdmType()) {
                logger.warn("Encountered unsupported property type {}", (Object)propertyType.getName());
                continue;
            }
            EntityPropertyModel entityPropertyModel = this.processProperty(namespacePackage, generatedComplexTypes, generatedEnumTypes, propertyMetadata, propertyType, propertyName, entityNamingContext, entityClassConstantNamingContext);
            entityClassFields.put(propertyName, entityPropertyModel);
        }
        return entityClassFields;
    }

    private EntityPropertyModel processProperty(JPackage namespacePackage, Map<String, JDefinedClass> generatedComplexTypes, Map<String, JDefinedClass> generatedEnumTypes, Service.Property propertyMetadata, Service.Type propertyType, String propertyName, NamingContext entityNamingContext, NamingContext entityClassConstantNamingContext) throws JClassAlreadyExistsException {
        TypeKind propertyKind = propertyType.getKind();
        String propertyBasicDescription = null;
        String propertyDetailedDescription = null;
        String propertyConstraintsDescription = null;
        String propertyLabel = null;
        Integer precision = null;
        Integer scale = null;
        propertyBasicDescription = JavadocUtils.getBasicDescription(propertyMetadata);
        propertyDetailedDescription = JavadocUtils.getDetailedDescription(propertyMetadata);
        propertyConstraintsDescription = JavadocUtils.getConstraints(propertyMetadata);
        propertyLabel = propertyMetadata.getAnnotations().getLabel();
        if (Objects.nonNull(propertyMetadata.getFacets())) {
            precision = propertyMetadata.getFacets().getPrecision();
            scale = propertyMetadata.getFacets().getScale();
        }
        String classFieldName = entityNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaFieldName(propertyName, propertyLabel));
        String classConstantName = entityClassConstantNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaConstantName(classFieldName, null));
        boolean isCollection = propertyMetadata.getMultiplicity() == Multiplicity.MANY;
        switch (propertyKind) {
            case PRIMITIVE: {
                Service.PrimitiveType primitiveType = (Service.PrimitiveType)propertyType;
                JClass javaFieldType = this.codeModel.ref(primitiveType.getDefaultJavaType());
                return new EntityPropertyModel(propertyName, propertyLabel, primitiveType.getName(), classFieldName, javaFieldType, classConstantName, true, isCollection, false, false, propertyBasicDescription, propertyDetailedDescription, propertyConstraintsDescription, precision, scale);
            }
            case COMPLEX: {
                Service.ComplexType complexType = (Service.ComplexType)propertyType;
                String complexTypeName = complexType.getName();
                JDefinedClass generatedComplexType = generatedComplexTypes.get(complexTypeName);
                if (generatedComplexType == null) {
                    generatedComplexType = this.processComplexType(namespacePackage, generatedComplexTypes, generatedEnumTypes, complexType);
                    generatedComplexTypes.put(complexTypeName, generatedComplexType);
                }
                return new EntityPropertyModel(propertyName, propertyLabel, complexType.getName(), classFieldName, (JClass)generatedComplexType, classConstantName, false, isCollection, false, false, propertyBasicDescription, propertyDetailedDescription, propertyConstraintsDescription, precision, scale);
            }
            case ENUM: {
                Service.EnumType enumType = (Service.EnumType)propertyType;
                String enumTypeName = enumType.getName();
                JDefinedClass generatedEnumType = generatedEnumTypes.get(enumTypeName);
                if (generatedEnumType == null) {
                    generatedEnumType = this.processEnumType(namespacePackage, enumType);
                    generatedEnumTypes.put(enumTypeName, generatedEnumType);
                }
                return new EntityPropertyModel(propertyName, propertyLabel, enumType.getFullyQualifiedName(), classFieldName, (JClass)generatedEnumType, classConstantName, false, isCollection, true, false, propertyBasicDescription, propertyDetailedDescription, propertyConstraintsDescription, precision, scale);
            }
        }
        logger.error(String.format("    Unsupported type detected:\n      property name: %s, type: %s", new Object[]{propertyName, propertyType.getKind()}));
        return null;
    }

    @Nonnull
    PreparedEntityBluePrint processEntity(JPackage namespacePackage, Map<String, JDefinedClass> generatedComplexTypes, Map<String, JDefinedClass> generatedEnumTypes, Service.EntityType entityType, @Nullable String entitySetName, NamingContext entityClassNamingContext) throws JClassAlreadyExistsException {
        String entityTypeName = entityType.getName();
        String entityTypeLabel = entityType.getAnnotations().getLabel();
        String entityDescription = JavadocUtils.getCompleteDescription(entityType);
        String javaClassName = entityClassNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaClassName(entityTypeName, entityTypeLabel));
        NamingContext entityPropertyNamingContext = new NamingContext(new LowercaseNameFormattingStrategy());
        entityPropertyNamingContext.loadGettersAndSettersOfClassAsAlreadyPresentFields(VdmEntity.class);
        entityPropertyNamingContext.loadKnownGeneratedFields();
        NamingContext entityClassConstantNamingContext = new NamingContext();
        Map<String, EntityPropertyModel> entityClassFields = this.processProperties(namespacePackage, generatedComplexTypes, generatedEnumTypes, entityType, entityPropertyNamingContext, entityClassConstantNamingContext);
        VdmObjectModel entityModel = new VdmObjectModel(entityTypeName, entityType.getFullyQualifiedName(), entityTypeLabel, entitySetName, javaClassName, entityClassFields, entityDescription, entityType.hasMediaStream());
        List<EntityPropertyModel> keyProperties = this.processKeyProperties(entityType, entityClassFields);
        List<NavigationPropertyModel> navigationProperties = this.processNavigationProperties(entityType, entityPropertyNamingContext, entityClassConstantNamingContext);
        ClassGeneratorResult result = this.generateEdmEntityClass(namespacePackage, entityModel);
        return new PreparedEntityBluePrint(result.getGeneratedEntityClass(), navigationProperties, keyProperties);
    }

    Option<PreparedEntityBluePrint> processEntitySet(ServiceClassGenerator serviceClassGenerator, Service service, Map<String, JDefinedClass> generatedEntities, Map<String, JDefinedClass> generatedComplexTypes, Map<String, JDefinedClass> generatedEnumTypes, Service.EntitySet entitySet, NamingContext entityClassNamingContext) throws JClassAlreadyExistsException {
        Option maybeGeneratedBlueprint;
        JDefinedClass entityClass;
        Service.EntityType entityType = entitySet.getEntityType();
        String entityTypeName = entityType.getName();
        JPackage namespacePackage = this.getOrGenerateNamespacePackage(service.getJavaPackageName());
        logger.info("  Found entity type " + entityTypeName + " from set " + entitySet.getName());
        if (!generatedEntities.containsKey(entityTypeName)) {
            PreparedEntityBluePrint entityBlueprint = this.processEntity(namespacePackage, generatedComplexTypes, generatedEnumTypes, entityType, entitySet.getName(), entityClassNamingContext);
            entityClass = entityBlueprint.getEntityClass();
            generatedEntities.put(entityTypeName, entityClass);
            this.entityBluePrintMap.put(entityTypeName, entityBlueprint);
            maybeGeneratedBlueprint = Option.some((Object)entityBlueprint);
        } else {
            logger.info("Model class for entity type " + entityTypeName + " has already been generated. Proceeding with generating the service methods.");
            entityClass = generatedEntities.get(entityTypeName);
            maybeGeneratedBlueprint = Option.none();
        }
        if (this.generatePojosOnly) {
            return maybeGeneratedBlueprint;
        }
        ServiceClassGenerator.ServiceClassAmplifier serviceClassAmplifier = serviceClassGenerator.getOrGenerateServiceClassesAndGetAmplifier(service);
        if (maybeGeneratedBlueprint.isDefined()) {
            this.addDefaultServicePathMethod(entityClass, serviceClassAmplifier.getServiceInterfaceClass(), service);
        }
        if (maybeGeneratedBlueprint.isEmpty() && !this.serviceMethodsPerEntitySet) {
            return maybeGeneratedBlueprint;
        }
        Collection<ApiFunction> allowedFunctions = service.getAllowedFunctionsByEntity(entitySet.getName());
        if (allowedFunctions != null && !allowedFunctions.isEmpty()) {
            List entityKeyProperties = (List)maybeGeneratedBlueprint.map(PreparedEntityBluePrint::getKeyProperties).getOrElse(() -> (List)Option.of((Object)this.entityBluePrintMap.get(entityType.getName())).map(PreparedEntityBluePrint::getKeyProperties).getOrElse(Collections::emptyList));
            this.addAllowedFunctions(serviceClassAmplifier, new EntityMetadata(namespacePackage, entityClass, entitySet.getName()), allowedFunctions, entityKeyProperties);
        }
        return maybeGeneratedBlueprint;
    }

    private void addDefaultServicePathMethod(JDefinedClass generatedEntityClass, JDefinedClass serviceInterfaceClass, Service service) {
        JMethod defaultServicePathMethod = generatedEntityClass.method(2, String.class, "getDefaultServicePath");
        defaultServicePathMethod.annotate(Override.class);
        DeprecationUtils.addGetDefaultServicePathBody(defaultServicePathMethod, serviceInterfaceClass, service);
    }

    private void addAllowedFunctions(ServiceClassGenerator.ServiceClassAmplifier serviceClassAmplifier, EntityMetadata entityMetadata, Collection<ApiFunction> allowedFunctions, Iterable<EntityPropertyModel> keyProperties) {
        Collection<Object> functionsToAdd = allowedFunctions.isEmpty() ? Collections.emptyList() : EnumSet.copyOf(allowedFunctions);
        for (ApiFunction apiFunction : functionsToAdd) {
            this.addFunction(serviceClassAmplifier, entityMetadata, apiFunction, keyProperties);
        }
    }

    private void addFunction(ServiceClassGenerator.ServiceClassAmplifier serviceClassAmplifier, EntityMetadata entityMetadata, ApiFunction function, Iterable<EntityPropertyModel> keyProperties) {
        switch (function) {
            case READ: {
                serviceClassAmplifier.addGetAllMethod(entityMetadata);
                serviceClassAmplifier.addCountMethod(entityMetadata);
                break;
            }
            case READ_BY_KEY: {
                String getByKeyMethodName = serviceClassAmplifier.getByKeyMethodName(entityMetadata);
                keyProperties = serviceClassAmplifier.getRefinedKeyProperties(getByKeyMethodName, keyProperties);
                serviceClassAmplifier.addGetByKeyMethod(entityMetadata, getByKeyMethodName, keyProperties);
                break;
            }
            case CREATE: {
                serviceClassAmplifier.addCreateMethod(entityMetadata);
                break;
            }
            case UPDATE: {
                serviceClassAmplifier.addUpdateMethod(entityMetadata);
                break;
            }
            case DELETE: {
                serviceClassAmplifier.addDeleteMethod(entityMetadata);
                break;
            }
            case NAVIGATE: {
                entityMetadata.getGeneratedEntityClass()._implements(VdmEntitySet.class);
                break;
            }
            default: {
                throw new ODataGeneratorException("Found unknown ApiFunction: " + String.valueOf((Object)function));
            }
        }
    }

    private List<EntityPropertyModel> processKeyProperties(Service.EntityType typeMetadata, Map<String, EntityPropertyModel> entityClassFields) {
        LinkedList<EntityPropertyModel> keyProperties = new LinkedList<EntityPropertyModel>();
        for (String keyPropertyName : typeMetadata.getKeyPropertyNames()) {
            EntityPropertyModel propertyMapping = entityClassFields.get(keyPropertyName);
            if (propertyMapping != null) {
                propertyMapping.setKeyField(true);
                keyProperties.add(propertyMapping);
                continue;
            }
            logger.error("Key property " + keyPropertyName + " was not found in the set of processed properties.");
        }
        return keyProperties;
    }

    private List<NavigationPropertyModel> processNavigationProperties(Service.EntityType entityType, NamingContext entityPropertyNamingContext, NamingContext entityClassConstantNamingContext) {
        LinkedList<NavigationPropertyModel> navigationPropertyMappings = new LinkedList<NavigationPropertyModel>();
        NamingContext navPropertiesNamingContext = new NamingContext();
        NamingContext builderMethodNamingContext = new NamingContext();
        for (String navigationPropertyName : entityType.getNavigationPropertyNames()) {
            Service.NavigationProperty navigationProperty = entityType.getNavigationProperty(navigationPropertyName);
            String javaMemberName = entityPropertyNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaNavigationPropertyFieldName(navigationPropertyName));
            String javaConstantName = entityClassConstantNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaNavigationPropertyConstantName(navigationPropertyName));
            String javaMethodBaseName = navPropertiesNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaMethodName(navigationPropertyName));
            String javaBuilderMethodName = builderMethodNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaBuilderMethodName(navigationPropertyName));
            navigationPropertyMappings.add(new NavigationPropertyModel(navigationPropertyName, (Service.EntityType)navigationProperty.getType(), navigationProperty.getMultiplicity(), javaMemberName, javaConstantName, NamingUtils.deriveJavaFetchMethodName((String)javaMethodBaseName), NamingUtils.deriveJavaGetIfPresentMethodName((String)javaMethodBaseName), NamingUtils.deriveJavaGetOrFetchMethodName((String)javaMethodBaseName), NamingUtils.deriveJavaAddMethodName((String)javaMethodBaseName), NamingUtils.deriveJavaSetMethodName((String)javaMethodBaseName), javaBuilderMethodName));
        }
        return navigationPropertyMappings;
    }

    Option<String> getQualifiedEntityClassName(@Nonnull String entitySetName) {
        return this.entityBluePrintMap.containsKey(entitySetName) ? Option.some((Object)this.entityBluePrintMap.get(entitySetName).getEntityClass().fullName()) : Option.none();
    }

    void processBoundOperation(Service service, Map<String, JDefinedClass> generatedEntities, Map<String, JDefinedClass> generatedComplexTypes, Map<String, JDefinedClass> generatedEnumTypes, Service.ServiceBoundOperation serviceBoundOperation, NamingContext entityClassNamingContext) throws JClassAlreadyExistsException {
        EdmOperation operation = serviceBoundOperation.getOperation();
        boolean isFunction = serviceBoundOperation.isFunction();
        boolean hasReturnType = serviceBoundOperation.getReturnType() != null;
        Service.Type returnType = hasReturnType ? serviceBoundOperation.getReturnType().getType() : null;
        boolean isReturnTypeCollection = hasReturnType && operation.getReturnType().isCollection();
        boolean isBoundToCollection = operation.isBindingParameterTypeCollection();
        boolean isComposable = isFunction && ((EdmFunction)operation).isComposable();
        JPackage namespacePackage = this.getOrGenerateNamespacePackage(service.getJavaPackageName());
        List<OperationParameterModel> parameterModels = this.processOperationParameters(namespacePackage, serviceBoundOperation, true, generatedEntities, generatedComplexTypes, generatedEnumTypes);
        if (parameterModels == null) {
            return;
        }
        String methodName = this.codeNamingStrategy.generateJavaOperationMethodName(serviceBoundOperation.getName(), serviceBoundOperation.getAnnotations().getLabel());
        JDefinedClass javaBindingType = generatedEntities.get(operation.getBindingParameterTypeFqn().getName());
        if (javaBindingType == null) {
            logger.warn("Operation {} bound to type {} will be skipped: Type is not an entity or entity is not part of an entity set.", (Object)operation.getName(), (Object)operation.getBindingParameterTypeFqn());
            return;
        }
        List boundOperationFactoryMethods = this.classScanner.determineArgumentsForMethod(javaBindingType.fullName(), methodName, parameterModels, OperationParameterModel::getJavaName);
        JClass javaReturnType = this.getOrGenerateClassForOperation(service, generatedEntities, generatedComplexTypes, generatedEnumTypes, returnType, operation.getName(), operation.getEntitySetPath(), entityClassNamingContext);
        if (javaReturnType == null) {
            return;
        }
        Class<?> operationClass = isFunction ? BoundOperationGenerator.getFunctionClass(isBoundToCollection, isReturnTypeCollection, Objects.requireNonNull(returnType).getKind(), isComposable) : BoundOperationGenerator.getActionClass(isBoundToCollection, isReturnTypeCollection);
        JClass operationClassWithGenerics = this.codeModel.ref(operationClass).narrow(new JClass[]{javaBindingType, javaReturnType});
        for (List paramList : boundOperationFactoryMethods) {
            JMethod method = javaBindingType.method(17, (JType)operationClassWithGenerics, methodName);
            method.annotate(Nonnull.class);
            method.javadoc().add((Object)JavadocUtils.getCompleteDescription(serviceBoundOperation));
            method.javadoc().add((Object)BoundOperationGenerator.getJavadocDescriptionForOperation(isFunction, isBoundToCollection));
            method.javadoc().addReturn().add((Object)BoundOperationGenerator.getJavadocReturnForOperation(isFunction, isBoundToCollection));
            HashMap<String, JVar> generatedParameters = new HashMap<String, JVar>();
            for (OperationParameterModel param : paramList) {
                JVar parameter = method.param(8, param.getJavaType(), param.getJavaName());
                parameter.annotate(param.isNullable() ? Nullable.class : Nonnull.class);
                JCommentPart parameterJavadoc = method.javadoc().addParam(parameter);
                parameterJavadoc.add((Object)param.getDescription());
                generatedParameters.put(param.getEdmName(), parameter);
            }
            JClass keyType = this.codeModel.ref(String.class);
            JClass valueType = this.codeModel.ref(Object.class);
            JVar parameterMap = generatedParameters.isEmpty() ? method.body().decl(8, (JType)this.codeModel.ref(Map.class).narrow(new JClass[]{keyType, valueType}), "parameters", (JExpression)this.codeModel.ref(Collections.class).staticInvoke("emptyMap")) : method.body().decl(8, (JType)this.codeModel.ref(Map.class).narrow(new JClass[]{keyType, valueType}), "parameters", (JExpression)JExpr._new((JClass)this.codeModel.ref(HashMap.class).narrow(new JClass[]{keyType, valueType})));
            for (OperationParameterModel param : paramList) {
                method.body().add((JStatement)parameterMap.invoke("put").arg(param.getEdmName()).arg((JExpression)generatedParameters.get(param.getEdmName())));
            }
            JInvocation returnStatement = JExpr._new((JClass)operationClassWithGenerics).arg(javaBindingType.dotclass()).arg(javaReturnType.dotclass()).arg(operation.getFullQualifiedName().getFullQualifiedNameAsString()).arg((JExpression)parameterMap);
            method.body()._return((JExpression)returnStatement);
        }
    }

    private JClass getOrGenerateClassForOperation(@Nonnull Service service, @Nonnull Map<String, JDefinedClass> generatedEntities, @Nonnull Map<String, JDefinedClass> generatedComplexTypes, @Nonnull Map<String, JDefinedClass> generatedEnumTypes, @Nullable Service.Type edmType, @Nonnull String operationName, @Nullable String entitySetPath, @Nonnull NamingContext entityClassNamingContext) {
        JClass javaReturnType;
        if (edmType == null) {
            return this.codeModel.ref(Void.class);
        }
        switch (edmType.getKind()) {
            case PRIMITIVE: {
                Service.PrimitiveType edmSimpleReturnType = (Service.PrimitiveType)edmType;
                javaReturnType = this.codeModel.ref(edmSimpleReturnType.getDefaultJavaType());
                break;
            }
            case COMPLEX: {
                JDefinedClass generatedComplexType;
                javaReturnType = (JClass)generatedComplexTypes.get(edmType.getName());
                if (javaReturnType != null) break;
                JPackage namespacePackage = this.getOrGenerateNamespacePackage(service.getJavaPackageName());
                Service.ComplexType edmComplexReturnType = (Service.ComplexType)edmType;
                try {
                    generatedComplexType = this.processComplexType(namespacePackage, generatedComplexTypes, generatedEnumTypes, edmComplexReturnType);
                }
                catch (JClassAlreadyExistsException e) {
                    throw new IllegalStateException("Complex type " + edmType.getName() + " not found among generated complex types, but class already exists.", e);
                }
                generatedComplexTypes.put(edmType.getName(), generatedComplexType);
                javaReturnType = generatedComplexType;
                break;
            }
            case ENTITY: {
                PreparedEntityBluePrint childEntityBluePrint;
                javaReturnType = (JClass)generatedEntities.get(edmType.getName());
                if (javaReturnType != null) break;
                JPackage namespacePackage = this.getOrGenerateNamespacePackage(service.getJavaPackageName());
                Service.EntityType edmEntityReturnType = (Service.EntityType)edmType;
                try {
                    childEntityBluePrint = this.processEntity(namespacePackage, generatedComplexTypes, generatedEnumTypes, edmEntityReturnType, entitySetPath != null ? entitySetPath : operationName, entityClassNamingContext);
                    generatedEntities.put(edmType.getName(), childEntityBluePrint.getEntityClass());
                    this.addNavigationPropertyCode(childEntityBluePrint, generatedEntities, generatedComplexTypes, generatedEnumTypes, entityClassNamingContext);
                }
                catch (JClassAlreadyExistsException e) {
                    throw new IllegalStateException("Entity type " + edmType.getName() + " not found among generated entities, but class already exists.", e);
                }
                javaReturnType = childEntityBluePrint.getEntityClass();
                break;
            }
            default: {
                logger.error("Unsupported EDM return type {} found for operation {}. Skipping the operation.", (Object)edmType.getKind(), (Object)operationName);
                return null;
            }
        }
        return javaReturnType;
    }

    public static final class ClassGeneratorResult {
        @Nonnull
        final JDefinedClass generatedEntityClass;

        @Generated
        public ClassGeneratorResult(@Nonnull JDefinedClass generatedEntityClass) {
            if (generatedEntityClass == null) {
                throw new NullPointerException("generatedEntityClass is marked non-null but is null");
            }
            this.generatedEntityClass = generatedEntityClass;
        }

        @Nonnull
        @Generated
        public JDefinedClass getGeneratedEntityClass() {
            return this.generatedEntityClass;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassGeneratorResult)) {
                return false;
            }
            ClassGeneratorResult other = (ClassGeneratorResult)o;
            JDefinedClass this$generatedEntityClass = this.getGeneratedEntityClass();
            JDefinedClass other$generatedEntityClass = other.getGeneratedEntityClass();
            return !(this$generatedEntityClass == null ? other$generatedEntityClass != null : !this$generatedEntityClass.equals(other$generatedEntityClass));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JDefinedClass $generatedEntityClass = this.getGeneratedEntityClass();
            result = result * 59 + ($generatedEntityClass == null ? 43 : $generatedEntityClass.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "NamespaceClassGenerator.ClassGeneratorResult(generatedEntityClass=" + String.valueOf(this.getGeneratedEntityClass()) + ")";
        }
    }
}

