/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty;
import com.sap.cloud.sdk.datamodel.odatav4.generator.AnnotationHelper;
import com.sap.cloud.sdk.datamodel.odatav4.generator.EntityPropertyModel;
import com.sap.cloud.sdk.datamodel.odatav4.generator.JavadocUtils;
import com.sap.cloud.sdk.datamodel.odatav4.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Multiplicity;
import com.sap.cloud.sdk.datamodel.odatav4.generator.NavigationPropertyModel;
import com.sap.cloud.sdk.datamodel.odatav4.generator.NavigationPropertyModelAnnotationWrapper;
import com.sap.cloud.sdk.datamodel.odatav4.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.AnnotationStrategy;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.vavr.control.Option;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.slf4j.Logger;

class NavigationPropertyMethodsGenerator {
    private static final Logger logger = MessageCollector.getLogger(NavigationPropertyMethodsGenerator.class);
    private final JCodeModel codeModel;
    private final JDefinedClass entityClass;

    NavigationPropertyMethodsGenerator(JCodeModel codeModel, JDefinedClass entityClass) {
        this.codeModel = codeModel;
        this.entityClass = entityClass;
    }

    @Nonnull
    Map<String, JFieldVar> createNavigationPropertyFields(Iterable<NavigationPropertyModel> navigationProperties, Map<String, JDefinedClass> generatedEntities, AnnotationStrategy annotationStrategy) {
        HashMap<String, JFieldVar> navigationPropertyFields = new HashMap<String, JFieldVar>();
        for (NavigationPropertyModel navigationProperty : navigationProperties) {
            JDefinedClass associatedEntity = this.getAssociatedEntity(navigationProperty, generatedEntities);
            if (associatedEntity == null) continue;
            navigationPropertyFields.put(navigationProperty.getEdmName(), this.createNavigationPropertyField(navigationProperty, associatedEntity, annotationStrategy));
        }
        return navigationPropertyFields;
    }

    void addNavigationPropertyMethods(Map<String, JDefinedClass> generatedEntities, List<EntityPropertyModel> keyProperties, Iterable<NavigationPropertyModel> navigationProperties, Map<String, JFieldVar> generatedNavigationPropertyFields) {
        JClass mapType = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        List fromMapContents = this.entityClass.getMethod("fromMap", new JType[]{mapType}).body().getContents();
        Object statementBeforeSuper = fromMapContents.get(fromMapContents.size() - 2);
        JBlock fromMapBlock = statementBeforeSuper instanceof JBlock ? (JBlock)statementBeforeSuper : null;
        JClass fieldMapClass = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        JMethod toMapOfNavigationPropertiesMethod = this.entityClass.method(2, (JType)fieldMapClass, "toMapOfNavigationProperties");
        toMapOfNavigationPropertiesMethod.annotate(Nonnull.class);
        toMapOfNavigationPropertiesMethod.annotate(Override.class);
        JVar valuesMap = toMapOfNavigationPropertiesMethod.body().decl(8, (JType)fieldMapClass, "cloudSdkValues", (JExpression)JExpr._super().invoke("toMapOfNavigationProperties"));
        for (NavigationPropertyModel navigationProperty : navigationProperties) {
            JFieldVar navigationPropertyField = generatedNavigationPropertyFields.get(navigationProperty.getEdmName());
            JDefinedClass associatedEntity = this.getAssociatedEntity(navigationProperty, generatedEntities);
            if (navigationPropertyField == null || associatedEntity == null) continue;
            this.addNavigationPropertyLogic(navigationPropertyField, mapType, toMapOfNavigationPropertiesMethod, fromMapBlock, navigationProperty, associatedEntity);
            navigationPropertyField.annotate(Getter.class).param("value", (JExpression)this.codeModel.ref(AccessLevel.class).staticRef("NONE"));
            navigationPropertyField.annotate(Setter.class).param("value", (JExpression)this.codeModel.ref(AccessLevel.class).staticRef("NONE"));
        }
        toMapOfNavigationPropertiesMethod.body()._return((JExpression)valuesMap);
    }

    @Nullable
    private JDefinedClass getAssociatedEntity(NavigationPropertyModel navigationProperty, Map<String, JDefinedClass> generatedEntities) {
        JDefinedClass associatedEntity = generatedEntities.get(navigationProperty.getReturnEntityType().getName());
        if (associatedEntity == null) {
            logger.warn("Unable to generate code for navigation property " + navigationProperty.getEdmName() + " of entity " + this.entityClass.name() + ":  Associated entity type " + navigationProperty.getReturnEntityType().getName() + " is either not found or its entity set has been filtered out.");
        }
        return associatedEntity;
    }

    private JFieldVar createNavigationPropertyField(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, AnnotationStrategy annotationStrategy) {
        boolean isOneToMany = navigationProperty.getMultiplicity() == Multiplicity.MANY;
        Object returnType = isOneToMany ? this.codeModel.ref(List.class).narrow((JClass)associatedEntity) : associatedEntity;
        JFieldVar navigationPropertyField = this.createClassMember(navigationProperty, associatedEntity, isOneToMany, (JClass)returnType, annotationStrategy);
        this.changeBuilder(navigationProperty, associatedEntity, isOneToMany, navigationPropertyField);
        return navigationPropertyField;
    }

    private void addNavigationPropertyLogic(JFieldVar navigationPropertyField, JClass mapType, JMethod toMapOfNavigationPropertiesMethod, JBlock fromMapBlock, NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity) {
        boolean isOneToMany = navigationProperty.getMultiplicity() == Multiplicity.MANY;
        JType returnType = navigationPropertyField.type();
        this.createNavigationPropertyConstant(navigationProperty, associatedEntity, isOneToMany);
        if (fromMapBlock != null) {
            this.handleFromMapAdditions(mapType, fromMapBlock, navigationProperty, associatedEntity, isOneToMany, navigationPropertyField);
        }
        this.createGetIfPresentMethod(navigationProperty, associatedEntity, isOneToMany, returnType, (JExpression)navigationPropertyField);
        this.createSetterMethod(navigationProperty, associatedEntity, isOneToMany, returnType, (JAssignmentTarget)navigationPropertyField);
        if (isOneToMany) {
            this.createAddMethod(navigationProperty, associatedEntity, (JAssignmentTarget)navigationPropertyField);
        }
        this.addIfAndPutStatementToNavigationPropertiesMap(toMapOfNavigationPropertiesMethod, navigationProperty, navigationPropertyField);
    }

    private void addIfAndPutStatementToNavigationPropertiesMap(JMethod toMapOfNavigationPropertiesMethod, NavigationPropertyModel navigationProperty, JFieldVar propField) {
        JBlock body = toMapOfNavigationPropertiesMethod.body();
        body._if(propField.ne(JExpr._null()))._then().invoke(JExpr.direct((String)"cloudSdkValues"), "put").arg(navigationProperty.getEdmName()).arg((JExpression)propField);
    }

    private void createAddMethod(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, JAssignmentTarget propField) {
        String addToName = navigationProperty.getJavaMethodNameAdd();
        JMethod addToMethod = this.entityClass.method(1, (JType)this.codeModel.VOID, addToName);
        JVar entity = addToMethod.varParam((JType)associatedEntity, "entity");
        addToMethod.javadoc().add((Object)String.format("Adds elements to the list of associated <b>%s</b> entities. This corresponds to the OData navigation property <b>%s</b>.", associatedEntity.name(), navigationProperty.getEdmName()));
        addToMethod.javadoc().add((Object)JavadocUtils.getLazyWarningMessage(navigationProperty, this.entityClass));
        addToMethod.javadoc().addParam(entity).add((Object)String.format("Array of <b>%s</b> entities.", associatedEntity.name()));
        addToMethod.body()._if(propField.eq(JExpr._null()))._then().assign(propField, (JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList"));
        addToMethod.body().invoke((JExpression)propField, "addAll").arg((JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList").arg((JExpression)entity));
    }

    private void createSetterMethod(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JType returnType, JAssignmentTarget propField) {
        if (isOneToMany) {
            String setterName = navigationProperty.getJavaMethodNameSet();
            JMethod setterMethod = this.entityClass.method(1, (JType)this.codeModel.VOID, setterName);
            setterMethod.javadoc().add((Object)String.format("Overwrites the list of associated <b>%s</b> entities for the loaded navigation property <b>%s</b>.", associatedEntity.name(), navigationProperty.getEdmName()));
            setterMethod.javadoc().add((Object)JavadocUtils.getLazyWarningMessage(navigationProperty, this.entityClass));
            JVar setterParam = setterMethod.param(8, returnType, "cloudSdkValue");
            setterMethod.javadoc().addParam(setterParam).add((Object)String.format("List of <b>%s</b> entities.", associatedEntity.name()));
            setterParam.annotate(Nonnull.class);
            JBlock setterBody = setterMethod.body();
            setterBody._if(propField.eq(JExpr._null()))._then().assign(propField, (JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList"));
            setterBody.invoke((JExpression)propField, "clear");
            setterBody.invoke((JExpression)propField, "addAll").arg((JExpression)setterParam);
        } else {
            String setterName = navigationProperty.getJavaMethodNameSet();
            JMethod setterMethod = this.entityClass.method(1, (JType)this.codeModel.VOID, setterName);
            setterMethod.javadoc().add((Object)String.format("Overwrites the associated <b>%s</b> entity for the loaded navigation property <b>%s</b>.", associatedEntity.name(), navigationProperty.getEdmName()));
            JVar setterParam = setterMethod.param(8, returnType, "cloudSdkValue");
            setterMethod.javadoc().addParam(setterParam).add((Object)String.format("New <b>%s</b> entity.", associatedEntity.name()));
            JBlock setterBody = setterMethod.body();
            setterBody.assign(propField, (JExpression)setterParam);
        }
    }

    private void createGetIfPresentMethod(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JType returnType, JExpression propField) {
        String getterIfPresentName = navigationProperty.getJavaMethodNameGetIfPresent();
        JMethod getterIfPresentMethod = this.entityClass.method(1, (JType)this.codeModel.ref(Option.class).narrow(returnType), getterIfPresentName);
        getterIfPresentMethod.annotate(Nonnull.class);
        getterIfPresentMethod.javadoc().add((Object)String.format("Retrieval of associated <b>%s</b> %s. This corresponds to the OData navigation property <b>%s</b>.\n<p>\nIf the navigation property for an entity <b>%s</b> has not been resolved yet, this method will <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.", associatedEntity.name(), isOneToMany ? "entities (one to many)" : "entity (one to one)", navigationProperty.getEdmName(), this.entityClass.name()));
        getterIfPresentMethod.javadoc().addReturn().add((Object)String.format("If the information for navigation property <b>%s</b> is already loaded, the result will contain the <b>%s</b> %s. If not, an <code>Option</code> with result state <code>empty</code> is returned.", navigationProperty.getEdmName(), associatedEntity.name(), isOneToMany ? "entities" : "entity"));
        getterIfPresentMethod.body()._return((JExpression)this.codeModel.ref(Option.class).staticInvoke("of").arg(propField));
    }

    private JFieldVar createNavigationPropertyConstant(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany) {
        String navPropertyConstantName = navigationProperty.getJavaConstantName();
        JClass navPropertyType = isOneToMany ? this.codeModel.ref(NavigationProperty.Collection.class).narrow(new JClass[]{this.entityClass, associatedEntity}) : this.codeModel.ref(NavigationProperty.Single.class).narrow(new JClass[]{this.entityClass, associatedEntity});
        JInvocation initLink = JExpr._new((JClass)navPropertyType).arg(this.entityClass.dotclass()).arg(navigationProperty.getEdmName()).arg(associatedEntity.dotclass());
        JFieldVar navPropertyConstantField = this.entityClass.field(25, (JType)navPropertyType, navPropertyConstantName, (JExpression)initLink);
        navPropertyConstantField.javadoc().add((Object)String.format("Use with available request builders to apply the <b>%s</b> navigation property to query operations.", navigationProperty.getEdmName()));
        return navPropertyConstantField;
    }

    private JFieldVar createClassMember(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JClass returnType, AnnotationStrategy annotationStrategy) {
        String classMemberName = navigationProperty.getJavaMemberName();
        JFieldVar propField = this.entityClass.field(4, (JType)returnType, classMemberName);
        NavigationPropertyModelAnnotationWrapper annotationModel = new NavigationPropertyModelAnnotationWrapper(navigationProperty);
        AnnotationHelper.addAllAnnotationsToJavaItem(annotationStrategy.getAnnotationsForAssociatedEntity(annotationModel), (JAnnotatable)propField);
        propField.javadoc().add((Object)String.format("Navigation property <b>%s</b> for <b>%s</b> to %s <b>%s</b>.", navigationProperty.getEdmName(), this.entityClass.name(), isOneToMany ? "multiple" : "single", associatedEntity.name()));
        return propField;
    }

    private void handleFromMapAdditions(JClass mapType, JBlock fromMapBlock, NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JFieldVar propField) {
        JFieldVar recursiveCallTarget;
        JVar recursiveCallSource;
        JBlock recursiveCallContainer;
        JBlock foundValueBlock = fromMapBlock._if((JExpression)JExpr.direct((String)"cloudSdkValues").invoke("containsKey").arg(navigationProperty.getEdmName()))._then();
        JVar newValue = foundValueBlock.decl(8, (JType)this.codeModel.ref(Object.class), "cloudSdkValue", (JExpression)JExpr.direct((String)"cloudSdkValues").invoke("remove").arg(navigationProperty.getEdmName()));
        if (isOneToMany) {
            JBlock isIterableBlock = foundValueBlock._if(newValue._instanceof((JType)this.codeModel.ref(Iterable.class)))._then();
            JConditional isNullCheck = isIterableBlock._if(propField.eq(JExpr._null()));
            isNullCheck._then().assign((JAssignmentTarget)propField, (JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList"));
            isNullCheck._else().assign((JAssignmentTarget)propField, (JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList").arg((JExpression)propField));
            JVar varI = isIterableBlock.decl((JType)this.codeModel.INT, "i", JExpr.lit((int)0));
            JForEach forEach = isIterableBlock.forEach((JType)this.codeModel.ref(Object.class), "item", (JExpression)JExpr.cast((JType)this.codeModel.ref(Iterable.class).narrow(this.codeModel.wildcard()), (JExpression)newValue));
            recursiveCallContainer = forEach.body();
            recursiveCallSource = forEach.var();
            recursiveCallContainer._if(recursiveCallSource._instanceof((JType)this.codeModel.ref(Map.class)).not())._then()._continue();
            recursiveCallTarget = recursiveCallContainer.decl((JType)associatedEntity, "entity");
            JConditional foundElement = recursiveCallContainer._if(propField.invoke("size").gt((JExpression)varI));
            JBlock foundElementBlock = foundElement._then();
            foundElementBlock.assign((JAssignmentTarget)recursiveCallTarget, (JExpression)propField.invoke("get").arg((JExpression)varI));
            JBlock notFoundBlock = foundElement._else();
            notFoundBlock.assign((JAssignmentTarget)recursiveCallTarget, (JExpression)JExpr._new((JClass)associatedEntity));
            notFoundBlock.invoke((JExpression)propField, "add").arg((JExpression)recursiveCallTarget);
            recursiveCallContainer.assign((JAssignmentTarget)varI, varI.plus(JExpr.lit((int)1)));
        } else {
            recursiveCallContainer = foundValueBlock._if(newValue._instanceof((JType)this.codeModel.ref(Map.class)))._then();
            recursiveCallContainer._if(propField.eq(JExpr._null()))._then().assign((JAssignmentTarget)propField, (JExpression)JExpr._new((JClass)associatedEntity));
            recursiveCallTarget = propField;
            recursiveCallSource = newValue;
        }
        recursiveCallContainer.directStatement("@SuppressWarnings(\"unchecked\")");
        JVar inputMapVar = recursiveCallContainer.decl(8, (JType)mapType, "inputMap", (JExpression)JExpr.cast((JType)mapType, (JExpression)recursiveCallSource));
        recursiveCallContainer.invoke((JExpression)recursiveCallTarget, "fromMap").arg((JExpression)inputMapVar);
    }

    private void changeBuilder(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JFieldVar classMemberField) {
        JInvocation invocation;
        JDefinedClass builderClass = this.getOrGenerateBuilder();
        JInvocation init = isOneToMany ? this.codeModel.ref(Lists.class).staticInvoke("newArrayList") : null;
        String classMemberName = classMemberField.name();
        JType returnType = classMemberField.type();
        JFieldVar buildField = builderClass.field(4, returnType, classMemberName, (JExpression)init);
        JMethod origMethod = builderClass.method(4, (JType)builderClass, classMemberName);
        JVar origMethodVal = origMethod.param(8, returnType, "cloudSdkValue");
        if (isOneToMany) {
            origMethod.body().invoke((JExpression)buildField, "addAll").arg((JExpression)origMethodVal);
        } else {
            origMethod.body().assign((JAssignmentTarget)buildField, (JExpression)origMethodVal);
        }
        origMethod.body()._return(JExpr._this());
        String builderFieldName = navigationProperty.getJavaMethodNameSetBuilder();
        JMethod fixedMethod = builderClass.method(1, (JType)builderClass, builderFieldName);
        if (isOneToMany) {
            fixedMethodParam = fixedMethod.varParam((JType)associatedEntity, "cloudSdkValue");
            invocation = JExpr.invoke((JMethod)origMethod).arg((JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList").arg((JExpression)fixedMethodParam));
            fixedMethod.javadoc().addParam(fixedMethodParam).add((Object)String.format("The %ss to build this %s with.", associatedEntity.name(), this.entityClass.name()));
        } else {
            fixedMethodParam = fixedMethod.param(8, (JType)associatedEntity, "cloudSdkValue");
            invocation = JExpr.invoke((JMethod)origMethod).arg((JExpression)fixedMethodParam);
            fixedMethod.javadoc().addParam(fixedMethodParam).add((Object)String.format("The %s to build this %s with.", associatedEntity.name(), this.entityClass.name()));
        }
        fixedMethod.body()._return((JExpression)invocation);
        fixedMethod.annotate(Nonnull.class);
        fixedMethod.javadoc().add((Object)classMemberField.javadoc());
        fixedMethod.javadoc().addReturn().add((Object)"This Builder to allow for a fluent interface.");
        JFieldVar originalField = (JFieldVar)this.entityClass.fields().get(builderFieldName);
        if (originalField != null) {
            this.provideBuilderMethodFromField(builderClass, originalField);
        }
    }

    private JDefinedClass getOrGenerateBuilder() {
        JDefinedClass builderCLass = null;
        String builderName = this.entityClass.name() + "Builder";
        Iterator it = this.entityClass.classes();
        while (it.hasNext()) {
            JDefinedClass cl = (JDefinedClass)it.next();
            if (!cl.name().equals(builderName)) continue;
            builderCLass = cl;
            break;
        }
        if (builderCLass == null) {
            try {
                builderCLass = this.entityClass._class(25, builderName);
                builderCLass.javadoc().add((Object)String.format("Helper class to allow for fluent creation of %s instances.", this.entityClass.name()));
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorException(String.format("Builder class does already exist for entity \"%s\".", this.entityClass.name()), e);
            }
        }
        return builderCLass;
    }

    private void provideBuilderMethodFromField(JDefinedClass builderClass, JFieldVar originalField) {
        JType origType = originalField.type();
        String origName = originalField.name();
        JMethod originalMethod = builderClass.method(1, (JType)builderClass, origName);
        JFieldVar origBuildField = builderClass.field(4, origType, origName, JExpr._null());
        JVar originalMethodParameter = originalMethod.param(8, origType, "cloudSdkValue");
        originalMethod.javadoc().add((Object)originalField.javadoc());
        originalMethod.body().assign((JAssignmentTarget)origBuildField, (JExpression)originalMethodParameter);
        originalMethod.body()._return(JExpr._this());
        originalMethod.annotate(Nonnull.class);
        originalMethod.javadoc().addReturn().add((Object)"This Builder to allow for a fluent interface.");
        originalMethod.javadoc().addParam(originalMethodParameter.name()).add((Object)String.format("The %s to build this %s with.", origName, this.entityClass.name()));
    }
}

