/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator;

import com.sap.cloud.sdk.datamodel.odatav4.generator.ApiFunction;
import com.sap.cloud.sdk.datamodel.odatav4.generator.Multiplicity;
import com.sap.cloud.sdk.datamodel.odatav4.generator.TypeKind;
import io.vavr.control.Option;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmOperation;

interface Service {
    public static final String SERVICE_MAPPINGS_PACKAGE_SUFFIX = ".packageName";
    public static final String SERVICE_MAPPINGS_CLASS_SUFFIX = ".className";

    public String getTitle();

    public boolean isDeprecated();

    public Option<DeprecationInfo> getDeprecationInfo();

    public String getServiceUrl();

    public EntitySet getEntitySet(String var1);

    public Collection<EntitySet> getAllEntitySets();

    public Collection<ServiceFunction> getServiceFunction(String var1);

    public Collection<ServiceFunction> getAllServiceFunctions();

    public Collection<ServiceBoundFunction> getAllServiceBoundFunctions();

    public Collection<ServiceBoundAction> getAllServiceBoundActions();

    public Collection<ServiceAction> getServiceAction(String var1);

    public Collection<ServiceAction> getAllServiceActions();

    public String getJavaPackageName();

    public String getName();

    public String getJavaClassName();

    public String getInfoDescription();

    public String getInfoVersion();

    public String getMinErpVersion();

    public String getExternalUrl();

    public String getExternalDescription();

    public Collection<ExternalOverview> getExternalOverview();

    public Collection<ApiFunction> getAllowedFunctionsByEntity(String var1);

    public boolean hasLinkToApiBusinessHub();

    public static interface ServiceAction
    extends ServiceOperation {
    }

    public static interface ServiceBoundAction
    extends ServiceBoundOperation {
        @Nonnull
        public EdmAction getBoundAction();
    }

    public static interface ServiceBoundFunction
    extends ServiceBoundOperation {
        @Nonnull
        public EdmFunction getBoundFunction();
    }

    public static interface ServiceBoundOperation
    extends ServiceOperation {
        @Nonnull
        public EdmOperation getOperation();

        public boolean isFunction();
    }

    public static interface ServiceFunction
    extends ServiceOperation {
    }

    public static interface ServiceOperation
    extends Annotatable {
        public String getName();

        @Nullable
        public ReturnType getReturnType();

        public String getHttpMethod();

        public Collection<String> getParameterNames();

        public Parameter getParameter(String var1);
    }

    public static interface EntitySet
    extends Annotatable {
        public String getName();

        public EntityType getEntityType();
    }

    public static interface EntityType
    extends StructuralType {
        public Collection<String> getKeyPropertyNames();

        public Collection<String> getNavigationPropertyNames();

        public NavigationProperty getNavigationProperty(String var1);

        public boolean hasMediaStream();

        @Override
        default public TypeKind getKind() {
            return TypeKind.ENTITY;
        }
    }

    public static interface ComplexType
    extends StructuralType {
        @Override
        default public TypeKind getKind() {
            return TypeKind.COMPLEX;
        }
    }

    public static interface StructuralType
    extends Type,
    Annotatable {
        public String getFullyQualifiedName();

        public Collection<String> getPropertyNames();

        public Property getProperty(String var1);
    }

    public static interface EnumType
    extends Type,
    Annotatable {
        public String getFullyQualifiedName();

        public Collection<String> getMemberNames();

        public String getMemberValue(String var1);
    }

    public static interface NavigationProperty
    extends Element,
    Annotatable {
    }

    public static interface Property
    extends Element,
    Annotatable {
    }

    public static interface Parameter
    extends Element,
    Annotatable {
    }

    public static interface ReturnType
    extends Element {
    }

    public static interface Element {
        public Type getType();

        public Multiplicity getMultiplicity();

        public Facets getFacets();
    }

    public static interface PrimitiveType
    extends Type {
        public Class<?> getDefaultJavaType();

        @Override
        default public TypeKind getKind() {
            return TypeKind.PRIMITIVE;
        }

        public boolean isSupportedEdmType();
    }

    public static interface Type {
        public String getName();

        public TypeKind getKind();
    }

    public static interface Facets {
        public Boolean isNullable();

        public String getDefaultValue();

        public Integer getMaxLength();

        public Integer getPrecision();

        public Integer getScale();
    }

    public static interface Annotatable {
        public Annotations getAnnotations();
    }

    public static interface Annotations {
        public String getLabel();

        public String getQuickInfo();

        public String getDescription();

        public String getLongDescription();
    }

    public static interface ExternalOverview {
        public String getName();

        public List<String> getValues();
    }

    public static interface DeprecationInfo {
        public Option<String> getSuccessorApi();

        public Option<String> getDeprecationDate();

        public Option<String> getDeprecationRelease();
    }
}

