/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odatav4.generator.annotation;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer;
import com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.AnnotationDefinition;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.AnnotationParameter;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.AnnotationStrategy;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.EntityAnnotationModel;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.EntityPropertyAnnotationModel;
import com.sap.cloud.sdk.datamodel.odatav4.generator.annotation.NavigationPropertyAnnotationModel;
import com.sap.cloud.sdk.result.ElementName;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.slf4j.Logger;

public class DefaultAnnotationStrategy
implements AnnotationStrategy {
    private static final Logger logger = MessageCollector.getLogger(DefaultAnnotationStrategy.class);
    private static final int JAVA_MAXIMUM_ARGUMENTS = 254;
    private static final Map<String, Class<?>> ODATA_GSON_TYPE_ADAPTERS = new HashMap();
    private static final Map<String, Class<?>> ODATA_JACKSON_TYPE_DESERIALIZER = new HashMap();
    private static final Map<String, Class<?>> ODATA_JACKSON_TYPE_SERIALIZER = new HashMap();
    private final String EDM_DECIMAL_TYPE = "Decimal";

    @Override
    @Nonnull
    public Set<AnnotationDefinition> getAnnotationsForEntity(@Nonnull EntityAnnotationModel context) {
        boolean isArgLimitExceeded;
        LinkedHashSet<AnnotationDefinition> result = new LinkedHashSet<AnnotationDefinition>();
        boolean bl = isArgLimitExceeded = context.getNumberOfProperties() > 254;
        if (!isArgLimitExceeded) {
            result.add(new AnnotationDefinition(Builder.class));
        } else {
            logger.info(String.format("  VdmObject class %s has %d properties, which exceeds the Java limit of constructor arguments (%d). Builder will not be available for this entity.", context.getJavaClassName(), context.getNumberOfProperties(), 254));
        }
        result.add(new AnnotationDefinition(Data.class));
        if (!isArgLimitExceeded) {
            result.add(new AnnotationDefinition(NoArgsConstructor.class));
            result.add(new AnnotationDefinition(AllArgsConstructor.class));
        }
        result.add(new AnnotationDefinition(ToString.class, new AnnotationParameter("doNotUseGetters", true), new AnnotationParameter("callSuper", true)));
        result.add(new AnnotationDefinition(EqualsAndHashCode.class, new AnnotationParameter("doNotUseGetters", true), new AnnotationParameter("callSuper", true)));
        result.add(new AnnotationDefinition(JsonAdapter.class, new AnnotationParameter("value", GsonVdmAdapterFactory.class)));
        result.add(new AnnotationDefinition(JsonSerialize.class, new AnnotationParameter("using", JacksonVdmObjectSerializer.class)));
        result.add(new AnnotationDefinition(JsonDeserialize.class, new AnnotationParameter("using", JacksonVdmObjectDeserializer.class)));
        return result;
    }

    @Override
    @Nonnull
    public Set<AnnotationDefinition> getAnnotationsForEntityProperty(@Nonnull EntityPropertyAnnotationModel context) {
        LinkedHashSet<AnnotationDefinition> result = new LinkedHashSet<AnnotationDefinition>();
        result.add(new AnnotationDefinition(Nullable.class));
        result.add(new AnnotationDefinition(ElementName.class, new AnnotationParameter("value", context.getEdmName())));
        if ("Decimal".equalsIgnoreCase(context.getEdmType()) && context.getPrecision() != null) {
            int scale = context.getScale() != null ? context.getScale() : 0;
            result.add(new AnnotationDefinition(DecimalDescriptor.class, new AnnotationParameter("precision", context.getPrecision()), new AnnotationParameter("scale", scale)));
        }
        if (context.isSimpleType()) {
            if (ODATA_JACKSON_TYPE_SERIALIZER.containsKey(context.getEdmType())) {
                result.add(new AnnotationDefinition(JsonSerialize.class, new AnnotationParameter("using", ODATA_JACKSON_TYPE_SERIALIZER.get(context.getEdmType()))));
            }
            if (ODATA_JACKSON_TYPE_DESERIALIZER.containsKey(context.getEdmType())) {
                result.add(new AnnotationDefinition(JsonDeserialize.class, new AnnotationParameter("using", ODATA_JACKSON_TYPE_DESERIALIZER.get(context.getEdmType()))));
            }
            if (ODATA_GSON_TYPE_ADAPTERS.containsKey(context.getEdmType())) {
                result.add(new AnnotationDefinition(JsonAdapter.class, new AnnotationParameter("value", ODATA_GSON_TYPE_ADAPTERS.get(context.getEdmType()))));
            }
        }
        return result;
    }

    @Override
    @Nonnull
    public Set<AnnotationDefinition> getAnnotationsForAssociatedEntity(@Nonnull NavigationPropertyAnnotationModel context) {
        LinkedHashSet<AnnotationDefinition> result = new LinkedHashSet<AnnotationDefinition>();
        result.add(new AnnotationDefinition(ElementName.class, new AnnotationParameter("value", context.getEdmName())));
        if (!context.isManyMultiplicity()) {
            result.add(new AnnotationDefinition(Nullable.class));
        }
        return result;
    }

    @Override
    @Nonnull
    public Set<AnnotationDefinition> getAnnotationsForComplexType(@Nonnull EntityAnnotationModel context) {
        return this.getAnnotationsForEntity(context);
    }

    @Override
    @Nonnull
    public Set<AnnotationDefinition> getAnnotationsForComplexTypeProperty(@Nonnull EntityPropertyAnnotationModel context) {
        return this.getAnnotationsForEntityProperty(context);
    }
}

